/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ModelValidationException;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.jpa.entities.GroupEntity;
import org.keycloak.models.jpa.entities.OrganizationEntity;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.jpa.OrganizationAdapter;
import org.keycloak.utils.StreamsUtil;
import org.keycloak.utils.StringUtil;

public class JpaOrganizationProvider
implements OrganizationProvider {
    private final EntityManager em;
    private final GroupProvider groupProvider;
    private final UserProvider userProvider;
    private final KeycloakSession session;

    public JpaOrganizationProvider(KeycloakSession session) {
        this.session = session;
        this.em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        this.groupProvider = session.groups();
        this.userProvider = session.users();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrganizationModel create(String name) {
        if (StringUtil.isBlank((String)name)) {
            throw new ModelValidationException("Name can not be null");
        }
        if (this.getByName(name) != null) {
            throw new ModelDuplicateException("A organization with the same name already exists.");
        }
        RealmModel realm = this.getRealm();
        OrganizationAdapter adapter = new OrganizationAdapter(realm, this);
        try {
            this.session.setAttribute(OrganizationModel.class.getName(), (Object)adapter);
            GroupModel group = this.createOrganizationGroup(adapter.getId());
            adapter.setGroupId(group.getId());
            adapter.setName(name);
            adapter.setEnabled(true);
            this.em.persist((Object)adapter.getEntity());
        }
        finally {
            this.session.removeAttribute(OrganizationModel.class.getName());
        }
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(OrganizationModel organization) {
        OrganizationEntity entity = this.getEntity(organization.getId());
        try {
            this.session.setAttribute(OrganizationModel.class.getName(), (Object)organization);
            RealmModel realm = this.session.realms().getRealm(this.getRealm().getId());
            if (realm != null) {
                GroupModel group = this.getOrganizationGroup(entity);
                if (group != null) {
                    this.userProvider.getGroupMembersStream(realm, group).forEach(userModel -> this.removeMember(organization, (UserModel)userModel));
                    this.groupProvider.removeGroup(realm, group);
                }
                organization.getIdentityProviders().forEach(model -> this.removeIdentityProvider(organization, (IdentityProviderModel)model));
            }
            this.em.remove((Object)entity);
        }
        finally {
            this.session.removeAttribute(OrganizationModel.class.getName());
        }
        return true;
    }

    public void removeAll() {
        this.getAllStream().forEach(this::remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMember(OrganizationModel organization, UserModel user) {
        this.throwExceptionIfObjectIsNull(organization, "Organization");
        this.throwExceptionIfObjectIsNull(user, "User");
        OrganizationEntity entity = this.getEntity(organization.getId());
        OrganizationModel current = (OrganizationModel)this.session.getAttribute(OrganizationModel.class.getName());
        if (this.session.users().getUserById(this.session.realms().getRealm(entity.getRealmId()), user.getId()) == null) {
            return false;
        }
        if (current == null) {
            this.session.setAttribute(OrganizationModel.class.getName(), (Object)organization);
        }
        try {
            GroupModel group = this.getOrganizationGroup(entity);
            if (user.isMemberOf(group)) {
                boolean bl = false;
                return bl;
            }
            if (user.getFirstAttribute("kc.org") != null) {
                throw new ModelException("User [" + user.getId() + "] is a member of a different organization");
            }
            user.joinGroup(group);
            user.setSingleAttribute("kc.org", entity.getId());
        }
        finally {
            if (current == null) {
                this.session.removeAttribute(OrganizationModel.class.getName());
            }
        }
        return true;
    }

    public OrganizationModel getById(String id) {
        OrganizationEntity entity = this.getEntity(id, false);
        return entity == null ? null : new OrganizationAdapter(this.getRealm(), entity, this);
    }

    public OrganizationModel getByDomainName(String domain) {
        TypedQuery query = this.em.createNamedQuery("getByDomainName", OrganizationEntity.class);
        RealmModel realm = this.getRealm();
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("name", (Object)domain.toLowerCase());
        try {
            OrganizationEntity entity = (OrganizationEntity)query.getSingleResult();
            return new OrganizationAdapter(realm, entity, this);
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    public Stream<OrganizationModel> getAllStream(String search, Boolean exact, Integer first, Integer max) {
        TypedQuery query;
        if (StringUtil.isBlank((String)search)) {
            query = this.em.createNamedQuery("getByRealm", OrganizationEntity.class);
        } else if (Boolean.TRUE.equals(exact)) {
            query = this.em.createNamedQuery("getByNameOrDomain", OrganizationEntity.class);
            query.setParameter("search", (Object)search);
        } else {
            query = this.em.createNamedQuery("getByNameOrDomainContained", OrganizationEntity.class);
            query.setParameter("search", (Object)search.toLowerCase());
        }
        RealmModel realm = this.getRealm();
        query.setParameter("realmId", (Object)realm.getId());
        return StreamsUtil.closing(PaginationUtils.paginateQuery(query, first, max).getResultStream().map(entity -> new OrganizationAdapter(realm, (OrganizationEntity)entity, this)));
    }

    public Stream<OrganizationModel> getAllStream(Map<String, String> attributes, Integer first, Integer max) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(OrganizationEntity.class);
        Root org = query.from(OrganizationEntity.class);
        Root group = query.from(GroupEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        RealmModel realm = this.getRealm();
        predicates.add(builder.equal((Expression)org.get("realmId"), (Object)realm.getId()));
        predicates.add(builder.equal((Expression)org.get("groupId"), (Expression)group.get("id")));
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (!StringUtil.isNotBlank((String)entry.getKey())) continue;
            Join groupJoin = group.join("attributes");
            Predicate attrNamePredicate = builder.equal((Expression)groupJoin.get("name"), (Object)entry.getKey());
            Predicate attrValuePredicate = builder.equal((Expression)groupJoin.get("value"), (Object)entry.getValue());
            predicates.add(builder.and((Expression)attrNamePredicate, (Expression)attrValuePredicate));
        }
        Predicate finalPredicate = builder.and(predicates.toArray(new Predicate[0]));
        TypedQuery typedQuery = this.em.createQuery(query.select((Selection)org).where((Expression)finalPredicate));
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery(typedQuery, first, max).getResultStream()).map(entity -> new OrganizationAdapter(realm, (OrganizationEntity)entity, this));
    }

    public Stream<UserModel> getMembersStream(OrganizationModel organization, String search, Boolean exact, Integer first, Integer max) {
        this.throwExceptionIfObjectIsNull(organization, "Organization");
        GroupModel group = this.getOrganizationGroup(organization);
        return this.userProvider.getGroupMembersStream(this.getRealm(), group, search, exact, first, max);
    }

    public UserModel getMemberById(OrganizationModel organization, String id) {
        this.throwExceptionIfObjectIsNull(organization, "Organization");
        UserModel user = this.userProvider.getUserById(this.getRealm(), id);
        if (user == null) {
            return null;
        }
        String orgId = user.getFirstAttribute("kc.org");
        if (organization.getId().equals(orgId)) {
            return user;
        }
        return null;
    }

    public OrganizationModel getByMember(UserModel member) {
        this.throwExceptionIfObjectIsNull(member, "User");
        String orgId = member.getFirstAttribute("kc.org");
        if (orgId == null) {
            return null;
        }
        return this.getById(orgId);
    }

    public boolean addIdentityProvider(OrganizationModel organization, IdentityProviderModel identityProvider) {
        this.throwExceptionIfObjectIsNull(organization, "Organization");
        this.throwExceptionIfObjectIsNull(identityProvider, "Identity provider");
        OrganizationEntity organizationEntity = this.getEntity(organization.getId());
        if (!this.checkOrgIdpAndRealm(organizationEntity, identityProvider)) {
            return false;
        }
        String orgId = identityProvider.getOrganizationId();
        if (organizationEntity.getId().equals(orgId)) {
            return false;
        }
        if (orgId != null) {
            throw new ModelValidationException("Identity provider already associated with a different organization");
        }
        identityProvider.setOrganizationId(organizationEntity.getId());
        this.getRealm().updateIdentityProvider(identityProvider);
        return true;
    }

    public Stream<IdentityProviderModel> getIdentityProviders(OrganizationModel organization) {
        this.throwExceptionIfObjectIsNull(organization, "Organization");
        this.throwExceptionIfObjectIsNull(organization.getId(), "Organization ID");
        OrganizationEntity organizationEntity = this.getEntity(organization.getId());
        return this.getRealm().getIdentityProvidersStream().filter(model -> organizationEntity.getId().equals(model.getOrganizationId()));
    }

    public boolean removeIdentityProvider(OrganizationModel organization, IdentityProviderModel identityProvider) {
        this.throwExceptionIfObjectIsNull(organization, "Organization");
        OrganizationEntity organizationEntity = this.getEntity(organization.getId());
        if (!organizationEntity.getId().equals(identityProvider.getOrganizationId())) {
            return false;
        }
        identityProvider.setOrganizationId(null);
        identityProvider.getConfig().remove("kc.org.domain");
        identityProvider.getConfig().remove("kc.org.broker.public");
        this.getRealm().updateIdentityProvider(identityProvider);
        return true;
    }

    public boolean isManagedMember(OrganizationModel organization, UserModel member) {
        this.throwExceptionIfObjectIsNull(organization, "organization");
        if (member == null) {
            return false;
        }
        List brokers = organization.getIdentityProviders().toList();
        if (brokers.isEmpty()) {
            return false;
        }
        RealmModel realm = this.getRealm();
        List<FederatedIdentityModel> federatedIdentities = this.userProvider.getFederatedIdentitiesStream(realm, member).map(federatedIdentityModel -> realm.getIdentityProviderByAlias(federatedIdentityModel.getIdentityProvider())).filter(brokers::contains).map(m -> this.userProvider.getFederatedIdentity(realm, member, m.getAlias())).toList();
        return !federatedIdentities.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMember(OrganizationModel organization, UserModel member) {
        this.throwExceptionIfObjectIsNull(organization, "organization");
        this.throwExceptionIfObjectIsNull(member, "member");
        OrganizationModel userOrg = this.getByMember(member);
        if (userOrg == null || !userOrg.equals((Object)organization)) {
            return false;
        }
        if (this.isManagedMember(organization, member)) {
            this.userProvider.removeUser(this.getRealm(), member);
        } else {
            OrganizationModel current = (OrganizationModel)this.session.getAttribute(OrganizationModel.class.getName());
            if (current == null) {
                this.session.setAttribute(OrganizationModel.class.getName(), (Object)organization);
            }
            try {
                List organizations = (List)member.getAttributes().get("kc.org");
                organizations.remove(organization.getId());
                member.setAttribute("kc.org", organizations);
                member.leaveGroup(this.getOrganizationGroup(organization));
            }
            finally {
                if (current == null) {
                    this.session.removeAttribute(OrganizationModel.class.getName());
                }
            }
        }
        return true;
    }

    public long count() {
        TypedQuery query = this.em.createNamedQuery("getCount", Long.class);
        query.setParameter("realmId", (Object)this.getRealm().getId());
        return (Long)query.getSingleResult();
    }

    public boolean isEnabled() {
        return this.getRealm().isOrganizationsEnabled();
    }

    public void close() {
    }

    private OrganizationEntity getEntity(String id) {
        return this.getEntity(id, true);
    }

    private OrganizationEntity getEntity(String id, boolean failIfNotFound) {
        OrganizationEntity entity = (OrganizationEntity)this.em.find(OrganizationEntity.class, (Object)id);
        if (entity == null) {
            if (failIfNotFound) {
                throw new ModelException("Organization [" + id + "] does not exist");
            }
            return null;
        }
        RealmModel realm = this.getRealm();
        if (!realm.getId().equals(entity.getRealmId())) {
            throw new ModelException("Organization [" + entity.getId() + "] does not belong to realm [" + realm.getId() + "]");
        }
        return entity;
    }

    private GroupModel createOrganizationGroup(String orgId) {
        GroupModel group = this.groupProvider.createGroup(this.getRealm(), null, orgId);
        group.setSingleAttribute("kc.org", orgId);
        return group;
    }

    private GroupModel getOrganizationGroup(OrganizationModel organization) {
        this.throwExceptionIfObjectIsNull(organization, "Organization");
        OrganizationEntity entity = this.getEntity(organization.getId());
        GroupModel group = this.getOrganizationGroup(entity);
        if (group == null) {
            throw new ModelException("Organization group " + entity.getGroupId() + " not found");
        }
        return group;
    }

    private GroupModel getOrganizationGroup(OrganizationEntity entity) {
        return this.groupProvider.getGroupById(this.getRealm(), entity.getGroupId());
    }

    private void throwExceptionIfObjectIsNull(Object object, String objectName) {
        if (object == null) {
            throw new ModelException(String.format("%s cannot be null", objectName));
        }
    }

    private OrganizationEntity getByName(String name) {
        TypedQuery query = this.em.createNamedQuery("getByOrgName", OrganizationEntity.class);
        query.setParameter("name", (Object)name);
        query.setParameter("realmId", (Object)this.getRealm().getId());
        try {
            return (OrganizationEntity)query.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    private boolean checkOrgIdpAndRealm(OrganizationEntity orgEntity, IdentityProviderModel idp) {
        RealmModel orgRealm = this.session.realms().getRealm(orgEntity.getRealmId());
        IdentityProviderModel orgIdpByAlias = orgRealm.getIdentityProviderByAlias(idp.getAlias());
        return orgIdpByAlias != null && orgIdpByAlias.getInternalId().equals(idp.getInternalId());
    }

    private RealmModel getRealm() {
        RealmModel realm = this.session.getContext().getRealm();
        if (realm == null) {
            throw new IllegalArgumentException("Session not bound to a realm");
        }
        return realm;
    }
}

