/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.enums;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.keycloak.common.ClientConnection;

public enum SslRequired {
    ALL,
    EXTERNAL,
    NONE;


    public boolean isRequired(ClientConnection connection) {
        return this.isRequired(connection.getRemoteAddr());
    }

    public boolean isRequired(String address) {
        switch (this.ordinal()) {
            case 0: {
                return true;
            }
            case 2: {
                return false;
            }
            case 1: {
                return !this.isLocal(address);
            }
        }
        return true;
    }

    private boolean isLocal(String remoteAddress) {
        try {
            InetAddress inetAddress = InetAddress.getByName(remoteAddress);
            return inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isSiteLocalAddress();
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

