/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import java.util.Stack;
import picocli.CommandLine;

public final class PropertyMapperParameterConsumer
implements CommandLine.IParameterConsumer {
    static final CommandLine.IParameterConsumer INSTANCE = new PropertyMapperParameterConsumer();

    private PropertyMapperParameterConsumer() {
    }

    public void consumeParameters(Stack<String> args, CommandLine.Model.ArgSpec argSpec, CommandLine.Model.CommandSpec commandSpec) {
        if (argSpec instanceof CommandLine.Model.OptionSpec) {
            this.validateOption(args, argSpec, commandSpec);
        }
    }

    private void validateOption(Stack<String> args, CommandLine.Model.ArgSpec argSpec, CommandLine.Model.CommandSpec commandSpec) {
        CommandLine.Model.OptionSpec option = (CommandLine.Model.OptionSpec)argSpec;
        String name = String.join((CharSequence)", ", option.names());
        CommandLine commandLine = commandSpec.commandLine();
        if (args.isEmpty() || !this.isOptionValue(args.peek())) {
            throw new CommandLine.ParameterException(commandLine, "Missing required value. " + this.getExpectedMessage(argSpec, option, name));
        }
        args.pop();
        if (!args.isEmpty() && this.isOptionValue(args.peek())) {
            throw new CommandLine.ParameterException(commandLine, this.getExpectedMessage(argSpec, option, name));
        }
    }

    private String getExpectedMessage(CommandLine.Model.ArgSpec argSpec, CommandLine.Model.OptionSpec option, String name) {
        return String.format("Option '%s' (%s) expects %s.%s", name, argSpec.paramLabel(), option.typeInfo().isMultiValue() ? "one or more comma separated values without whitespace" : "a single value", PropertyMapperParameterConsumer.getExpectedValuesMessage(argSpec.completionCandidates(), option.completionCandidates()));
    }

    private boolean isOptionValue(String arg) {
        return !arg.startsWith("--") && !arg.startsWith("-");
    }

    public static String getExpectedValuesMessage(Iterable<String> specCandidates, Iterable<String> optionCandidates) {
        return optionCandidates.iterator().hasNext() ? " Expected values are: " + String.join((CharSequence)", ", specCandidates) : "";
    }
}

