/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.fips;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.keycloak.common.crypto.PemUtilsProvider;
import org.keycloak.common.util.BouncyIntegration;
import org.keycloak.common.util.PemException;
import org.keycloak.common.util.PemUtils;

public class BCFIPSPemUtilsProvider
extends PemUtilsProvider {
    protected String encode(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter();
            JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
            pemWriter.writeObject(obj);
            pemWriter.flush();
            pemWriter.close();
            String s = writer.toString();
            return this.removeBeginEnd(s);
        }
        catch (Exception e) {
            throw new PemException((Throwable)e);
        }
    }

    public PrivateKey decodePrivateKey(String pem) {
        if (pem == null) {
            return null;
        }
        try {
            PrivateKeyInfo privateKeyInfo;
            Object parsedPk;
            boolean beginEndAvailable = pem.startsWith("-----BEGIN");
            if (beginEndAvailable) {
                parsedPk = this.readPrivateKeyObject(pem);
            } else {
                try {
                    String rsaPem = PemUtils.addRsaPrivateKeyBeginEnd((String)pem);
                    parsedPk = this.readPrivateKeyObject(rsaPem);
                }
                catch (IOException ioe) {
                    pem = PemUtils.addPrivateKeyBeginEnd((String)pem);
                    parsedPk = this.readPrivateKeyObject(pem);
                }
            }
            if (parsedPk instanceof PEMKeyPair) {
                PEMKeyPair pemKeyPair = (PEMKeyPair)parsedPk;
                privateKeyInfo = pemKeyPair.getPrivateKeyInfo();
            } else if (parsedPk instanceof PrivateKeyInfo) {
                privateKeyInfo = (PrivateKeyInfo)parsedPk;
            } else {
                throw new IllegalStateException("Unknown type returned by PEMParser when parsing private key: " + String.valueOf(parsedPk.getClass()));
            }
            return new JcaPEMKeyConverter().setProvider(BouncyIntegration.PROVIDER).getPrivateKey(privateKeyInfo);
        }
        catch (Exception e) {
            throw new PemException((Throwable)e);
        }
    }

    private Object readPrivateKeyObject(String pemWithBeginEnd) throws IOException {
        PEMParser parser = new PEMParser((Reader)new StringReader(pemWithBeginEnd));
        return parser.readObject();
    }
}

