/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import com.intellij.psi.PsiFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.lower.ParsedJvmFileClassAnnotations;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.JvmMultifileClassPartInfo;
import org.jetbrains.kotlin.fileClasses.JvmSimpleFileClassInfo;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.PsiIrFileEntry;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0016\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u001a\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"getFileClassInfo", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getFileClassInfoFromIrFile", "file", "fileName", "", "parseJvmNameOnFileNoResolve", "Lorg/jetbrains/kotlin/backend/jvm/lower/ParsedJvmFileClassAnnotations;", "findAnnotationEntryOnFileNoResolve", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "shortName", "getLiteralStringFromAnnotation", "annotationCall", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nFileClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FileClassLoweringKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,211:1\n1#2:212\n295#3,2:213\n*S KotlinDebug\n*F\n+ 1 FileClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/FileClassLoweringKt\n*L\n196#1:213,2\n*E\n"})
public final class FileClassLoweringKt {
    @NotNull
    public static final JvmFileClassInfo getFileClassInfo(@NotNull IrFile $this$getFileClassInfo) {
        JvmFileClassInfo jvmFileClassInfo;
        Intrinsics.checkNotNullParameter($this$getFileClassInfo, "<this>");
        IrFileEntry fileEntry = $this$getFileClassInfo.getFileEntry();
        if (fileEntry instanceof PsiIrFileEntry) {
            PsiFile psiFile = ((PsiIrFileEntry)fileEntry).getPsiFile();
            Intrinsics.checkNotNull(psiFile, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            jvmFileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)psiFile);
        } else if (fileEntry instanceof NaiveSourceBasedFileEntryImpl) {
            String string2 = new File(((NaiveSourceBasedFileEntryImpl)fileEntry).getName()).getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            jvmFileClassInfo = FileClassLoweringKt.getFileClassInfoFromIrFile($this$getFileClassInfo, string2);
        } else {
            throw new IllegalStateException(("unknown kind of file entry: " + fileEntry).toString());
        }
        return jvmFileClassInfo;
    }

    @NotNull
    public static final JvmFileClassInfo getFileClassInfoFromIrFile(@NotNull IrFile file2, @NotNull String fileName) {
        JvmFileClassInfo jvmFileClassInfo;
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        ParsedJvmFileClassAnnotations parsedAnnotations = FileClassLoweringKt.parseJvmNameOnFileNoResolve(file2);
        Object object = parsedAnnotations;
        if (object == null || (object = ((ParsedJvmFileClassAnnotations)object).getJvmPackageName()) == null) {
            object = file2.getPackageFqName();
        }
        Object packageFqName = object;
        if (parsedAnnotations != null) {
            String string2 = parsedAnnotations.getJvmName();
            if (string2 == null) {
                string2 = PackagePartClassUtils.getFilePartShortName(fileName);
            }
            String simpleName = string2;
            FqName fqName = ((FqName)packageFqName).child(Name.identifier(simpleName));
            Intrinsics.checkNotNullExpressionValue(fqName, "child(...)");
            FqName facadeClassFqName = fqName;
            if (parsedAnnotations.isMultifileClass()) {
                FqName fqName2 = ((FqName)packageFqName).child(Name.identifier(JvmFileClassUtil.manglePartName(simpleName, fileName)));
                Intrinsics.checkNotNullExpressionValue(fqName2, "child(...)");
                jvmFileClassInfo = new JvmMultifileClassPartInfo(fqName2, facadeClassFqName);
            } else {
                jvmFileClassInfo = new JvmSimpleFileClassInfo(facadeClassFqName, true);
            }
        } else {
            jvmFileClassInfo = new JvmSimpleFileClassInfo(PackagePartClassUtils.getPackagePartFqName((FqName)packageFqName, fileName), false);
        }
        return jvmFileClassInfo;
    }

    /*
     * Unable to fully structure code
     */
    private static final ParsedJvmFileClassAnnotations parseJvmNameOnFileNoResolve(IrFile file) {
        jvmNameAnnotation = FileClassLoweringKt.findAnnotationEntryOnFileNoResolve(file, JvmStandardClassIds.INSTANCE.getJVM_NAME_SHORT());
        v0 = jvmNameAnnotation;
        if (v0 == null) ** GOTO lbl-1000
        p0 = v0;
        $i$a$-let-FileClassLoweringKt$parseJvmNameOnFileNoResolve$jvmName$1 = false;
        v1 = FileClassLoweringKt.getLiteralStringFromAnnotation((IrConstructorCall)p0);
        v0 = v1;
        if (v1 != null) {
            p0 = var4_5 = v0;
            $i$a$-takeIf-FileClassLoweringKt$parseJvmNameOnFileNoResolve$jvmName$2 = false;
            v2 = Name.isValidIdentifier((String)p0) ? var4_5 : null;
        } else lbl-1000:
        // 2 sources

        {
            v2 = jvmName = null;
        }
        if ((v3 = (jvmPackageNameAnnotation = FileClassLoweringKt.findAnnotationEntryOnFileNoResolve(file, JvmStandardClassIds.INSTANCE.getJVM_PACKAGE_NAME_SHORT()))) == null) ** GOTO lbl-1000
        p0 = v3;
        $i$a$-let-FileClassLoweringKt$parseJvmNameOnFileNoResolve$jvmPackageName$1 = false;
        v4 = FileClassLoweringKt.getLiteralStringFromAnnotation((IrConstructorCall)p0);
        v3 = v4;
        if (v4 != null) {
            p0 = v3;
            $i$a$-let-FileClassLoweringKt$parseJvmNameOnFileNoResolve$jvmPackageName$2 = false;
            v5 = new FqName((String)p0);
        } else lbl-1000:
        // 2 sources

        {
            v5 = jvmPackageName = null;
        }
        if (jvmName == null && jvmPackageName == null) {
            return null;
        }
        isMultifileClass = FileClassLoweringKt.findAnnotationEntryOnFileNoResolve(file, JvmStandardClassIds.INSTANCE.getJVM_MULTIFILE_CLASS_SHORT()) != null;
        return new ParsedJvmFileClassAnnotations((String)jvmName, jvmPackageName, isMultifileClass);
    }

    private static final IrConstructorCall findAnnotationEntryOnFileNoResolve(IrFile file2, String shortName) {
        Object v1;
        block1: {
            Iterable $this$firstOrNull$iv = file2.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IrConstructorCall it = (IrConstructorCall)element$iv;
                boolean bl = false;
                Object object = IrTypesKt.getClassFqName(it.getType());
                if (!Intrinsics.areEqual(object != null && (object = ((FqName)object).shortName()) != null ? ((Name)object).asString() : null, shortName)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final String getLiteralStringFromAnnotation(IrConstructorCall annotationCall) {
        String string2;
        if (annotationCall.getValueArgumentsCount() < 1) {
            return null;
        }
        IrExpression irExpression = annotationCall.getValueArgument(0);
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl = false;
            if (it instanceof IrConst && Intrinsics.areEqual(((IrConst)it).getKind(), IrConstKind.String.INSTANCE)) {
                Object t = ((IrConst)it).getValue();
                Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.String");
                string2 = (String)t;
            } else {
                string2 = null;
            }
        } else {
            string2 = null;
        }
        return string2;
    }
}

