/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors.components;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.declarations.FirErrorPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.FirErrorProperty;
import org.jetbrains.kotlin.fir.diagnostics.ConeAmbiguousSuper;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSyntaxDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirErrorAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInstanceAccessBeforeSuperCall;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\rH\u0002J\u000e\u0010#\u001a\u00020$*\u0004\u0018\u00010%H\u0002J\u0018\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020(2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020+2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u0002012\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u00102\u001a\u00020\t2\u0006\u00103\u001a\u0002042\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u00105\u001a\u00020\t2\u0006\u00106\u001a\u0002072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020:2\u0006\u0010\f\u001a\u00020\rH\u0016J.\u0010;\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010\"\u001a\u00020\r2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010=H\u0002\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/components/ErrorNodeDiagnosticCollectorComponent;", "Lorg/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "visitErrorLoop", "", "errorLoop", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorLoop;", "data", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "visitErrorTypeRef", "errorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "visitResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "visitErrorAnnotationCall", "errorAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorAnnotationCall;", "visitErrorNamedReference", "errorNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirErrorNamedReference;", "visitResolvedErrorReference", "resolvedErrorReference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedErrorReference;", "processErrorReference", "reference", "Lorg/jetbrains/kotlin/fir/references/FirNamedReference;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "context", "cannotBeResolved", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "visitErrorExpression", "errorExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorExpression;", "visitErrorFunction", "errorFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorFunction;", "visitErrorProperty", "errorProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorProperty;", "visitErrorResolvedQualifier", "errorResolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorResolvedQualifier;", "visitErrorPrimaryConstructor", "errorPrimaryConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorPrimaryConstructor;", "visitThisReference", "thisReference", "Lorg/jetbrains/kotlin/fir/references/FirThisReference;", "visitVarargArgumentsExpression", "varargArgumentsExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;", "reportFirDiagnostic", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "callOrAssignmentSource", "checkers"})
public final class ErrorNodeDiagnosticCollectorComponent
extends AbstractDiagnosticCollectorComponent {
    public ErrorNodeDiagnosticCollectorComponent(@NotNull FirSession session2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        super(session2, reporter);
    }

    @Override
    public void visitErrorLoop(@NotNull FirErrorLoop errorLoop, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(errorLoop, "errorLoop");
        Intrinsics.checkNotNullParameter(data, "data");
        KtSourceElement source = errorLoop.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorLoop.getDiagnostic(), source, data, null, 8, null);
    }

    @Override
    public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(errorTypeRef, "errorTypeRef");
        Intrinsics.checkNotNullParameter(data, "data");
        KtSourceElement source = errorTypeRef.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorTypeRef.getDiagnostic(), source, data, null, 8, null);
    }

    @Override
    public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull CheckerContext data) {
        boolean bl;
        Intrinsics.checkNotNullParameter(resolvedTypeRef, "resolvedTypeRef");
        Intrinsics.checkNotNullParameter(data, "data");
        boolean bl2 = bl = !(resolvedTypeRef.getType() instanceof ConeErrorType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Instead use FirErrorTypeRef for " + ConeTypeUtilsKt.renderForDebugging(resolvedTypeRef.getType());
            throw new AssertionError((Object)string2);
        }
    }

    @Override
    public void visitErrorAnnotationCall(@NotNull FirErrorAnnotationCall errorAnnotationCall, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(errorAnnotationCall, "errorAnnotationCall");
        Intrinsics.checkNotNullParameter(data, "data");
        KtSourceElement source = errorAnnotationCall.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorAnnotationCall.getDiagnostic(), source, data, null, 8, null);
    }

    @Override
    public void visitErrorNamedReference(@NotNull FirErrorNamedReference errorNamedReference, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(errorNamedReference, "errorNamedReference");
        Intrinsics.checkNotNullParameter(data, "data");
        this.processErrorReference(errorNamedReference, errorNamedReference.getDiagnostic(), data);
    }

    @Override
    public void visitResolvedErrorReference(@NotNull FirResolvedErrorReference resolvedErrorReference, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(resolvedErrorReference, "resolvedErrorReference");
        Intrinsics.checkNotNullParameter(data, "data");
        this.processErrorReference(resolvedErrorReference, resolvedErrorReference.getDiagnostic(), data);
    }

    private final void processErrorReference(FirNamedReference reference2, ConeDiagnostic diagnostic, CheckerContext context) {
        FirStatement firStatement;
        KtSourceElement source = reference2.getSource();
        FirStatement firStatement2 = CollectionsKt.lastOrNull(context.getCallsOrAssignments());
        if (firStatement2 != null) {
            FirStatement firStatement3;
            FirStatement it = firStatement3 = firStatement2;
            boolean bl = false;
            firStatement = Intrinsics.areEqual(ReferenceUtilsKt.toReference(it, this.getSession()), reference2) ? firStatement3 : null;
        } else {
            firStatement = null;
        }
        FirStatement callOrAssignment = firStatement;
        KtSourceElement ktSourceElement = source;
        if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getElementType() : null, KtNodeTypes.ANNOTATION_ENTRY) && diagnostic instanceof ConeUnresolvedNameError) {
            return;
        }
        KtSourceElement ktSourceElement2 = source;
        if (Intrinsics.areEqual(ktSourceElement2 != null ? ktSourceElement2.getKind() : null, KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE) && diagnostic instanceof ConeUnresolvedNameError) {
            return;
        }
        if (callOrAssignment instanceof FirQualifiedAccessExpression && (this.cannotBeResolved(((FirQualifiedAccessExpression)callOrAssignment).getDispatchReceiver()) || this.cannotBeResolved(((FirQualifiedAccessExpression)callOrAssignment).getExtensionReceiver()) || this.cannotBeResolved(((FirQualifiedAccessExpression)callOrAssignment).getExplicitReceiver()))) {
            return;
        }
        KtSourceElement ktSourceElement3 = source;
        source = ktSourceElement3 != null ? SourceHelpersKt.delegatedPropertySourceOrThis(ktSourceElement3, context) : null;
        FirStatement firStatement4 = callOrAssignment;
        this.reportFirDiagnostic(diagnostic, source, context, firStatement4 != null ? firStatement4.getSource() : null);
    }

    private final boolean cannotBeResolved(FirExpression $this$cannotBeResolved) {
        ConeDiagnostic diagnostic;
        FirExpression firExpression = $this$cannotBeResolved;
        ConeKotlinType coneKotlinType = firExpression != null ? FirTypeUtilsKt.getResolvedType(firExpression) : null;
        ConeErrorType coneErrorType = coneKotlinType instanceof ConeErrorType ? (ConeErrorType)coneKotlinType : null;
        ConeDiagnostic coneDiagnostic = diagnostic = coneErrorType != null ? coneErrorType.getDiagnostic() : null;
        return diagnostic instanceof ConeUnresolvedNameError || diagnostic instanceof ConeInstanceAccessBeforeSuperCall || diagnostic instanceof ConeAmbiguousSuper ? true : (diagnostic instanceof ConeSimpleDiagnostic ? ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.NotASupertype || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.SuperNotAvailable || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.UnresolvedLabel || ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.AmbiguousLabel : false);
    }

    @Override
    public void visitErrorExpression(@NotNull FirErrorExpression errorExpression, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(errorExpression, "errorExpression");
        Intrinsics.checkNotNullParameter(data, "data");
        KtSourceElement source = errorExpression.getSource();
        ConeDiagnostic diagnostic = errorExpression.getDiagnostic();
        if (source == null) {
            if (diagnostic instanceof ConeSyntaxDiagnostic) {
                return;
            }
            if (diagnostic instanceof ConeSimpleDiagnostic && ((ConeSimpleDiagnostic)diagnostic).getKind() == DiagnosticKind.ExpressionExpected) {
                return;
            }
        }
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, diagnostic, source, data, null, 8, null);
    }

    @Override
    public void visitErrorFunction(@NotNull FirErrorFunction errorFunction, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(errorFunction, "errorFunction");
        Intrinsics.checkNotNullParameter(data, "data");
        KtSourceElement source = errorFunction.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorFunction.getDiagnostic(), source, data, null, 8, null);
    }

    @Override
    public void visitErrorProperty(@NotNull FirErrorProperty errorProperty, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(errorProperty, "errorProperty");
        Intrinsics.checkNotNullParameter(data, "data");
        KtSourceElement source = errorProperty.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorProperty.getDiagnostic(), source, data, null, 8, null);
    }

    @Override
    public void visitErrorResolvedQualifier(@NotNull FirErrorResolvedQualifier errorResolvedQualifier, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(errorResolvedQualifier, "errorResolvedQualifier");
        Intrinsics.checkNotNullParameter(data, "data");
        KtSourceElement source = errorResolvedQualifier.getSource();
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorResolvedQualifier.getDiagnostic(), source, data, null, 8, null);
    }

    @Override
    public void visitErrorPrimaryConstructor(@NotNull FirErrorPrimaryConstructor errorPrimaryConstructor, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(errorPrimaryConstructor, "errorPrimaryConstructor");
        Intrinsics.checkNotNullParameter(data, "data");
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, errorPrimaryConstructor.getDiagnostic(), errorPrimaryConstructor.getSource(), data, null, 8, null);
    }

    @Override
    public void visitThisReference(@NotNull FirThisReference thisReference, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(thisReference, "thisReference");
        Intrinsics.checkNotNullParameter(data, "data");
        ConeDiagnostic coneDiagnostic = thisReference.getDiagnostic();
        if (coneDiagnostic == null) {
            return;
        }
        ConeDiagnostic diagnostic = coneDiagnostic;
        KtSourceElement ktSourceElement = thisReference.getSource();
        if (ktSourceElement == null) {
            FirElement firElement = CollectionsKt.getOrNull(data.getContainingElements(), 1);
            ktSourceElement = firElement != null ? firElement.getSource() : null;
        }
        KtSourceElement source = ktSourceElement;
        ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, diagnostic, source, data, null, 8, null);
    }

    @Override
    public void visitVarargArgumentsExpression(@NotNull FirVarargArgumentsExpression varargArgumentsExpression, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter(varargArgumentsExpression, "varargArgumentsExpression");
        Intrinsics.checkNotNullParameter(data, "data");
        ConeKotlinType coneKotlinType = varargArgumentsExpression.getConeElementTypeOrNull();
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType elementType = coneKotlinType;
        if (elementType instanceof ConeErrorType) {
            ErrorNodeDiagnosticCollectorComponent.reportFirDiagnostic$default(this, ((ConeErrorType)elementType).getDiagnostic(), varargArgumentsExpression.getSource(), data, null, 8, null);
        }
    }

    private final void reportFirDiagnostic(ConeDiagnostic diagnostic, KtSourceElement source, CheckerContext context, KtSourceElement callOrAssignmentSource) {
        block8: {
            block7: {
                KtSourceElement ktSourceElement = source;
                if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getElementType() : null, KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY)) {
                    return;
                }
                KtSourceElement ktSourceElement2 = source;
                if (Intrinsics.areEqual(ktSourceElement2 != null ? ktSourceElement2.getKind() : null, KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE) && (diagnostic instanceof ConeUnresolvedNameError || diagnostic instanceof ConeAmbiguityError || diagnostic instanceof ConeInapplicableWrongReceiver || diagnostic instanceof ConeInapplicableCandidateError)) {
                    return;
                }
                KtSourceElement ktSourceElement3 = source;
                if (Intrinsics.areEqual(ktSourceElement3 != null ? ktSourceElement3.getKind() : null, KtFakeSourceElementKind.ImplicitConstructor.INSTANCE)) break block7;
                KtSourceElement ktSourceElement4 = source;
                if (!Intrinsics.areEqual(ktSourceElement4 != null ? ktSourceElement4.getKind() : null, KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) break block8;
            }
            return;
        }
        KtSourceElement ktSourceElement = source;
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredPrefixSecondGetReference) {
            return;
        }
        for (KtDiagnostic coneDiagnostic : ConeDiagnosticToFirDiagnosticKt.toFirDiagnostics(diagnostic, this.getSession(), source, callOrAssignmentSource)) {
            this.getReporter().report(coneDiagnostic, context);
        }
    }

    static /* synthetic */ void reportFirDiagnostic$default(ErrorNodeDiagnosticCollectorComponent errorNodeDiagnosticCollectorComponent, ConeDiagnostic coneDiagnostic, KtSourceElement ktSourceElement, CheckerContext checkerContext, KtSourceElement ktSourceElement2, int n, Object object) {
        if ((n & 8) != 0) {
            ktSourceElement2 = null;
        }
        errorNodeDiagnosticCollectorComponent.reportFirDiagnostic(coneDiagnostic, ktSourceElement, checkerContext, ktSourceElement2);
    }
}

