/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\r*\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CallReturnsArrayOfNothingChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "containsArrayOfNothing", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
@SourceDebugExtension(value={"SMAP\nCallReturnsArrayOfNothingChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallReturnsArrayOfNothingChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/CallReturnsArrayOfNothingChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n1755#2,3:40\n*S KotlinDebug\n*F\n+ 1 CallReturnsArrayOfNothingChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/CallReturnsArrayOfNothingChecker\n*L\n36#1:40,3\n*E\n"})
public final class CallReturnsArrayOfNothingChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        if (this.containsArrayOfNothing(resolvedCall2.getResultingDescriptor().getReturnType())) {
            context.getTrace().report(Errors.UNSUPPORTED.on(reportOn, "Array<Nothing> in return type is illegal"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsArrayOfNothing(KotlinType $this$containsArrayOfNothing) {
        boolean bl;
        if ($this$containsArrayOfNothing == null) return false;
        if (CallCheckerKt.isComputingDeferredType(this, $this$containsArrayOfNothing)) {
            return false;
        }
        if (TypeUtilsKt.isArrayOfNothing($this$containsArrayOfNothing)) return true;
        Iterable $this$any$iv = $this$containsArrayOfNothing.getArguments();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            TypeProjection it = (TypeProjection)element$iv;
            boolean bl2 = false;
            if (!it.isStarProjection() && this.containsArrayOfNothing(it.getType())) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }
}

