/* jcat.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Jcat", gir_namespace = "Jcat", gir_version = "1.0", lower_case_cprefix = "jcat_")]
namespace Jcat {
	[CCode (cheader_filename = "jcat.h", type_id = "jcat_blob_get_type ()")]
	public class Blob : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.1.0")]
		public Blob (Jcat.BlobKind kind, GLib.Bytes data);
		[CCode (has_construct_function = false)]
		[Version (since = "0.1.0")]
		public Blob.full (Jcat.BlobKind kind, GLib.Bytes data, Jcat.BlobFlags flags);
		[Version (since = "0.1.0")]
		public unowned string get_appstream_id ();
		[Version (since = "0.1.0")]
		public unowned GLib.Bytes get_data ();
		[Version (since = "0.1.0")]
		public string get_data_as_string ();
		[Version (since = "0.1.0")]
		public Jcat.BlobKind get_kind ();
		[Version (since = "0.2.0")]
		public Jcat.BlobKind get_target ();
		[Version (since = "0.1.0")]
		public int64 get_timestamp ();
		[Version (since = "0.1.0")]
		public static Jcat.BlobKind kind_from_string (string kind);
		[Version (since = "0.1.0")]
		public static unowned string kind_to_filename_ext (Jcat.BlobKind kind);
		[Version (since = "0.1.0")]
		public static unowned string kind_to_string (Jcat.BlobKind kind);
		[Version (since = "0.1.0")]
		public void set_appstream_id (string? appstream_id);
		[Version (since = "0.2.0")]
		public void set_target (Jcat.BlobKind target);
		[Version (since = "0.1.0")]
		public void set_timestamp (int64 timestamp);
		[Version (since = "0.1.0")]
		public string to_string ();
		[CCode (has_construct_function = false)]
		[Version (since = "0.1.0")]
		public Blob.utf8 (Jcat.BlobKind kind, string data);
	}
	[CCode (cheader_filename = "jcat.h", type_id = "jcat_bt_checkpoint_get_type ()")]
	public class BtCheckpoint : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.2.0")]
		public BtCheckpoint (GLib.Bytes blob) throws GLib.Error;
		[Version (since = "0.2.0")]
		public unowned string get_hash ();
		[Version (since = "0.2.0")]
		public unowned string get_identity ();
		[Version (since = "0.2.0")]
		public uint get_log_size ();
		[Version (since = "0.2.0")]
		public unowned string get_origin ();
		[Version (since = "0.2.0")]
		public unowned GLib.Bytes get_payload ();
		[Version (since = "0.2.0")]
		public unowned GLib.Bytes get_pubkey ();
		[Version (since = "0.2.0")]
		public unowned GLib.Bytes get_signature ();
		[Version (since = "0.2.0")]
		public string to_string ();
	}
	[CCode (cheader_filename = "jcat.h", type_id = "jcat_bt_verifier_get_type ()")]
	public class BtVerifier : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.2.0")]
		public BtVerifier (GLib.Bytes blob) throws GLib.Error;
		[Version (since = "0.2.0")]
		public uint8 get_alg ();
		[Version (since = "0.2.0")]
		public unowned string get_hash ();
		[Version (since = "0.2.0")]
		public unowned GLib.Bytes get_key ();
		[Version (since = "0.2.0")]
		public unowned string get_name ();
		[Version (since = "0.2.0")]
		public string to_string ();
	}
	[CCode (cheader_filename = "jcat.h", type_id = "jcat_context_get_type ()")]
	public class Context : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.1.0")]
		public Context ();
		[Version (since = "0.1.0")]
		public void add_public_key (string filename);
		[Version (since = "0.1.0")]
		public void add_public_keys (string path);
		[Version (since = "0.1.12")]
		public void blob_kind_allow (Jcat.BlobKind kind);
		[Version (since = "0.1.12")]
		public void blob_kind_disallow (Jcat.BlobKind kind);
		[Version (since = "0.1.0")]
		public Jcat.Engine get_engine (Jcat.BlobKind kind) throws GLib.Error;
		[Version (since = "0.1.0")]
		public unowned string? get_keyring_path ();
		[Version (since = "0.1.0")]
		public void set_keyring_path (string path);
		[Version (since = "0.1.0")]
		public Jcat.Result verify_blob (GLib.Bytes data, Jcat.Blob blob, Jcat.VerifyFlags flags) throws GLib.Error;
		[Version (since = "0.1.0")]
		public GLib.GenericArray<weak Jcat.Result> verify_item (GLib.Bytes data, Jcat.Item item, Jcat.VerifyFlags flags) throws GLib.Error;
		[Version (since = "0.2.0")]
		public GLib.GenericArray<weak Jcat.Result> verify_target (Jcat.Item item_target, Jcat.Item item, Jcat.VerifyFlags flags) throws GLib.Error;
	}
	[CCode (cheader_filename = "jcat.h", type_id = "jcat_engine_get_type ()")]
	public class Engine : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Engine ();
		[NoWrapper]
		public virtual bool add_public_key (string filename) throws GLib.Error;
		[Version (since = "0.1.9")]
		public virtual bool add_public_key_raw (GLib.Bytes blob) throws GLib.Error;
		[Version (since = "0.1.3")]
		public Jcat.BlobKind get_kind ();
		[Version (since = "0.1.3")]
		public Jcat.BlobMethod get_method ();
		[Version (since = "0.1.0")]
		public virtual Jcat.Blob pubkey_sign (GLib.Bytes blob, GLib.Bytes cert, GLib.Bytes privkey, Jcat.SignFlags flags) throws GLib.Error;
		[Version (since = "0.1.0")]
		public virtual Jcat.Result pubkey_verify (GLib.Bytes blob, GLib.Bytes blob_signature, Jcat.VerifyFlags flags) throws GLib.Error;
		[Version (since = "0.1.0")]
		public virtual Jcat.Blob self_sign (GLib.Bytes blob, Jcat.SignFlags flags) throws GLib.Error;
		[Version (since = "0.1.0")]
		public virtual Jcat.Result self_verify (GLib.Bytes blob, GLib.Bytes blob_signature, Jcat.VerifyFlags flags) throws GLib.Error;
		[NoWrapper]
		public virtual bool setup () throws GLib.Error;
		[NoAccessorMethod]
		public Jcat.Context context { owned get; construct; }
		public uint kind { get; construct; }
		public uint method { get; construct; }
		[NoAccessorMethod]
		public uint verify_kind { get; }
	}
	[CCode (cheader_filename = "jcat.h", type_id = "jcat_file_get_type ()")]
	public class File : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.1.0")]
		public File ();
		[Version (since = "0.1.0")]
		public void add_item (Jcat.Item item);
		[Version (since = "0.1.0")]
		public bool export_file (GLib.File gfile, Jcat.ExportFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "0.1.0")]
		public string export_json (Jcat.ExportFlags flags) throws GLib.Error;
		[Version (since = "0.1.0")]
		public bool export_stream (GLib.OutputStream ostream, Jcat.ExportFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "0.1.0")]
		public Jcat.Item get_item_by_id (string id) throws GLib.Error;
		[Version (since = "0.1.0")]
		public Jcat.Item get_item_default () throws GLib.Error;
		[Version (since = "0.1.0")]
		public GLib.GenericArray<weak Jcat.Item> get_items ();
		[Version (since = "0.1.0")]
		public uint32 get_version_major ();
		[Version (since = "0.1.0")]
		public uint32 get_version_minor ();
		[Version (since = "0.1.0")]
		public bool import_file (GLib.File gfile, Jcat.ImportFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "0.1.0")]
		public bool import_json (string json, Jcat.ImportFlags flags) throws GLib.Error;
		[Version (since = "0.1.0")]
		public bool import_stream (GLib.InputStream istream, Jcat.ImportFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "0.1.0")]
		public string to_string ();
	}
	[CCode (cheader_filename = "jcat.h", type_id = "jcat_item_get_type ()")]
	public class Item : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "0.1.0")]
		public Item (string id);
		[Version (since = "0.1.1")]
		public void add_alias_id (string id);
		[Version (since = "0.1.0")]
		public void add_blob (Jcat.Blob blob);
		[Version (since = "0.1.1")]
		public GLib.GenericArray<weak string> get_alias_ids ();
		[Version (since = "0.2.0")]
		public Jcat.Blob get_blob_by_kind (Jcat.BlobKind kind) throws GLib.Error;
		[Version (since = "0.1.0")]
		public GLib.GenericArray<weak Jcat.Blob> get_blobs ();
		[Version (since = "0.1.0")]
		public GLib.GenericArray<weak Jcat.Blob> get_blobs_by_kind (Jcat.BlobKind kind);
		[Version (since = "0.1.0")]
		public unowned string get_id ();
		[Version (since = "0.2.0")]
		public bool has_target ();
		[Version (since = "0.1.1")]
		public void remove_alias_id (string id);
		[Version (since = "0.1.0")]
		public string to_string ();
	}
	[CCode (cheader_filename = "jcat.h", type_id = "jcat_result_get_type ()")]
	public class Result : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Result ();
		[Version (since = "0.1.0")]
		public unowned string get_authority ();
		[Version (since = "0.1.3")]
		public Jcat.BlobKind get_kind ();
		[Version (since = "0.1.3")]
		public Jcat.BlobMethod get_method ();
		[Version (since = "0.1.0")]
		public int64 get_timestamp ();
		[Version (since = "0.1.0")]
		public string to_string ();
		[NoAccessorMethod]
		public string authority { owned get; set; }
		[NoAccessorMethod]
		public Jcat.Engine engine { owned get; construct; }
		[NoAccessorMethod]
		public int64 timestamp { get; set; }
	}
	[CCode (cheader_filename = "jcat.h", cprefix = "JCAT_BLOB_FLAG_", has_type_id = false)]
	[Flags]
	public enum BlobFlags {
		NONE,
		IS_UTF8
	}
	[CCode (cheader_filename = "jcat.h", cprefix = "JCAT_BLOB_KIND_", has_type_id = false)]
	public enum BlobKind {
		UNKNOWN,
		SHA256,
		GPG,
		PKCS7,
		SHA1,
		BT_MANIFEST,
		BT_CHECKPOINT,
		BT_INCLUSION_PROOF,
		BT_VERIFIER,
		ED25519,
		SHA512
	}
	[CCode (cheader_filename = "jcat.h", cprefix = "JCAT_BLOB_METHOD_", has_type_id = false)]
	public enum BlobMethod {
		UNKNOWN,
		CHECKSUM,
		SIGNATURE
	}
	[CCode (cheader_filename = "jcat.h", cprefix = "JCAT_EXPORT_FLAG_", has_type_id = false)]
	[Flags]
	public enum ExportFlags {
		NONE,
		NO_TIMESTAMP
	}
	[CCode (cheader_filename = "jcat.h", cprefix = "JCAT_IMPORT_FLAG_", has_type_id = false)]
	public enum ImportFlags {
		NONE
	}
	[CCode (cheader_filename = "jcat.h", cprefix = "JCAT_SIGN_FLAG_", has_type_id = false)]
	[Flags]
	public enum SignFlags {
		NONE,
		ADD_TIMESTAMP,
		ADD_CERT
	}
	[CCode (cheader_filename = "jcat.h", cprefix = "JCAT_VERIFY_FLAG_", has_type_id = false)]
	[Flags]
	public enum VerifyFlags {
		NONE,
		DISABLE_TIME_CHECKS,
		REQUIRE_CHECKSUM,
		REQUIRE_SIGNATURE
	}
	[CCode (cheader_filename = "jcat.h", cname = "JCAT_MAJOR_VERSION")]
	[Version (since = "0.1.0")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "jcat.h", cname = "JCAT_MICRO_VERSION")]
	[Version (since = "0.1.0")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "jcat.h", cname = "JCAT_MINOR_VERSION")]
	[Version (since = "0.1.0")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "jcat.h")]
	[Version (since = "0.1.11")]
	public static unowned string version_string ();
}
