/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Scanner;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJCompressor;
import org.libjpegturbo.turbojpeg.TJCustomFilter;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.TJScalingFactor;
import org.libjpegturbo.turbojpeg.TJTransform;
import org.libjpegturbo.turbojpeg.TJTransformer;
import org.libjpegturbo.turbojpeg.YUVImage;

final class TJBench {
    private static boolean stopOnWarning;
    private static boolean bottomUp;
    private static boolean fastUpsample;
    private static boolean fastDCT;
    private static boolean optimize;
    private static boolean progressive;
    private static boolean limitScans;
    private static boolean arithmetic;
    private static boolean lossless;
    private static int maxMemory;
    private static int maxPixels;
    private static int precision;
    private static int quiet;
    private static int pf;
    private static int yuvAlign;
    private static int restartIntervalBlocks;
    private static int restartIntervalRows;
    private static boolean compOnly;
    private static boolean decompOnly;
    private static boolean doTile;
    private static boolean doYUV;
    private static boolean write;
    private static boolean bmp;
    static final String[] PIXFORMATSTR;
    static final String[] SUBNAME_LONG;
    static final String[] SUBNAME;
    static final String[] CSNAME;
    private static TJScalingFactor sf;
    private static Rectangle cr;
    private static int xformOp;
    private static int xformOpt;
    private static double benchTime;
    private static double warmup;
    private static DummyDCTFilter customFilter;
    private static String tjErrorMsg;
    private static int tjErrorCode;

    private TJBench() {
    }

    private static boolean isCropped(Rectangle rectangle) {
        return rectangle.x != 0 || rectangle.y != 0 || rectangle.width != 0 || rectangle.height != 0;
    }

    private static int getCroppedWidth(int n) {
        if (TJBench.isCropped(cr)) {
            return TJBench.cr.width != 0 ? TJBench.cr.width : sf.getScaled(n) - TJBench.cr.x;
        }
        return sf.getScaled(n);
    }

    private static int getCroppedHeight(int n) {
        if (TJBench.isCropped(cr)) {
            return TJBench.cr.height != 0 ? TJBench.cr.height : sf.getScaled(n) - TJBench.cr.y;
        }
        return sf.getScaled(n);
    }

    static double getTime() {
        return (double)System.nanoTime() / 1.0E9;
    }

    static void handleTJException(TJException tJException) throws TJException {
        String string = tJException.getMessage();
        int n = tJException.getErrorCode();
        if (!stopOnWarning && n == 0) {
            if (tjErrorMsg == null || !tjErrorMsg.equals(string) || tjErrorCode != n) {
                tjErrorMsg = string;
                tjErrorCode = n;
                System.out.println("WARNING: " + string);
            }
        } else {
            throw tJException;
        }
    }

    static String formatName(int n, int n2) {
        if (quiet != 0) {
            if (lossless) {
                return String.format("%-2d/LOSSLESS   ", precision);
            }
            if (n == -1) {
                return String.format("%-2d/%-5s      ", precision, CSNAME[n2]);
            }
            return String.format("%-2d/%-5s/%-5s", precision, CSNAME[n2], SUBNAME_LONG[n]);
        }
        if (lossless) {
            return "Lossless";
        }
        if (n == -1) {
            return CSNAME[n2];
        }
        return CSNAME[n2] + " " + SUBNAME_LONG[n];
    }

    static String sigFig(double d, int n) {
        int n2 = n - (int)Math.ceil(Math.log10(Math.abs(d)));
        String string = n2 < 1 ? new String("%.0f") : new String("%." + n2 + "f");
        return String.format(string, d);
    }

    static void decomp(byte[][] byArray, int[] nArray, Object object, int n, int n2, int n3, int n4, String string, int n5, int n6) throws Exception {
        String string2 = new String("");
        int n7 = TJ.getPixelSize(pf);
        int n8 = 0;
        YUVImage yUVImage = null;
        if (lossless) {
            sf = TJ.UNSCALED;
        }
        int n9 = sf.getScaled(n);
        int n10 = sf.getScaled(n2);
        if (n4 > 0) {
            string2 = new String((lossless ? "_PSV" : "_Q") + n4);
        }
        TJDecompressor tJDecompressor = new TJDecompressor();
        tJDecompressor.set(0, stopOnWarning ? 1 : 0);
        tJDecompressor.set(1, bottomUp ? 1 : 0);
        tJDecompressor.set(9, fastUpsample ? 1 : 0);
        tJDecompressor.set(10, fastDCT ? 1 : 0);
        tJDecompressor.set(13, limitScans ? 500 : 0);
        tJDecompressor.set(23, maxMemory);
        tJDecompressor.set(24, maxPixels);
        if (TJBench.isCropped(cr)) {
            try {
                tJDecompressor.setSourceImage(byArray[0], nArray[0]);
            }
            catch (TJException tJException) {
                TJBench.handleTJException(tJException);
            }
        }
        tJDecompressor.setScalingFactor(sf);
        tJDecompressor.setCroppingRegion(cr);
        if (TJBench.isCropped(cr)) {
            n9 = TJBench.cr.width != 0 ? TJBench.cr.width : n9 - TJBench.cr.x;
            n10 = TJBench.cr.height != 0 ? TJBench.cr.height : n10 - TJBench.cr.y;
        }
        int n11 = n9 * n7;
        if (object == null) {
            if ((long)n11 * (long)n10 > Integer.MAX_VALUE) {
                throw new Exception("Image is too large");
            }
            object = precision == 8 ? (Object)new byte[n11 * n10] : (Object)new short[n11 * n10];
        }
        if (precision == 8) {
            Arrays.fill((byte[])object, (byte)127);
        } else if (precision == 12) {
            Arrays.fill((short[])object, (short)2047);
        } else {
            Arrays.fill((short[])object, (short)Short.MAX_VALUE);
        }
        if (doYUV) {
            int n12 = doTile ? n5 : n9;
            int n13 = doTile ? n6 : n10;
            yUVImage = new YUVImage(n12, yuvAlign, n13, n3);
            Arrays.fill(yUVImage.getBuf(), (byte)127);
        }
        n8 = -1;
        double d = 0.0;
        double d2 = 0.0;
        while (true) {
            int n14 = 0;
            double d3 = TJBench.getTime();
            for (int i = 0; i < n2; i += n6) {
                int n15 = 0;
                while (n15 < n) {
                    int n16 = doTile ? Math.min(n5, n - n15) : n9;
                    int n17 = doTile ? Math.min(n6, n2 - i) : n10;
                    try {
                        tJDecompressor.setSourceImage(byArray[n14], nArray[n14]);
                    }
                    catch (TJException tJException) {
                        TJBench.handleTJException(tJException);
                    }
                    if (doYUV) {
                        yUVImage.setBuf(yUVImage.getBuf(), n16, yuvAlign, n17, n3);
                        try {
                            tJDecompressor.decompressToYUV(yUVImage);
                        }
                        catch (TJException tJException) {
                            TJBench.handleTJException(tJException);
                        }
                        double d4 = TJBench.getTime();
                        tJDecompressor.setSourceImage(yUVImage);
                        try {
                            tJDecompressor.decompress8((byte[])object, n15, i, n11, pf);
                        }
                        catch (TJException tJException) {
                            TJBench.handleTJException(tJException);
                        }
                        if (n8 >= 0) {
                            d += TJBench.getTime() - d4;
                        }
                    } else {
                        try {
                            if (precision == 8) {
                                tJDecompressor.decompress8((byte[])object, n15, i, n11, pf);
                            } else if (precision == 12) {
                                tJDecompressor.decompress12((short[])object, n15, i, n11, pf);
                            } else {
                                tJDecompressor.decompress16((short[])object, n15, i, n11, pf);
                            }
                        }
                        catch (TJException tJException) {
                            TJBench.handleTJException(tJException);
                        }
                    }
                    n15 += n5;
                    ++n14;
                }
            }
            d2 += TJBench.getTime() - d3;
            if (n8 >= 0) {
                ++n8;
                if (!(d2 >= benchTime)) continue;
                break;
            }
            if (!(d2 >= warmup)) continue;
            n8 = 0;
            d = 0.0;
            d2 = 0.0;
        }
        if (doYUV) {
            d2 -= d;
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = null;
        }
        byArray = null;
        nArray = null;
        System.gc();
        if (quiet != 0) {
            System.out.format("%-6s%s", TJBench.sigFig((double)(n * n2) / 1000000.0 * (double)n8 / d2, 4), quiet == 2 ? "\n" : "  ");
            if (doYUV) {
                System.out.format("%s\n", TJBench.sigFig((double)(n * n2) / 1000000.0 * (double)n8 / d, 4));
            } else if (quiet != 2) {
                System.out.print("\n");
            }
        } else {
            System.out.format("%s --> Frame rate:         %f fps\n", doYUV ? "Decomp to YUV" : "Decompress   ", (double)n8 / d2);
            System.out.format("                  Throughput:         %f Megapixels/sec\n", (double)(n * n2) / 1000000.0 * (double)n8 / d2);
            if (doYUV) {
                System.out.format("YUV Decode    --> Frame rate:         %f fps\n", (double)n8 / d);
                System.out.format("                  Throughput:         %f Megapixels/sec\n", (double)(n * n2) / 1000000.0 * (double)n8 / d);
            }
        }
        if (!write) {
            return;
        }
        String string3 = sf.getNum() != 1 || sf.getDenom() != 1 ? new String(sf.getNum() + "_" + sf.getDenom()) : (n5 != n || n6 != n2 ? new String(n5 + "x" + n6) : new String("full"));
        String string4 = decompOnly ? new String(string + "_" + string3 + (bmp ? ".bmp" : ".ppm")) : new String(string + "_" + (lossless ? "LOSSLS" : SUBNAME[n3]) + string2 + "_" + string3 + (bmp ? ".bmp" : ".ppm"));
        tJDecompressor.saveImage(precision, string4, object, n9, 0, n10, pf);
    }

    static void fullTest(TJCompressor tJCompressor, Object object, int n, int n2, int n3, int n4, String string) throws Exception {
        int n5;
        int n6 = 0;
        int n7 = TJ.getPixelSize(pf);
        int n8 = 1;
        int n9 = 1;
        int n10 = n * n7;
        String string2 = PIXFORMATSTR[pf];
        YUVImage yUVImage = null;
        if ((long)n10 * (long)n2 > Integer.MAX_VALUE) {
            throw new Exception("Image is too large");
        }
        Object[] objectArray = precision == 8 ? new byte[n10 * n2] : (Object[])new short[n10 * n2];
        if (quiet == 0) {
            System.out.format(">>>>>  %s (%s) <--> %d-bit JPEG (%s %s%d)  <<<<<\n", string2, bottomUp ? "Bottom-up" : "Top-down", precision, lossless ? "Lossless" : SUBNAME_LONG[n3], lossless ? "PSV" : "Q", n4);
        }
        tJCompressor.set(4, n3);
        tJCompressor.set(10, fastDCT ? 1 : 0);
        tJCompressor.set(11, optimize ? 1 : 0);
        tJCompressor.set(12, progressive ? 1 : 0);
        tJCompressor.set(14, arithmetic ? 1 : 0);
        tJCompressor.set(15, lossless ? 1 : 0);
        if (lossless) {
            tJCompressor.set(16, n4);
        } else {
            tJCompressor.set(3, n4);
        }
        tJCompressor.set(18, restartIntervalBlocks);
        tJCompressor.set(19, restartIntervalRows);
        tJCompressor.set(23, maxMemory);
        int n11 = doTile ? 8 : n;
        int n12 = n5 = doTile ? 8 : n2;
        while (true) {
            if (n11 > n) {
                n11 = n;
            }
            if (n5 > n2) {
                n5 = n2;
            }
            n8 = (n + n11 - 1) / n11;
            n9 = (n2 + n5 - 1) / n5;
            byte[][] byArray = new byte[n8 * n9][TJ.bufSize(n11, n5, n3)];
            int[] nArray = new int[n8 * n9];
            if (quiet == 1) {
                System.out.format("%-4s(%s)  %-2d/%-6s %-3d   ", string2, bottomUp ? "BU" : "TD", precision, lossless ? "LOSSLS" : SUBNAME_LONG[n3], n4);
            }
            if (precision == 8) {
                for (var19_22 = 0; var19_22 < n2; ++var19_22) {
                    System.arraycopy((byte[])object, n * n7 * var19_22, objectArray, n10 * var19_22, n * n7);
                }
            } else {
                for (var19_22 = 0; var19_22 < n2; ++var19_22) {
                    System.arraycopy((short[])object, n * n7 * var19_22, objectArray, n10 * var19_22, n * n7);
                }
            }
            if (doYUV) {
                yUVImage = new YUVImage(n11, yuvAlign, n5, n3);
                Arrays.fill(yUVImage.getBuf(), (byte)127);
            }
            int n13 = -1;
            double d = 0.0;
            double d2 = 0.0;
            while (true) {
                int n14 = 0;
                n6 = 0;
                double d3 = TJBench.getTime();
                for (int i = 0; i < n2; i += n5) {
                    int n15 = 0;
                    while (n15 < n) {
                        int n16 = Math.min(n11, n - n15);
                        int n17 = Math.min(n5, n2 - i);
                        if (precision == 8) {
                            tJCompressor.setSourceImage((byte[])object, n15, i, n16, n10, n17, pf);
                        } else if (precision == 12) {
                            tJCompressor.setSourceImage12((short[])object, n15, i, n16, n10, n17, pf);
                        } else {
                            tJCompressor.setSourceImage16((short[])object, n15, i, n16, n10, n17, pf);
                        }
                        if (doYUV) {
                            double d4 = TJBench.getTime();
                            yUVImage.setBuf(yUVImage.getBuf(), n16, yuvAlign, n17, n3);
                            tJCompressor.encodeYUV(yUVImage);
                            if (n13 >= 0) {
                                d += TJBench.getTime() - d4;
                            }
                            tJCompressor.setSourceImage(yUVImage);
                        }
                        tJCompressor.compress(byArray[n14]);
                        nArray[n14] = tJCompressor.getCompressedSize();
                        n6 += nArray[n14];
                        n15 += n11;
                        ++n14;
                    }
                }
                d2 += TJBench.getTime() - d3;
                if (n13 >= 0) {
                    ++n13;
                    if (!(d2 >= benchTime)) continue;
                    break;
                }
                if (!(d2 >= warmup)) continue;
                n13 = 0;
                d = 0.0;
                d2 = 0.0;
            }
            if (doYUV) {
                d2 -= d;
            }
            if (quiet == 1) {
                System.out.format("%-5d  %-5d   ", n11, n5);
            }
            if (quiet != 0) {
                if (doYUV) {
                    System.out.format("%-6s%s", TJBench.sigFig((double)(n * n2) / 1000000.0 * (double)n13 / d, 4), quiet == 2 ? "\n" : "  ");
                }
                System.out.format("%-6s%s", TJBench.sigFig((double)(n * n2) / 1000000.0 * (double)n13 / d2, 4), quiet == 2 ? "\n" : "  ");
                System.out.format("%-6s%s", TJBench.sigFig((double)(n * n2 * n7) / (double)n6, 4), quiet == 2 ? "\n" : "  ");
            } else {
                System.out.format("\n%s size: %d x %d\n", doTile ? "Tile" : "Image", n11, n5);
                if (doYUV) {
                    System.out.format("Encode YUV    --> Frame rate:         %f fps\n", (double)n13 / d);
                    System.out.format("                  Output image size:  %d bytes\n", yUVImage.getSize());
                    System.out.format("                  Compression ratio:  %f:1\n", (double)(n * n2 * n7) / (double)yUVImage.getSize());
                    System.out.format("                  Throughput:         %f Megapixels/sec\n", (double)(n * n2) / 1000000.0 * (double)n13 / d);
                    System.out.format("                  Output bit stream:  %f Megabits/sec\n", (double)yUVImage.getSize() * 8.0 / 1000000.0 * (double)n13 / d);
                }
                System.out.format("%s --> Frame rate:         %f fps\n", doYUV ? "Comp from YUV" : "Compress     ", (double)n13 / d2);
                System.out.format("                  Output image size:  %d bytes\n", n6);
                System.out.format("                  Compression ratio:  %f:1\n", (double)(n * n2 * n7) / (double)n6);
                System.out.format("                  Throughput:         %f Megapixels/sec\n", (double)(n * n2) / 1000000.0 * (double)n13 / d2);
                System.out.format("                  Output bit stream:  %f Megabits/sec\n", (double)n6 * 8.0 / 1000000.0 * (double)n13 / d2);
            }
            if (n11 == n && n5 == n2 && write) {
                String string3 = string + "_" + (lossless ? "LOSSLS" : SUBNAME[n3]) + "_" + (lossless ? "PSV" : "Q") + n4 + ".jpg";
                FileOutputStream fileOutputStream = new FileOutputStream(string3);
                fileOutputStream.write(byArray[0], 0, nArray[0]);
                fileOutputStream.close();
                if (quiet == 0) {
                    System.out.println("Reference image written to " + string3);
                }
            }
            if (!compOnly) {
                TJBench.decomp(byArray, nArray, objectArray, n, n2, n3, n4, string, n11, n5);
            } else if (quiet == 1) {
                System.out.println("N/A");
            }
            if (n11 == n && n5 == n2) break;
            n11 *= 2;
            n5 *= 2;
        }
    }

    static void decompTest(String string) throws Exception {
        int n;
        byte[][] byArray = null;
        int[] nArray = null;
        int n2 = TJ.getPixelSize(pf);
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        int n6 = 1;
        int n7 = -1;
        int n8 = -1;
        int n9 = 16;
        FileInputStream fileInputStream = new FileInputStream(string);
        if (fileInputStream.getChannel().size() > Integer.MAX_VALUE) {
            throw new Exception("Image is too large");
        }
        int n10 = (int)fileInputStream.getChannel().size();
        byte[] byArray2 = new byte[n10];
        fileInputStream.read(byArray2, 0, n10);
        fileInputStream.close();
        int n11 = string.lastIndexOf(46);
        if (n11 >= 0) {
            string = new String(string.substring(0, n11));
        }
        TJTransformer tJTransformer = new TJTransformer();
        tJTransformer.set(0, stopOnWarning ? 1 : 0);
        tJTransformer.set(1, bottomUp ? 1 : 0);
        tJTransformer.set(9, fastUpsample ? 1 : 0);
        tJTransformer.set(10, fastDCT ? 1 : 0);
        tJTransformer.set(13, limitScans ? 500 : 0);
        tJTransformer.set(23, maxMemory);
        tJTransformer.set(24, maxPixels);
        try {
            tJTransformer.setSourceImage(byArray2, n10);
        }
        catch (TJException tJException) {
            TJBench.handleTJException(tJException);
        }
        n3 = tJTransformer.getWidth();
        n4 = tJTransformer.getHeight();
        n7 = tJTransformer.get(4);
        precision = tJTransformer.get(7);
        n8 = tJTransformer.get(8);
        if (tJTransformer.get(12) == 1) {
            System.out.println("JPEG image uses progressive entropy coding\n");
        }
        if (tJTransformer.get(14) == 1) {
            System.out.println("JPEG image uses arithmetic entropy coding\n");
        }
        tJTransformer.set(12, progressive ? 1 : 0);
        tJTransformer.set(14, arithmetic ? 1 : 0);
        if (n8 == 4 || n8 == 3) {
            pf = 11;
            n2 = TJ.getPixelSize(pf);
        }
        if (tJTransformer.get(15) != 0) {
            sf = TJ.UNSCALED;
        }
        tJTransformer.setScalingFactor(sf);
        tJTransformer.setCroppingRegion(cr);
        if (quiet == 1) {
            System.out.println("All performance values in Mpixels/sec\n");
            System.out.format("Pixel     JPEG             %s  %s   Xform   Comp    Decomp  ", doTile ? "Tile " : "Image", doTile ? "Tile " : "Image");
            if (doYUV) {
                System.out.print("Decode");
            }
            System.out.print("\n");
            System.out.print("Format    Format           Width  Height  Perf    Ratio   Perf    ");
            if (doYUV) {
                System.out.print("Perf");
            }
            System.out.println("\n");
        } else if (quiet == 0) {
            System.out.format(">>>>>  %d-bit JPEG (%s) --> %s (%s)  <<<<<\n", precision, TJBench.formatName(n7, n8), PIXFORMATSTR[pf], bottomUp ? "Bottom-up" : "Top-down");
        }
        if (doTile) {
            if (n7 == -1) {
                throw new Exception("Could not determine subsampling level of JPEG image");
            }
            n9 = Math.max(TJ.getMCUWidth(n7), TJ.getMCUHeight(n7));
        }
        int n12 = doTile ? n9 : n3;
        int n13 = n = doTile ? n9 : n4;
        while (true) {
            if (n12 > n3) {
                n12 = n3;
            }
            if (n > n4) {
                n = n4;
            }
            n5 = (n3 + n12 - 1) / n12;
            n6 = (n4 + n - 1) / n;
            int n14 = n3;
            int n15 = n4;
            int n16 = n12;
            int n17 = n;
            if (quiet == 0) {
                System.out.format("\n%s size: %d x %d", doTile ? "Tile" : "Image", n16, n17);
                if (sf.getNum() != 1 || sf.getDenom() != 1 || TJBench.isCropped(cr)) {
                    System.out.format(" --> %d x %d", TJBench.getCroppedWidth(n14), TJBench.getCroppedHeight(n15));
                }
                System.out.println("");
            } else if (quiet == 1) {
                System.out.format("%-4s(%s)  %-14s   ", PIXFORMATSTR[pf], bottomUp ? "BU" : "TD", TJBench.formatName(n7, n8));
                System.out.format("%-5d  %-5d   ", TJBench.getCroppedWidth(n12), TJBench.getCroppedHeight(n));
            }
            int n18 = n7;
            if (doTile || xformOp != 0 || xformOpt != 0 || customFilter != null) {
                if (xformOp == 3 || xformOp == 4 || xformOp == 5 || xformOp == 7) {
                    n14 = n4;
                    n15 = n3;
                    n16 = n;
                    n17 = n12;
                }
                if (xformOp != 0 && xformOp != 3 && n7 == -1) {
                    throw new Exception("Could not determine subsampling level of JPEG image");
                }
                if ((xformOpt & 8) != 0) {
                    n18 = 3;
                }
                if (xformOp == 1 || xformOp == 6) {
                    n14 -= n14 % TJ.getMCUWidth(n18);
                }
                if (xformOp == 2 || xformOp == 6) {
                    n15 -= n15 % TJ.getMCUHeight(n18);
                }
                if (xformOp == 4 || xformOp == 5) {
                    n14 -= n14 % TJ.getMCUHeight(n18);
                }
                if (xformOp == 4 || xformOp == 7) {
                    n15 -= n15 % TJ.getMCUWidth(n18);
                }
                int n19 = (n14 + n16 - 1) / n16;
                int n20 = (n15 + n17 - 1) / n17;
                if (xformOp == 3 || xformOp == 4 || xformOp == 5 || xformOp == 7) {
                    if (n18 == 1) {
                        n18 = 4;
                    } else if (n18 == 4) {
                        n18 = 1;
                    } else if (n18 == 5) {
                        n18 = 6;
                    } else if (n18 == 6) {
                        n18 = 5;
                    }
                }
                TJTransform[] tJTransformArray = new TJTransform[n19 * n20];
                byArray = new byte[n19 * n20][TJ.bufSize(n16, n17, n7)];
                int n21 = 0;
                for (int i = 0; i < n15; i += n17) {
                    int n22 = 0;
                    while (n22 < n14) {
                        tJTransformArray[n21] = new TJTransform();
                        tJTransformArray[n21].width = Math.min(n16, n14 - n22);
                        tJTransformArray[n21].height = Math.min(n17, n15 - i);
                        tJTransformArray[n21].x = n22;
                        tJTransformArray[n21].y = i;
                        tJTransformArray[n21].op = xformOp;
                        tJTransformArray[n21].options = xformOpt | 2;
                        tJTransformArray[n21].cf = customFilter;
                        if ((tJTransformArray[n21].options & 0x10) != 0 && byArray[n21] != null) {
                            byArray[n21] = null;
                        }
                        n22 += n16;
                        ++n21;
                    }
                }
                int n23 = -1;
                double d = 0.0;
                while (true) {
                    double d2 = TJBench.getTime();
                    try {
                        tJTransformer.transform(byArray, tJTransformArray);
                    }
                    catch (TJException tJException) {
                        TJBench.handleTJException(tJException);
                    }
                    nArray = tJTransformer.getTransformedSizes();
                    d += TJBench.getTime() - d2;
                    if (n23 >= 0) {
                        ++n23;
                        if (!(d >= benchTime)) continue;
                        break;
                    }
                    if (!(d >= warmup)) continue;
                    n23 = 0;
                    d = 0.0;
                }
                tJTransformArray = null;
                int n24 = 0;
                for (n21 = 0; n21 < n19 * n20; ++n21) {
                    n24 += nArray[n21];
                }
                if (quiet != 0) {
                    System.out.format("%-6s%s%-6s%s", TJBench.sigFig((double)(n3 * n4) / 1000000.0 / d, 4), quiet == 2 ? "\n" : "  ", TJBench.sigFig((double)(n3 * n4 * n2) / (double)n24, 4), quiet == 2 ? "\n" : "  ");
                } else {
                    System.out.format("Transform     --> Frame rate:         %f fps\n", 1.0 / d);
                    System.out.format("                  Output image size:  %d bytes\n", n24);
                    System.out.format("                  Compression ratio:  %f:1\n", (double)(n3 * n4 * n2) / (double)n24);
                    System.out.format("                  Throughput:         %f Megapixels/sec\n", (double)(n3 * n4) / 1000000.0 / d);
                    System.out.format("                  Output bit stream:  %f Megabits/sec\n", (double)n24 * 8.0 / 1000000.0 / d);
                }
            } else {
                if (quiet == 1) {
                    System.out.print("N/A     N/A     ");
                }
                byArray = new byte[1][TJ.bufSize(n16, n17, n7)];
                nArray = new int[1];
                byArray[0] = byArray2;
                nArray[0] = n10;
            }
            if (n3 == n12) {
                n16 = n14;
            }
            if (n4 == n) {
                n17 = n15;
            }
            if ((xformOpt & 0x10) == 0) {
                TJBench.decomp(byArray, nArray, null, n14, n15, n18, 0, string, n16, n17);
            } else if (quiet == 1) {
                System.out.println("N/A");
            }
            byArray = null;
            nArray = null;
            if (n12 == n3 && n == n4) break;
            n12 *= 2;
            n *= 2;
        }
    }

    static void usage() throws Exception {
        TJScalingFactor[] tJScalingFactorArray = TJ.getScalingFactors();
        int n = tJScalingFactorArray.length;
        String string = new TJBench().getClass().getName();
        System.out.println("\nUSAGE: java " + string);
        System.out.println("       <Inputimage (BMP|PPM)> <Quality or PSV> [options]\n");
        System.out.println("       java " + string);
        System.out.println("       <Inputimage (JPG)> [options]");
        System.out.println("\nGENERAL OPTIONS");
        System.out.println("---------------");
        System.out.println("-benchtime T = Run each benchmark for at least T seconds [default = 5.0]");
        System.out.println("-bmp = Use Windows Bitmap format for output images [default = PPM]");
        System.out.println("     ** 8-bit data precision only **");
        System.out.println("-bottomup = Use bottom-up row order for packed-pixel source/destination buffers");
        System.out.println("-componly = Stop after running compression tests.  Do not test decompression.");
        System.out.println("-lossless = Generate lossless JPEG images when compressing (implies");
        System.out.println("     -subsamp 444).  PSV is the predictor selection value (1-7).");
        System.out.println("-maxmemory = Memory limit (in megabytes) for intermediate buffers used with");
        System.out.println("     progressive JPEG compression and decompression, optimized baseline entropy");
        System.out.println("     coding, lossless JPEG compression, and lossless transformation");
        System.out.println("     [default = no limit]");
        System.out.println("-maxpixels = Input image size limit (in pixels) [default = no limit]");
        System.out.println("-nowrite = Do not write reference or output images (improves consistency of");
        System.out.println("     benchmark results)");
        System.out.println("-rgb, -bgr, -rgbx, -bgrx, -xbgr, -xrgb =");
        System.out.println("     Use the specified pixel format for packed-pixel source/destination buffers");
        System.out.println("     [default = BGR]");
        System.out.println("-cmyk = Indirectly test YCCK JPEG compression/decompression");
        System.out.println("     (use the CMYK pixel format for packed-pixel source/destination buffers)");
        System.out.println("-precision N = Use N-bit data precision when compressing [N is 8, 12, or 16;");
        System.out.println("     default = 8; if N is 16, then -lossless must also be specified]");
        System.out.println("     (-precision 12 implies -optimize unless -arithmetic is also specified)");
        System.out.println("-quiet = Output results in tabular rather than verbose format");
        System.out.println("-restart N = When compressing, add a restart marker every N MCU rows (lossy) or");
        System.out.println("     N sample rows (lossless) [default = 0 (no restart markers)].  Append 'B'");
        System.out.println("     to specify the restart marker interval in MCU blocks (lossy) or samples");
        System.out.println("     (lossless).");
        System.out.println("-stoponwarning = Immediately discontinue the current");
        System.out.println("     compression/decompression/transform operation if a warning (non-fatal");
        System.out.println("     error) occurs");
        System.out.println("-tile = Compress/transform the input image into separate JPEG tiles of varying");
        System.out.println("     sizes (useful for measuring JPEG overhead)");
        System.out.println("-warmup T = Run each benchmark for T seconds [default = 1.0] prior to starting");
        System.out.println("     the timer, in order to prime the caches and thus improve the consistency");
        System.out.println("     of the benchmark results");
        System.out.println("\nLOSSY JPEG OPTIONS");
        System.out.println("------------------");
        System.out.println("-arithmetic = Use arithmetic entropy coding in JPEG images generated by");
        System.out.println("     compression and transform operations (can be combined with -progressive)");
        System.out.println("-crop WxH+X+Y = Decompress only the specified region of the JPEG image, where W");
        System.out.println("     and H are the width and height of the region (0 = maximum possible width");
        System.out.println("     or height) and X and Y are the left and upper boundary of the region, all");
        System.out.println("     specified relative to the scaled image dimensions.  X must be divible by");
        System.out.println("     the scaled MCU width.");
        System.out.println("-fastdct = Use the fastest DCT/IDCT algorithm available");
        System.out.println("-fastupsample = Use the fastest chrominance upsampling algorithm available");
        System.out.println("-optimize = Use optimized baseline entropy coding in JPEG images generated by");
        System.out.println("     compession and transform operations");
        System.out.println("-progressive = Use progressive entropy coding in JPEG images generated by");
        System.out.println("     compression and transform operations (can be combined with -arithmetic;");
        System.out.println("     implies -optimize unless -arithmetic is also specified)");
        System.out.println("-limitscans = Refuse to decompress or transform progressive JPEG images that");
        System.out.println("     have an unreasonably large number of scans");
        System.out.println("-scale M/N = When decompressing, scale the width/height of the JPEG image by a");
        System.out.print("     factor of M/N (M/N = ");
        for (int i = 0; i < n; ++i) {
            System.out.format("%d/%d", tJScalingFactorArray[i].getNum(), tJScalingFactorArray[i].getDenom());
            if (n == 2 && i != n - 1) {
                System.out.print(" or ");
            } else if (n > 2) {
                if (i != n - 1) {
                    System.out.print(", ");
                }
                if (i == n - 2) {
                    System.out.print("or ");
                }
            }
            if (i % 8 != 0 || i == 0) continue;
            System.out.print("\n     ");
        }
        System.out.println(")");
        System.out.println("-subsamp S = When compressing, use the specified level of chrominance");
        System.out.println("     subsampling (S = 444, 422, 440, 420, 411, 441, or GRAY) [default = test");
        System.out.println("     Grayscale, 4:2:0, 4:2:2, and 4:4:4 in sequence]");
        System.out.println("-hflip, -vflip, -transpose, -transverse, -rot90, -rot180, -rot270 =");
        System.out.println("     Perform the specified lossless transform operation on the input image");
        System.out.println("     prior to decompression (these operations are mutually exclusive)");
        System.out.println("-grayscale = Transform the input image into a grayscale JPEG image prior to");
        System.out.println("     decompression (can be combined with the other transform operations above)");
        System.out.println("-copynone = Do not copy any extra markers (including EXIF and ICC profile data)");
        System.out.println("     when transforming the input image");
        System.out.println("-yuv = Compress from/decompress to intermediate planar YUV images");
        System.out.println("     ** 8-bit data precision only **");
        System.out.println("-yuvpad N = The number of bytes by which each row in each plane of an");
        System.out.println("     intermediate YUV image is evenly divisible (N must be a power of 2)");
        System.out.println("     [default = 1]");
        System.out.println("\nNOTE:  If the quality/PSV is specified as a range (e.g. 90-100 or 1-4), a");
        System.out.println("separate test will be performed for all values in the range.\n");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Object object = null;
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = 1;
        int n6 = 0;
        int n7 = -1;
        TJCompressor tJCompressor = null;
        try {
            String string;
            if (stringArray.length < n5) {
                TJBench.usage();
            }
            if ((string = stringArray[0].toLowerCase()).endsWith(".jpg") || string.endsWith(".jpeg")) {
                decompOnly = true;
            }
            if (string.endsWith(".bmp")) {
                bmp = true;
            }
            System.out.println("");
            if (!decompOnly) {
                n5 = 2;
                if (stringArray.length < n5) {
                    TJBench.usage();
                }
                String[] stringArray2 = stringArray[1].split("-", 2);
                try {
                    n3 = Integer.parseInt(stringArray2[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (stringArray2.length > 1) {
                    try {
                        n4 = Integer.parseInt(stringArray2[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (n4 < n3) {
                    n4 = n3;
                }
            }
            if (stringArray.length > n5) {
                for (int i = n5; i < stringArray.length; ++i) {
                    Scanner scanner;
                    if (stringArray[i].equalsIgnoreCase("-tile")) {
                        doTile = true;
                        xformOpt |= 4;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-precision") && i < stringArray.length - 1) {
                        int n8 = 0;
                        try {
                            n8 = Integer.parseInt(stringArray[++i]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (n8 == 8 || n8 == 12 || n8 == 16) {
                            precision = n8;
                            continue;
                        }
                        TJBench.usage();
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-fastupsample")) {
                        System.out.println("Using fastest upsampling algorithm\n");
                        fastUpsample = true;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-fastdct")) {
                        System.out.println("Using fastest DCT/IDCT algorithm\n");
                        fastDCT = true;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-optimize")) {
                        System.out.println("Using optimized baseline entropy coding\n");
                        optimize = true;
                        xformOpt |= 0x100;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-progressive")) {
                        System.out.println("Using progressive entropy coding\n");
                        progressive = true;
                        xformOpt |= 0x20;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-arithmetic")) {
                        System.out.println("Using arithmetic entropy coding\n");
                        arithmetic = true;
                        xformOpt |= 0x80;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-lossless")) {
                        lossless = true;
                        n7 = 0;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-rgb")) {
                        pf = 0;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-rgbx")) {
                        pf = 2;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-bgr")) {
                        pf = 1;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-bgrx")) {
                        pf = 3;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-xbgr")) {
                        pf = 4;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-xrgb")) {
                        pf = 5;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-cmyk")) {
                        pf = 11;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-bottomup")) {
                        bottomUp = true;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-quiet")) {
                        quiet = 1;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-qq")) {
                        quiet = 2;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-scale") && i < stringArray.length - 1) {
                        int n9 = 0;
                        int n10 = 0;
                        boolean bl = false;
                        boolean bl2 = true;
                        scanner = new Scanner(stringArray[++i]).useDelimiter("/");
                        try {
                            n9 = scanner.nextInt();
                            n10 = scanner.nextInt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (n10 <= 0) {
                            n10 = 1;
                        }
                        if (n9 > 0) {
                            TJScalingFactor[] tJScalingFactorArray = TJ.getScalingFactors();
                            for (int j = 0; j < tJScalingFactorArray.length; ++j) {
                                if ((double)n9 / (double)n10 != (double)tJScalingFactorArray[j].getNum() / (double)tJScalingFactorArray[j].getDenom()) continue;
                                sf = tJScalingFactorArray[j];
                                bl = true;
                                break;
                            }
                            if (bl) continue;
                            TJBench.usage();
                            continue;
                        }
                        TJBench.usage();
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-crop") && i < stringArray.length - 1) {
                        int n11 = -1;
                        int n12 = -1;
                        int n13 = -1;
                        int n14 = -1;
                        scanner = new Scanner(stringArray[++i]).useDelimiter("x|\\+");
                        try {
                            n11 = scanner.nextInt();
                            n12 = scanner.nextInt();
                            n13 = scanner.nextInt();
                            n14 = scanner.nextInt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (n11 < 0 || n12 < 0 || n13 < 0 || n14 < 0) {
                            TJBench.usage();
                        }
                        TJBench.cr.width = n11;
                        TJBench.cr.height = n12;
                        TJBench.cr.x = n13;
                        TJBench.cr.y = n14;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-hflip")) {
                        xformOp = 1;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-vflip")) {
                        xformOp = 2;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-transpose")) {
                        xformOp = 3;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-transverse")) {
                        xformOp = 4;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-rot90")) {
                        xformOp = 5;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-rot180")) {
                        xformOp = 6;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-rot270")) {
                        xformOp = 7;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-grayscale")) {
                        xformOpt |= 8;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-custom")) {
                        customFilter = new DummyDCTFilter();
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-nooutput")) {
                        xformOpt |= 0x10;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-copynone")) {
                        xformOpt |= 0x40;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-benchtime") && i < stringArray.length - 1) {
                        double d = -1.0;
                        try {
                            d = Double.parseDouble(stringArray[++i]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (d > 0.0) {
                            benchTime = d;
                            continue;
                        }
                        TJBench.usage();
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-warmup") && i < stringArray.length - 1) {
                        double d = -1.0;
                        try {
                            d = Double.parseDouble(stringArray[++i]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (d >= 0.0) {
                            warmup = d;
                            System.out.format("Warmup time = %.1f seconds\n\n", warmup);
                            continue;
                        }
                        TJBench.usage();
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-bmp")) {
                        bmp = true;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-yuv")) {
                        System.out.println("Testing planar YUV encoding/decoding\n");
                        doYUV = true;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-yuvpad") && i < stringArray.length - 1) {
                        int n15 = 0;
                        try {
                            n15 = Integer.parseInt(stringArray[++i]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (n15 >= 1 && (n15 & n15 - 1) == 0) {
                            yuvAlign = n15;
                            continue;
                        }
                        TJBench.usage();
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-subsamp") && i < stringArray.length - 1) {
                        if (stringArray[++i].toUpperCase().startsWith("G")) {
                            n7 = 3;
                            continue;
                        }
                        if (stringArray[i].equals("444")) {
                            n7 = 0;
                            continue;
                        }
                        if (stringArray[i].equals("422")) {
                            n7 = 1;
                            continue;
                        }
                        if (stringArray[i].equals("440")) {
                            n7 = 4;
                            continue;
                        }
                        if (stringArray[i].equals("420")) {
                            n7 = 2;
                            continue;
                        }
                        if (stringArray[i].equals("411")) {
                            n7 = 5;
                            continue;
                        }
                        if (stringArray[i].equals("441")) {
                            n7 = 6;
                            continue;
                        }
                        TJBench.usage();
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-componly")) {
                        compOnly = true;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-nowrite")) {
                        write = false;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-limitscans")) {
                        limitScans = true;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-maxmemory") && i < stringArray.length - 1) {
                        int n16 = -1;
                        try {
                            n16 = Integer.parseInt(stringArray[++i]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (n16 < 0) {
                            TJBench.usage();
                        }
                        maxMemory = n16;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-maxpixels") && i < stringArray.length - 1) {
                        int n17 = -1;
                        try {
                            n17 = Integer.parseInt(stringArray[++i]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (n17 < 0) {
                            TJBench.usage();
                        }
                        maxPixels = n17;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-restart") && i < stringArray.length - 1) {
                        int n18 = -1;
                        String string2 = stringArray[++i];
                        Scanner scanner2 = new Scanner(string2).useDelimiter("b|B");
                        try {
                            n18 = scanner2.nextInt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (n18 < 0 || n18 > 65535 || scanner2.hasNext()) {
                            TJBench.usage();
                        }
                        if (string2.endsWith("B") || string2.endsWith("b")) {
                            restartIntervalBlocks = n18;
                            continue;
                        }
                        restartIntervalRows = n18;
                        continue;
                    }
                    if (stringArray[i].equalsIgnoreCase("-stoponwarning")) {
                        stopOnWarning = true;
                        continue;
                    }
                    TJBench.usage();
                }
            }
            if (precision == 16 && !lossless) {
                throw new Exception("-lossless must be specified along with -precision 16");
            }
            if (precision != 8 && doYUV) {
                throw new Exception("-yuv requires 8-bit data precision");
            }
            if (lossless && doYUV) {
                throw new Exception("ERROR: -lossless and -yuv are incompatible");
            }
            if ((sf.getNum() != 1 || sf.getDenom() != 1) && doTile) {
                System.out.println("Disabling tiled compression/decompression tests, because those tests do not");
                System.out.println("work when scaled decompression is enabled.\n");
                doTile = false;
                xformOpt &= 0xFFFFFFFB;
            }
            if (TJBench.isCropped(cr)) {
                if (!decompOnly) {
                    throw new Exception("ERROR: Partial image decompression can only be enabled for JPEG input images");
                }
                if (doTile) {
                    System.out.println("Disabling tiled compression/decompression tests, because those tests do not");
                    System.out.println("work when partial image decompression is enabled.\n");
                    doTile = false;
                    xformOpt &= 0xFFFFFFFB;
                }
                if (doYUV) {
                    throw new Exception("ERROR: -crop and -yuv are incompatible");
                }
            }
            if (!decompOnly) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                tJCompressor = new TJCompressor();
                tJCompressor.set(0, stopOnWarning ? 1 : 0);
                tJCompressor.set(1, bottomUp ? 1 : 0);
                tJCompressor.set(24, maxPixels);
                nArray3[0] = pf;
                object = tJCompressor.loadImage(precision, stringArray[0], nArray, 1, nArray2, nArray3);
                n = nArray[0];
                n2 = nArray2[0];
                pf = nArray3[0];
                int n19 = -1;
                n19 = stringArray[0].lastIndexOf(46);
                if (n19 >= 0) {
                    stringArray[0] = stringArray[0].substring(0, n19);
                }
            }
            if (quiet == 1 && !decompOnly) {
                System.out.println("All performance values in Mpixels/sec\n");
                System.out.format("Pixel     JPEG      JPEG  %s  %s   ", doTile ? "Tile " : "Image", doTile ? "Tile " : "Image");
                if (doYUV) {
                    System.out.print("Encode  ");
                }
                System.out.print("Comp    Comp    Decomp  ");
                if (doYUV) {
                    System.out.print("Decode");
                }
                System.out.print("\n");
                System.out.format("Format    Format    %s  Width  Height  ", lossless ? "PSV " : "Qual");
                if (doYUV) {
                    System.out.print("Perf    ");
                }
                System.out.print("Perf    Ratio   Perf    ");
                if (doYUV) {
                    System.out.print("Perf");
                }
                System.out.println("\n");
            }
            if (decompOnly) {
                TJBench.decompTest(stringArray[0]);
                System.out.println("");
                System.exit(n6);
            }
            System.gc();
            if (lossless) {
                if (n3 < 1 || n3 > 7 || n4 < 1 || n4 > 7) {
                    throw new Exception("PSV must be between 1 and 7.");
                }
            } else if (n3 < 1 || n3 > 100 || n4 < 1 || n4 > 100) {
                throw new Exception("Quality must be between 1 and 100.");
            }
            if (n7 >= 0 && n7 < 7) {
                for (int i = n4; i >= n3; --i) {
                    TJBench.fullTest(tJCompressor, object, n, n2, n7, i, stringArray[0]);
                }
                System.out.println("");
            } else {
                int n20;
                if (pf != 11) {
                    for (int i = n4; i >= n3; --i) {
                        TJBench.fullTest(tJCompressor, object, n, n2, 3, i, stringArray[0]);
                    }
                    System.out.println("");
                    System.gc();
                }
                for (n20 = n4; n20 >= n3; --n20) {
                    TJBench.fullTest(tJCompressor, object, n, n2, 2, n20, stringArray[0]);
                }
                System.out.println("");
                System.gc();
                for (n20 = n4; n20 >= n3; --n20) {
                    TJBench.fullTest(tJCompressor, object, n, n2, 1, n20, stringArray[0]);
                }
                System.out.println("");
                System.gc();
                for (n20 = n4; n20 >= n3; --n20) {
                    TJBench.fullTest(tJCompressor, object, n, n2, 0, n20, stringArray[0]);
                }
                System.out.println("");
            }
        }
        catch (Exception exception) {
            if (exception instanceof TJException) {
                TJException tJException = (TJException)exception;
                System.out.println((tJException.getErrorCode() == 0 ? "WARNING: " : "ERROR: ") + tJException.getMessage());
            } else {
                System.out.println("ERROR: " + exception.getMessage());
            }
            exception.printStackTrace();
            n6 = -1;
        }
        System.exit(n6);
    }

    static {
        maxMemory = 0;
        maxPixels = 0;
        precision = 8;
        quiet = 0;
        pf = 1;
        yuvAlign = 1;
        restartIntervalRows = 0;
        write = true;
        bmp = false;
        PIXFORMATSTR = new String[]{"RGB", "BGR", "RGBX", "BGRX", "XBGR", "XRGB", "GRAY", "", "", "", "", "CMYK"};
        SUBNAME_LONG = new String[]{"4:4:4", "4:2:2", "4:2:0", "GRAY", "4:4:0", "4:1:1", "4:4:1"};
        SUBNAME = new String[]{"444", "422", "420", "GRAY", "440", "411", "441"};
        CSNAME = new String[]{"RGB", "YCbCr", "GRAY", "CMYK", "YCCK"};
        sf = TJ.UNSCALED;
        cr = TJ.UNCROPPED;
        xformOp = 0;
        xformOpt = 0;
        benchTime = 5.0;
        warmup = 1.0;
        tjErrorCode = -1;
    }

    private static class DummyDCTFilter
    implements TJCustomFilter {
        private DummyDCTFilter() {
        }

        @Override
        public void customFilter(ShortBuffer shortBuffer, Rectangle rectangle, Rectangle rectangle2, int n, int n2, TJTransform tJTransform) {
            for (int i = 0; i < rectangle.width * rectangle.height; ++i) {
                shortBuffer.put(i, -shortBuffer.get(i));
            }
        }
    }
}

