/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.TJLoader;
import org.libjpegturbo.turbojpeg.TJTransform;

public class TJTransformer
extends TJDecompressor {
    private int[] transformedSizes = null;

    public TJTransformer() throws TJException {
        this.init();
    }

    public TJTransformer(byte[] byArray) throws TJException {
        this.init();
        this.setSourceImage(byArray, byArray.length);
    }

    public TJTransformer(byte[] byArray, int n) throws TJException {
        this.init();
        this.setSourceImage(byArray, n);
    }

    public void transform(byte[][] byArray, TJTransform[] tJTransformArray) throws TJException {
        this.transformedSizes = this.transform(this.getJPEGBuf(), this.getJPEGSize(), byArray, tJTransformArray);
    }

    @Deprecated
    public void transform(byte[][] byArray, TJTransform[] tJTransformArray, int n) throws TJException {
        this.processFlags(n);
        this.transform(byArray, tJTransformArray);
    }

    public TJDecompressor[] transform(TJTransform[] tJTransformArray) throws TJException {
        int n;
        byte[][] byArrayArray = new byte[tJTransformArray.length][];
        if (this.getWidth() < 1 || this.getHeight() < 1) {
            throw new IllegalStateException("JPEG buffer not initialized");
        }
        this.checkSubsampling();
        for (int i = 0; i < tJTransformArray.length; ++i) {
            n = this.getWidth();
            int n2 = this.getHeight();
            if ((tJTransformArray[i].options & 4) != 0) {
                if (tJTransformArray[i].width != 0) {
                    n = tJTransformArray[i].width;
                }
                if (tJTransformArray[i].height != 0) {
                    n2 = tJTransformArray[i].height;
                }
            }
            byArrayArray[i] = new byte[TJ.bufSize(n, n2, this.get(4))];
        }
        TJDecompressor[] tJDecompressorArray = new TJDecompressor[tJTransformArray.length];
        this.transform(byArrayArray, tJTransformArray);
        for (n = 0; n < tJTransformArray.length; ++n) {
            tJDecompressorArray[n] = new TJDecompressor(byArrayArray[n], this.transformedSizes[n]);
        }
        return tJDecompressorArray;
    }

    @Deprecated
    public TJDecompressor[] transform(TJTransform[] tJTransformArray, int n) throws TJException {
        this.processFlags(n);
        return this.transform(tJTransformArray);
    }

    public int[] getTransformedSizes() {
        if (this.transformedSizes == null) {
            throw new IllegalStateException("No image has been transformed yet");
        }
        return this.transformedSizes;
    }

    private native void init() throws TJException;

    private native int[] transform(byte[] var1, int var2, byte[][] var3, TJTransform[] var4) throws TJException;

    static {
        TJLoader.load();
    }
}

