/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.bibtex;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Element;
import writer2latex.api.ConverterFactory;
import writer2latex.api.OutputFile;
import writer2latex.bibtex.BibTeXEntryMap;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.i18n.ClassicI18n;
import writer2latex.latex.i18n.I18n;
import writer2latex.office.BibMark;
import writer2latex.office.OfficeReader;
import writer2latex.util.ExportNameCollection;

public class BibTeXDocument
implements OutputFile {
    private static final String FILE_EXTENSION = ".bib";
    private String sName;
    private Hashtable<String, BibMark> entries = new Hashtable();
    private ExportNameCollection exportNames = new ExportNameCollection("", true, "_-:");
    private I18n i18n;
    private boolean bIsMaster;

    public BibTeXDocument(String sName, boolean bIsMaster, OfficeReader ofr) {
        this.sName = sName;
        this.bIsMaster = bIsMaster;
        this.loadEntries(ofr);
        this.i18n = new ClassicI18n(new LaTeXConfig());
    }

    private void loadEntries(OfficeReader ofr) {
        List<Element> bibMarks = ofr.getBibliographyMarks();
        for (Element bibMark : bibMarks) {
            BibMark entry = new BibMark(bibMark);
            this.entries.put(entry.getIdentifier(), entry);
            this.exportNames.addName(entry.getIdentifier());
        }
    }

    public boolean isEmpty() {
        return this.entries.size() == 0;
    }

    public String getExportName(String sIdentifier) {
        return this.exportNames.getExportName(sIdentifier);
    }

    public String getName() {
        return this.sName;
    }

    @Override
    public String getFileName() {
        return new String(this.sName + FILE_EXTENSION);
    }

    @Override
    public String getMIMEType() {
        return "application/x-bibtex";
    }

    @Override
    public boolean isMasterDocument() {
        return this.bIsMaster;
    }

    @Override
    public boolean containsMath() {
        return false;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(os, "ASCII");
        osw.write("%% This file was converted to BibTeX by Writer2BibTeX ver. " + ConverterFactory.getVersion() + ".\n");
        osw.write("%% See http://writer2latex.sourceforge.net for more info.\n");
        osw.write("\n");
        Enumeration<BibMark> enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            BibMark entry = enumeration.nextElement();
            osw.write("@");
            osw.write(entry.getEntryType().toUpperCase());
            osw.write("{");
            osw.write(this.exportNames.getExportName(entry.getIdentifier()));
            osw.write(",\n");
            for (BibMark.EntryType entryType : BibMark.EntryType.values()) {
                String sValue = entry.getField(entryType);
                if (sValue == null) continue;
                if (entryType == BibMark.EntryType.author || entryType == BibMark.EntryType.editor) {
                    sValue = sValue.replaceAll(";", " and ");
                }
                osw.write("    ");
                osw.write(BibTeXEntryMap.getFieldName(entryType).toUpperCase());
                osw.write(" = {");
                for (int j = 0; j < sValue.length(); ++j) {
                    String s = this.i18n.convert(Character.toString(sValue.charAt(j)), false, "en");
                    if (s.charAt(0) == '\\') {
                        osw.write("{");
                    }
                    osw.write(s);
                    if (s.charAt(0) != '\\') continue;
                    osw.write("}");
                }
                osw.write("},\n");
            }
            osw.write("}\n\n");
        }
        osw.flush();
        osw.close();
    }
}

