/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2xhtml;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XComponentContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import org.openoffice.da.comp.w2lcommon.filter.ConfigurationDialogBase;
import org.openoffice.da.comp.w2lcommon.helper.DialogAccess;
import writer2latex.api.Converter;
import writer2latex.api.ConverterFactory;

public class ConfigurationDialog
extends ConfigurationDialogBase
implements XServiceInfo {
    private String sResourceDirName;
    public static String __serviceName = "org.openoffice.da.writer2xhtml.ConfigurationDialog";
    public static String __implementationName = "org.openoffice.da.comp.writer2xhtml.ConfigurationDialog";
    private final String[] sCharElements = new String[]{"span", "abbr", "acronym", "b", "big", "cite", "code", "del", "dfn", "em", "i", "ins", "kbd", "samp", "small", "strong", "sub", "sup", "tt", "var", "q"};

    public boolean supportsService(String sServiceName) {
        return sServiceName.equals(__serviceName);
    }

    public String getImplementationName() {
        return __implementationName;
    }

    public String[] getSupportedServiceNames() {
        String[] sSupportedServiceNames = new String[]{__serviceName};
        return sSupportedServiceNames;
    }

    @Override
    protected String getMIMEType() {
        return "text/html";
    }

    @Override
    protected String getDialogLibraryName() {
        return "W2XDialogs2";
    }

    @Override
    protected String getConfigFileName() {
        return "writer2xhtml.xml";
    }

    public ConfigurationDialog(XComponentContext xContext) {
        super(xContext);
        try {
            this.sResourceDirName = this.xPathSub.substituteVariables("$(user)/writer2xhtml-resources", false);
        }
        catch (NoSuchElementException e) {
            this.sResourceDirName = "writer2xhtml-resources";
        }
        this.pageHandlers.put("General", new GeneralHandler());
        this.pageHandlers.put("Template", new TemplateHandler());
        this.pageHandlers.put("Stylesheets", new StylesheetsHandler());
        this.pageHandlers.put("Formatting", new FormattingHandler());
        this.pageHandlers.put("Styles1", new Styles1Handler());
        this.pageHandlers.put("Styles2", new Styles2Handler());
        this.pageHandlers.put("Formatting", new FormattingHandler());
        this.pageHandlers.put("Content", new ContentHandler());
    }

    public String[] getSupportedMethodNames() {
        String[] sNames = new String[]{"EncodingChange", "CustomTemplateChange", "LoadTemplateClick", "TemplateKeyup", "UseCustomStylesheetChange", "IncludeCustomStylesheetClick", "LoadStylesheetClick", "NewResourceClick", "DeleteResourceClick", "StyleFamilyChange", "StyleNameChange", "NewStyleClick", "DeleteStyleClick", "LoadDefaultsClick"};
        return sNames;
    }

    private String none2empty(String s) {
        return s.equals("(none)") ? "" : s;
    }

    private String empty2none(String s) {
        String t = s.trim();
        return t.length() == 0 ? "(none)" : t;
    }

    private class ContentHandler
    extends ConfigurationDialogBase.PageHandler {
        private final String[] sFormulaValues = new String[]{"image+starmath", "image+latex", "starmath", "latex"};

        private ContentHandler() {
        }

        @Override
        protected void setControls(DialogAccess dlg) {
            this.listBoxFromConfig(dlg, "Formulas", "formulas", this.sFormulaValues, (short)0);
            this.textFieldFromConfig(dlg, "EndnotesHeading", "endnotes_heading");
            this.textFieldFromConfig(dlg, "FootnotesHeading", "footnotes_heading");
            this.checkBoxFromConfig(dlg, "EmbedSvg", "embed_svg");
            this.checkBoxFromConfig(dlg, "EmbedImg", "embed_img");
        }

        @Override
        protected void getControls(DialogAccess dlg) {
            this.listBoxToConfig(dlg, "Formulas", "formulas", this.sFormulaValues);
            this.textFieldToConfig(dlg, "EndnotesHeading", "endnotes_heading");
            this.textFieldToConfig(dlg, "FootnotesHeading", "footnotes_heading");
            this.checkBoxToConfig(dlg, "EmbedSvg", "embed_svg");
            this.checkBoxToConfig(dlg, "EmbedImg", "embed_img");
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            return false;
        }
    }

    private class FormattingHandler
    extends ConfigurationDialogBase.PageHandler {
        private final String[] sExportValues = new String[]{"convert_all", "ignore_styles", "ignore_hard", "ignore_all"};
        private final String[] sListExportValues = new String[]{"css1", "css1_hack", "hard_labels"};

        private FormattingHandler() {
        }

        @Override
        protected void setControls(DialogAccess dlg) {
            this.listBoxFromConfig(dlg, "Formatting", "formatting", this.sExportValues, (short)0);
            this.listBoxFromConfig(dlg, "FrameFormatting", "frame_formatting", this.sExportValues, (short)0);
            dlg.setCheckBoxStateAsBoolean("SectionFormatting", ConfigurationDialog.this.config.getOption("section_formatting").equals("convert_all") || ConfigurationDialog.this.config.getOption("section_formatting").equals("ignore_styles"));
            dlg.setCheckBoxStateAsBoolean("TableFormatting", ConfigurationDialog.this.config.getOption("table_formatting").equals("convert_all") || ConfigurationDialog.this.config.getOption("table_formatting").equals("ignore_styles"));
            this.checkBoxFromConfig(dlg, "IgnoreTableDimensions", "ignore_table_dimensions");
            this.listBoxFromConfig(dlg, "ListFormatting", "list_formatting", this.sListExportValues, (short)0);
            this.textFieldFromConfig(dlg, "MaxWidth", "max_width");
            this.checkBoxFromConfig(dlg, "SeparateStylesheet", "separate_stylesheet");
        }

        @Override
        protected void getControls(DialogAccess dlg) {
            this.listBoxToConfig(dlg, "Formatting", "formatting", this.sExportValues);
            this.listBoxToConfig(dlg, "FrameFormatting", "frame_formatting", this.sExportValues);
            ConfigurationDialog.this.config.setOption("section_formatting", dlg.getCheckBoxStateAsBoolean("SectionFormatting") ? "convert_all" : "ignore_all");
            ConfigurationDialog.this.config.setOption("table_formatting", dlg.getCheckBoxStateAsBoolean("TableFormatting") ? "convert_all" : "ignore_all");
            this.checkBoxToConfig(dlg, "IgnoreTableDimensions", "ignore_table_dimensions");
            this.listBoxToConfig(dlg, "ListFormatting", "list_formatting", this.sListExportValues);
            this.textFieldToConfig(dlg, "MaxWidth", "max_width");
            this.checkBoxToConfig(dlg, "SeparateStylesheet", "separate_stylesheet");
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            return false;
        }
    }

    private class Styles2Handler
    extends ConfigurationDialogBase.AttributePageHandler {
        private String[] sXhtmlAttributeNames = new String[]{"bold", "italics", "fixed", "superscript", "subscript", "underline", "overstrike"};

        public Styles2Handler() {
            this.sAttributeNames = this.sXhtmlAttributeNames;
        }

        @Override
        public void setControls(DialogAccess dlg) {
            super.setControls(dlg);
            this.textFieldFromConfig(dlg, "TabstopStyle", "tabstop_style");
        }

        @Override
        public void getControls(DialogAccess dlg) {
            super.getControls(dlg);
            this.textFieldToConfig(dlg, "TabstopStyle", "tabstop_style");
        }

        @Override
        protected void setControls(DialogAccess dlg, Map<String, String> attr) {
            if (!attr.containsKey("element")) {
                attr.put("element", "");
            }
            if (!attr.containsKey("css")) {
                attr.put("css", "");
            }
            dlg.setListBoxStringItemList("Element", ConfigurationDialog.this.sCharElements);
            dlg.setComboBoxText("Element", attr.get("element"));
            dlg.setTextFieldText("Css", ConfigurationDialog.this.none2empty(attr.get("css")));
        }

        @Override
        protected void getControls(DialogAccess dlg, Map<String, String> attr) {
            attr.put("element", dlg.getComboBoxText("Element"));
            attr.put("css", ConfigurationDialog.this.empty2none(dlg.getTextFieldText("Css")));
        }

        @Override
        protected void prepareControls(DialogAccess dlg, boolean bEnable) {
            dlg.setControlEnabled("ElementLabel", bEnable);
            dlg.setControlEnabled("Element", bEnable);
            dlg.setControlEnabled("CssLabel", bEnable);
            dlg.setControlEnabled("Css", bEnable);
        }
    }

    private class Styles1Handler
    extends ConfigurationDialogBase.StylesPageHandler {
        private final String[] sXhtmlFamilyNames;
        private final String[] sXhtmlOOoFamilyNames;
        private final String[] sParElements;
        private final String[] sParBlockElements;
        private final String[] sEmpty;
        private String[][] sElements;
        private String[][] sBlockElements;

        protected Styles1Handler() {
            super(5);
            this.sXhtmlFamilyNames = new String[]{"text", "paragraph", "heading", "list", "frame"};
            this.sXhtmlOOoFamilyNames = new String[]{"CharacterStyles", "ParagraphStyles", "ParagraphStyles", "NumberingStyles", "FrameStyles"};
            this.sParElements = new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "address", "dd", "dt", "pre"};
            this.sParBlockElements = new String[]{"div", "blockquote", "dl"};
            this.sEmpty = new String[0];
            this.sElements = new String[5][];
            this.sBlockElements = new String[5][];
            this.sFamilyNames = this.sXhtmlFamilyNames;
            this.sOOoFamilyNames = this.sXhtmlOOoFamilyNames;
            this.sElements[0] = ConfigurationDialog.this.sCharElements;
            this.sElements[1] = this.sParElements;
            this.sElements[2] = this.sParElements;
            this.sElements[3] = this.sEmpty;
            this.sElements[4] = this.sEmpty;
            this.sBlockElements[0] = this.sEmpty;
            this.sBlockElements[1] = this.sParBlockElements;
            this.sBlockElements[2] = this.sParBlockElements;
            this.sBlockElements[3] = this.sEmpty;
            this.sBlockElements[4] = this.sEmpty;
        }

        @Override
        protected String getDefaultConfigName() {
            return "cleanxhtml.xml";
        }

        @Override
        protected void setControls(DialogAccess dlg, Map<String, String> attr) {
            if (!attr.containsKey("element")) {
                attr.put("element", "");
            }
            if (!attr.containsKey("css")) {
                attr.put("css", "");
            }
            dlg.setComboBoxText("Element", attr.get("element"));
            dlg.setTextFieldText("Css", ConfigurationDialog.this.none2empty(attr.get("css")));
            if (this.nCurrentFamily == 1 || this.nCurrentFamily == 2) {
                if (!attr.containsKey("before")) {
                    attr.put("before", "");
                }
                if (!attr.containsKey("after")) {
                    attr.put("after", "");
                }
                dlg.setTextFieldText("Before", attr.get("before"));
                dlg.setTextFieldText("After", attr.get("after"));
            } else {
                dlg.setTextFieldText("Before", "");
                dlg.setTextFieldText("After", "");
            }
            if (this.nCurrentFamily == 1 || this.nCurrentFamily == 2) {
                if (!attr.containsKey("block-element")) {
                    attr.put("block-element", "");
                }
                if (!attr.containsKey("block-css")) {
                    attr.put("block-css", "");
                }
                dlg.setComboBoxText("BlockElement", attr.get("block-element"));
                dlg.setTextFieldText("BlockCss", ConfigurationDialog.this.none2empty(attr.get("block-css")));
            } else {
                dlg.setComboBoxText("BlockElement", "");
                dlg.setTextFieldText("BlockCss", "");
            }
        }

        @Override
        protected void getControls(DialogAccess dlg, Map<String, String> attr) {
            attr.put("element", dlg.getComboBoxText("Element"));
            attr.put("css", ConfigurationDialog.this.empty2none(dlg.getTextFieldText("Css")));
            if (this.nCurrentFamily == 1 || this.nCurrentFamily == 2) {
                attr.put("before", dlg.getTextFieldText("Before"));
                attr.put("after", dlg.getTextFieldText("After"));
            }
            if (this.nCurrentFamily == 1 || this.nCurrentFamily == 2) {
                attr.put("block-element", dlg.getComboBoxText("BlockElement"));
                attr.put("block-css", ConfigurationDialog.this.empty2none(dlg.getTextFieldText("BlockCss")));
            }
        }

        @Override
        protected void clearControls(DialogAccess dlg) {
            dlg.setComboBoxText("Element", "");
            dlg.setTextFieldText("Css", "");
            dlg.setTextFieldText("Before", "");
            dlg.setTextFieldText("After", "");
            dlg.setComboBoxText("BlockElement", "");
            dlg.setTextFieldText("BlockCss", "");
        }

        @Override
        protected void prepareControls(DialogAccess dlg, boolean bHasMappings) {
            dlg.setListBoxStringItemList("Element", this.sElements[this.nCurrentFamily]);
            dlg.setListBoxStringItemList("BlockElement", this.sBlockElements[this.nCurrentFamily]);
            dlg.setControlEnabled("ElementLabel", bHasMappings && this.nCurrentFamily <= 2);
            dlg.setControlEnabled("Element", bHasMappings && this.nCurrentFamily <= 2);
            dlg.setControlEnabled("CssLabel", bHasMappings);
            dlg.setControlEnabled("Css", bHasMappings);
            dlg.setControlEnabled("BeforeLabel", bHasMappings && (this.nCurrentFamily == 1 || this.nCurrentFamily == 2));
            dlg.setControlEnabled("Before", bHasMappings && (this.nCurrentFamily == 1 || this.nCurrentFamily == 2));
            dlg.setControlEnabled("AfterLabel", bHasMappings && (this.nCurrentFamily == 1 || this.nCurrentFamily == 2));
            dlg.setControlEnabled("After", bHasMappings && (this.nCurrentFamily == 1 || this.nCurrentFamily == 2));
            dlg.setControlEnabled("BlockElementLabel", bHasMappings && (this.nCurrentFamily == 1 || this.nCurrentFamily == 2));
            dlg.setControlEnabled("BlockElement", bHasMappings && (this.nCurrentFamily == 1 || this.nCurrentFamily == 2));
            dlg.setControlEnabled("BlockCssLabel", bHasMappings && (this.nCurrentFamily == 1 || this.nCurrentFamily == 2));
            dlg.setControlEnabled("BlockCss", bHasMappings && (this.nCurrentFamily == 1 || this.nCurrentFamily == 2));
        }
    }

    private class StylesheetsHandler
    extends ConfigurationDialogBase.CustomFileHandler {
        private StylesheetsHandler() {
        }

        @Override
        protected String getSuffix() {
            return "Stylesheet";
        }

        @Override
        protected String getFileName() {
            return "writer2xhtml-styles.css";
        }

        @Override
        protected void useCustomInner(DialogAccess dlg, boolean bEnable) {
            dlg.setControlEnabled("ResourceLabel", bEnable);
            dlg.setControlEnabled("Resources", bEnable);
            dlg.setControlEnabled("NewResourceButton", bEnable);
            dlg.setControlEnabled("DeleteResourceButton", bEnable);
            this.updateResources(dlg);
        }

        @Override
        protected void setControls(DialogAccess dlg) {
            super.setControls(dlg);
            dlg.setCheckBoxStateAsBoolean("LinkCustomStylesheet", ConfigurationDialog.this.config.getOption("custom_stylesheet").length() > 0);
            this.textFieldFromConfig(dlg, "CustomStylesheetURL", "custom_stylesheet");
            this.linkCustomStylesheetChange(dlg);
            this.updateResources(dlg);
        }

        @Override
        protected void getControls(DialogAccess dlg) {
            super.getControls(dlg);
            if (dlg.getCheckBoxStateAsBoolean("LinkCustomStylesheet")) {
                this.textFieldToConfig(dlg, "CustomStylesheetURL", "custom_stylesheet");
            } else {
                ConfigurationDialog.this.config.setOption("custom_stylesheet", "");
            }
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            if (super.handleEvent(dlg, sMethod)) {
                return true;
            }
            if (sMethod.equals("LinkCustomStylesheetChange")) {
                this.linkCustomStylesheetChange(dlg);
                return true;
            }
            if (sMethod.equals("NewResourceClick")) {
                this.newResourceClick(dlg);
                return true;
            }
            if (sMethod.equals("DeleteResourceClick")) {
                this.deleteResourceClick(dlg);
                return true;
            }
            return false;
        }

        private void linkCustomStylesheetChange(DialogAccess dlg) {
            boolean bLinkCustomStylesheet = dlg.getCheckBoxStateAsBoolean("LinkCustomStylesheet");
            dlg.setControlEnabled("CustomStylesheetURLLabel", bLinkCustomStylesheet);
            dlg.setControlEnabled("CustomStylesheetURL", bLinkCustomStylesheet);
        }

        private void newResourceClick(DialogAccess dlg) {
            String[] sFileNames = ConfigurationDialog.this.filePicker.getPaths();
            if (sFileNames != null) {
                this.createResourceDir();
                for (String sFileName : sFileNames) {
                    String sBaseFileName = sFileName.substring(sFileName.lastIndexOf(47) + 1);
                    try {
                        String sTargetFileName = ConfigurationDialog.this.sResourceDirName + "/" + sBaseFileName;
                        if (this.fileExists(sTargetFileName)) {
                            this.killFile(sTargetFileName);
                        }
                        ConfigurationDialog.this.sfa2.copy(sFileName, sTargetFileName);
                    }
                    catch (CommandAbortedException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.updateResources(dlg);
            }
        }

        private void deleteResourceClick(DialogAccess dlg) {
            String sFileName;
            short nItem = dlg.getListBoxSelectedItem("Resources");
            if (nItem >= 0 && this.deleteItem(sFileName = dlg.getListBoxStringItemList("Resources")[nItem])) {
                this.killFile(ConfigurationDialog.this.sResourceDirName + "/" + sFileName);
                this.updateResources(dlg);
            }
        }

        private void updateResources(DialogAccess dlg) {
            this.createResourceDir();
            try {
                String[] sFiles = ConfigurationDialog.this.sfa2.getFolderContents(ConfigurationDialog.this.sResourceDirName, false);
                int nCount = sFiles.length;
                for (int i = 0; i < nCount; ++i) {
                    sFiles[i] = sFiles[i].substring(sFiles[i].lastIndexOf(47) + 1);
                }
                dlg.setListBoxStringItemList("Resources", sFiles);
            }
            catch (CommandAbortedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void createResourceDir() {
            try {
                if (!ConfigurationDialog.this.sfa2.isFolder(ConfigurationDialog.this.sResourceDirName)) {
                    ConfigurationDialog.this.sfa2.createFolder(ConfigurationDialog.this.sResourceDirName);
                }
            }
            catch (CommandAbortedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class TemplateHandler
    extends ConfigurationDialogBase.CustomFileHandler {
        private TemplateHandler() {
        }

        @Override
        protected String getSuffix() {
            return "Template";
        }

        @Override
        protected String getFileName() {
            return "writer2xhtml-template.xhtml";
        }

        @Override
        protected void useCustomInner(DialogAccess dlg, boolean bEnable) {
            dlg.setControlEnabled("TestTemplateLabel", bEnable);
            dlg.setControlEnabled("ContentIdLabel", bEnable);
            dlg.setControlEnabled("ContentId", bEnable);
            dlg.setControlEnabled("HeaderIdLabel", bEnable);
            dlg.setControlEnabled("HeaderId", bEnable);
            dlg.setControlEnabled("FooterIdLabel", bEnable);
            dlg.setControlEnabled("FooterId", bEnable);
            dlg.setControlEnabled("PanelIdLabel", bEnable);
            dlg.setControlEnabled("PanelId", bEnable);
        }

        @Override
        protected void setControls(DialogAccess dlg) {
            super.setControls(dlg);
            String[] sCustomIds = ConfigurationDialog.this.config.getOption("template_ids").split(",");
            if (sCustomIds.length > 0) {
                dlg.setComboBoxText("ContentId", sCustomIds[0]);
            }
            if (sCustomIds.length > 1) {
                dlg.setComboBoxText("HeaderId", sCustomIds[1]);
            }
            if (sCustomIds.length > 2) {
                dlg.setComboBoxText("FooterId", sCustomIds[2]);
            }
            if (sCustomIds.length > 3) {
                dlg.setComboBoxText("PanelId", sCustomIds[3]);
            }
            this.testTemplate(dlg);
        }

        @Override
        protected void getControls(DialogAccess dlg) {
            super.getControls(dlg);
            ConfigurationDialog.this.config.setOption("template_ids", dlg.getComboBoxText("ContentId").trim() + "," + dlg.getComboBoxText("HeaderId").trim() + "," + dlg.getComboBoxText("FooterId").trim() + "," + dlg.getComboBoxText("PanelId").trim());
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            if (super.handleEvent(dlg, sMethod)) {
                return true;
            }
            if (sMethod.equals("TemplateKeyup")) {
                this.testTemplate(dlg);
                return true;
            }
            return false;
        }

        @Override
        protected void loadCustomClick(DialogAccess dlg) {
            super.loadCustomClick(dlg);
            this.testTemplate(dlg);
        }

        private void testTemplate(DialogAccess dlg) {
            Converter converter = ConverterFactory.createConverter("text/html");
            String sTemplate = dlg.getTextFieldText("CustomTemplate").trim();
            if (sTemplate.length() > 0) {
                try {
                    converter.readTemplate(new ByteArrayInputStream(sTemplate.getBytes()));
                    dlg.setLabelText("TestTemplateLabel", "");
                }
                catch (IOException e) {
                    dlg.setLabelText("TestTemplateLabel", "ERROR: " + e.getMessage());
                }
            } else {
                dlg.setLabelText("TestTemplateLabel", "");
            }
        }
    }

    private class GeneralHandler
    extends ConfigurationDialogBase.PageHandler {
        private final String[] sEncodingValues = new String[]{"UTF-8", "UTF-16", "ISO-8859-1", "US-ASCII"};

        private GeneralHandler() {
        }

        @Override
        protected void setControls(DialogAccess dlg) {
            this.checkBoxFromConfig(dlg, "NoDoctype", "no_doctype");
            this.listBoxFromConfig(dlg, "Encoding", "encoding", this.sEncodingValues, (short)0);
            this.checkBoxFromConfig(dlg, "AddBOM", "add_bom");
            if ("true".equals(ConfigurationDialog.this.config.getOption("hexadecimal_entities"))) {
                dlg.setListBoxSelectedItem("HexadecimalEntities", (short)0);
            } else {
                dlg.setListBoxSelectedItem("HexadecimalEntities", (short)1);
            }
            this.checkBoxFromConfig(dlg, "UseNamedEntities", "use_named_entities");
            this.checkBoxFromConfig(dlg, "Multilingual", "multilingual");
            this.checkBoxFromConfig(dlg, "PrettyPrint", "pretty_print");
            this.encodingChange(dlg);
        }

        @Override
        protected void getControls(DialogAccess dlg) {
            this.checkBoxToConfig(dlg, "NoDoctype", "no_doctype");
            this.listBoxToConfig(dlg, "Encoding", "encoding", this.sEncodingValues);
            this.checkBoxToConfig(dlg, "AddBOM", "add_bom");
            ConfigurationDialog.this.config.setOption("hexadecimal_entities", Boolean.toString(dlg.getListBoxSelectedItem("HexadecimalEntities") == 0));
            this.checkBoxToConfig(dlg, "UseNamedEntities", "use_named_entities");
            this.checkBoxToConfig(dlg, "Multilingual", "multilingual");
            this.checkBoxToConfig(dlg, "PrettyPrint", "pretty_print");
        }

        @Override
        protected boolean handleEvent(DialogAccess dlg, String sMethod) {
            if (sMethod.equals("EncodingChange")) {
                this.encodingChange(dlg);
                return true;
            }
            return false;
        }

        private void encodingChange(DialogAccess dlg) {
            short nEncoding = dlg.getListBoxSelectedItem("Encoding");
            dlg.setControlEnabled("AddBOM", nEncoding == 0);
            dlg.setControlEnabled("HexadecimalEntitiesLabel", nEncoding > 1);
            dlg.setControlEnabled("HexadecimalEntities", nEncoding > 1);
        }
    }
}

