#ifndef M4RI_M4RI_CONFIG_H
#define M4RI_M4RI_CONFIG_H

// Defines determined during configuration of m4ri.
#define __M4RI_HAVE_MM_MALLOC		1
#define __M4RI_HAVE_POSIX_MEMALIGN	1
#define __M4RI_HAVE_SSE2		1
#define __M4RI_HAVE_OPENMP		1
#define __M4RI_CPU_L1_CACHE		32768
#define __M4RI_CPU_L2_CACHE		1048576
#define __M4RI_CPU_L3_CACHE		33554432
#define __M4RI_DEBUG_DUMP		(0 || 0)
#define __M4RI_DEBUG_MZD		0
#define __M4RI_HAVE_LIBPNG              1

#define __M4RI_CC                       "gcc"
#define __M4RI_CFLAGS                   " -mmmx -msse -msse2 -msse3 -fopenmp -march=x86-64 -mtune=generic -O2 -pipe -fno-plt -fexceptions         -Wp,-D_FORTIFY_SOURCE=3 -Wformat -Werror=format-security         -fstack-clash-protection -fcf-protection         -fno-omit-frame-pointer -mno-omit-leaf-frame-pointer -g -ffile-prefix-map=/build/m4ri/src=/usr/src/debug/m4ri -flto=auto"
#define __M4RI_SIMD_CFLAGS              " -mmmx -msse -msse2 -msse3"
#define __M4RI_OPENMP_CFLAGS            "-fopenmp"

// Helper macros.
#define __M4RI_USE_MM_MALLOC		(__M4RI_HAVE_MM_MALLOC && __M4RI_HAVE_SSE2)
#define __M4RI_USE_POSIX_MEMALIGN	(__M4RI_HAVE_POSIX_MEMALIGN && __M4RI_HAVE_SSE2)
#define __M4RI_DD_QUIET			(0 && !0)

#define __M4RI_ENABLE_MZD_CACHE         0
#define __M4RI_ENABLE_MMC               0

#endif // M4RI_M4RI_CONFIG_H
