/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import org.apache.lucene.util.packed.BulkOperationPacked;

final class BulkOperationPacked16
extends BulkOperationPacked {
    public BulkOperationPacked16() {
        super(16);
    }

    @Override
    public void decode(long[] blocks, int blocksOffset, int[] values2, int valuesOffset, int iterations) {
        for (int i = 0; i < iterations; ++i) {
            long block = blocks[blocksOffset++];
            for (int shift = 48; shift >= 0; shift -= 16) {
                values2[valuesOffset++] = (int)(block >>> shift & 0xFFFFL);
            }
        }
    }

    @Override
    public void decode(byte[] blocks, int blocksOffset, int[] values2, int valuesOffset, int iterations) {
        for (int j = 0; j < iterations; ++j) {
            values2[valuesOffset++] = (blocks[blocksOffset++] & 0xFF) << 8 | blocks[blocksOffset++] & 0xFF;
        }
    }

    @Override
    public void decode(long[] blocks, int blocksOffset, long[] values2, int valuesOffset, int iterations) {
        for (int i = 0; i < iterations; ++i) {
            long block = blocks[blocksOffset++];
            for (int shift = 48; shift >= 0; shift -= 16) {
                values2[valuesOffset++] = block >>> shift & 0xFFFFL;
            }
        }
    }

    @Override
    public void decode(byte[] blocks, int blocksOffset, long[] values2, int valuesOffset, int iterations) {
        for (int j = 0; j < iterations; ++j) {
            values2[valuesOffset++] = ((long)blocks[blocksOffset++] & 0xFFL) << 8 | (long)blocks[blocksOffset++] & 0xFFL;
        }
    }
}

