/*! For license information please see deck-node_modules_css-loader_dist_runtime_getUrl_js-src_BoardSelector_vue-data_image_svg_xml_3csvg-edabde.js.LICENSE.txt */
"use strict";(self.webpackChunkdeck=self.webpackChunkdeck||[]).push([["node_modules_css-loader_dist_runtime_getUrl_js-src_BoardSelector_vue-data_image_svg_xml_3csvg-edabde"],{82436:(t,e,n)=>{n.d(e,{Z:()=>i});var a=n(87537),o=n.n(a),r=n(23645),l=n.n(r)()(o());l.push([t.id,"\n#modal-inner[data-v-5ef3b78a] {\n\twidth: 90vw;\n\tmax-width: 400px;\n\tpadding: 20px;\n}\nul[data-v-5ef3b78a] {\n\tmin-height: 100px;\n}\nli[data-v-5ef3b78a] {\n\tpadding: 6px;\n\tborder: 1px solid transparent;\n}\nli[data-v-5ef3b78a]:hover, li[data-v-5ef3b78a]:focus {\n\tbackground-color: var(--color-background-dark);\n}\nli.selected[data-v-5ef3b78a] {\n\tborder: 1px solid var(--color-primary-element);\n}\n.board-bullet[data-v-5ef3b78a] {\n\tdisplay: inline-block;\n\twidth: 12px;\n\theight: 12px;\n\tborder: none;\n\tborder-radius: 50%;\n\tcursor: pointer;\n}\nli > span[data-v-5ef3b78a],\n.avatar[data-v-5ef3b78a] {\n\tvertical-align: middle;\n}\n\n","",{version:3,sources:["webpack://./src/BoardSelector.vue"],names:[],mappings:";AAoIA;CACA,WAAA;CACA,gBAAA;CACA,aAAA;AACA;AAEA;CACA,iBAAA;AACA;AAEA;CACA,YAAA;CACA,6BAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;CACA,qBAAA;CACA,WAAA;CACA,YAAA;CACA,YAAA;CACA,kBAAA;CACA,eAAA;AACA;AAEA;;CAEA,sBAAA;AAEA",sourcesContent:["\x3c!--\n  - @copyright Copyright (c) 2019 Julius Härtl <jus@bitgrid.net>\n  -\n  - @author Julius Härtl <jus@bitgrid.net>\n  -\n  - @license GNU AGPL version 3 or any later version\n  -\n  - This program is free software: you can redistribute it and/or modify\n  - it under the terms of the GNU Affero General Public License as\n  - published by the Free Software Foundation, either version 3 of the\n  - License, or (at your option) any later version.\n  -\n  - This program is distributed in the hope that it will be useful,\n  - but WITHOUT ANY WARRANTY; without even the implied warranty of\n  - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n  - GNU Affero General Public License for more details.\n  -\n  - You should have received a copy of the GNU Affero General Public License\n  - along with this program. If not, see <http://www.gnu.org/licenses/>.\n  -\n  --\x3e\n\n<template>\n\t<NcModal @close=\"close\">\n\t\t<div id=\"modal-inner\" :class=\"{ 'icon-loading': loading }\">\n\t\t\t<h1>{{ t('deck', 'Select the board to link to a project') }}</h1>\n\t\t\t<input v-model=\"filter\" type=\"text\" :placeholder=\"t('deck', 'Search by board title')\">\n\t\t\t<ul v-if=\"!loading\">\n\t\t\t\t<li v-for=\"board in availableBoards\"\n\t\t\t\t\t:key=\"board.id\"\n\t\t\t\t\t:class=\"{'selected': (selectedBoard === board.id) }\"\n\t\t\t\t\t@click=\"selectedBoard=board.id\">\n\t\t\t\t\t<span :style=\"{ 'backgroundColor': '#' + board.color }\" class=\"board-bullet\" />\n\t\t\t\t\t<span>{{ board.title }}</span>\n\t\t\t\t</li>\n\t\t\t</ul>\n\t\t\t<button v-if=\"!loading\" class=\"primary\" @click=\"select\">\n\t\t\t\t{{ t('deck', 'Select board') }}\n\t\t\t</button>\n\t\t</div>\n\t</NcModal>\n</template>\n<script>\nimport { NcModal } from '@nextcloud/vue'\nimport axios from '@nextcloud/axios'\nimport { generateUrl } from '@nextcloud/router'\n\nexport default {\n\tname: 'BoardSelector',\n\tcomponents: {\n\t\tNcModal,\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tfilter: '',\n\t\t\tboards: [],\n\t\t\tselectedBoard: null,\n\t\t\tloading: true,\n\t\t\tcurrentBoard: null,\n\t\t}\n\t},\n\tcomputed: {\n\t\tavailableBoards() {\n\t\t\treturn this.boards.filter((board) => (\n\t\t\t\t'' + board.id !== '' + this.currentBoard\n\t\t\t\t&& board.title.match(this.filter)\n\t\t\t))\n\t\t},\n\t},\n\tbeforeMount() {\n\t\tthis.fetchBoards()\n\t\tconst hash = window.location.hash.match(/\\/boards\\/([0-9]+)/)\n\t\tthis.currentBoard = hash.length > 0 ? hash[1] : null\n\t},\n\tmethods: {\n\t\tfetchBoards() {\n\t\t\taxios.get(generateUrl('/apps/deck/boards')).then((response) => {\n\t\t\t\tthis.boards = response.data\n\t\t\t\tthis.loading = false\n\t\t\t})\n\t\t},\n\t\tclose() {\n\t\t\tthis.$root.$emit('close')\n\t\t},\n\t\tselect() {\n\t\t\tthis.$root.$emit('select', this.selectedBoard)\n\t\t},\n\t},\n\n}\n<\/script>\n<style scoped>\n\t#modal-inner {\n\t\twidth: 90vw;\n\t\tmax-width: 400px;\n\t\tpadding: 20px;\n\t}\n\n\tul {\n\t\tmin-height: 100px;\n\t}\n\n\tli {\n\t\tpadding: 6px;\n\t\tborder: 1px solid transparent;\n\t}\n\n\tli:hover, li:focus {\n\t\tbackground-color: var(--color-background-dark);\n\t}\n\n\tli.selected {\n\t\tborder: 1px solid var(--color-primary-element);\n\t}\n\n\t.board-bullet {\n\t\tdisplay: inline-block;\n\t\twidth: 12px;\n\t\theight: 12px;\n\t\tborder: none;\n\t\tborder-radius: 50%;\n\t\tcursor: pointer;\n\t}\n\n\tli > span,\n\t.avatar {\n\t\tvertical-align: middle;\n\n\t}\n\n</style>\n"],sourceRoot:""}]);const i=l},61667:t=>{t.exports=function(t,e){return e||(e={}),t?(t=String(t.__esModule?t.default:t),/^['"].*['"]$/.test(t)&&(t=t.slice(1,-1)),e.hash&&(t+=e.hash),/["'() \t\n]|(%20)/.test(t)||e.needQuotes?'"'.concat(t.replace(/"/g,'\\"').replace(/\n/g,"\\n"),'"'):t):t}},60498:(t,e,n)=>{n.r(e),n.d(e,{default:()=>C});var a=n(64882),o=n(97040),r=n(11480);const l={name:"BoardSelector",components:{NcModal:a.Jc},data:()=>({filter:"",boards:[],selectedBoard:null,loading:!0,currentBoard:null}),computed:{availableBoards(){return this.boards.filter((t=>""+t.id!=""+this.currentBoard&&t.title.match(this.filter)))}},beforeMount(){this.fetchBoards();const t=window.location.hash.match(/\/boards\/([0-9]+)/);this.currentBoard=t.length>0?t[1]:null},methods:{fetchBoards(){o.ZP.get((0,r.nu)("/apps/deck/boards")).then((t=>{this.boards=t.data,this.loading=!1}))},close(){this.$root.$emit("close")},select(){this.$root.$emit("select",this.selectedBoard)}}};var i=n(93379),s=n.n(i),d=n(7795),c=n.n(d),A=n(90569),h=n.n(A),u=n(3565),p=n.n(u),b=n(19216),g=n.n(b),m=n(44589),v=n.n(m),N=n(82436),f={};f.styleTagTransform=v(),f.setAttributes=p(),f.insert=h().bind(null,"head"),f.domAPI=c(),f.insertStyleElement=g();s()(N.Z,f);N.Z&&N.Z.locals&&N.Z.locals;const C=(0,n(51900).Z)(l,(function(){var t=this,e=t._self._c;return e("NcModal",{on:{close:t.close}},[e("div",{class:{"icon-loading":t.loading},attrs:{id:"modal-inner"}},[e("h1",[t._v(t._s(t.t("deck","Select the board to link to a project")))]),t._v(" "),e("input",{directives:[{name:"model",rawName:"v-model",value:t.filter,expression:"filter"}],attrs:{type:"text",placeholder:t.t("deck","Search by board title")},domProps:{value:t.filter},on:{input:function(e){e.target.composing||(t.filter=e.target.value)}}}),t._v(" "),t.loading?t._e():e("ul",t._l(t.availableBoards,(function(n){return e("li",{key:n.id,class:{selected:t.selectedBoard===n.id},on:{click:function(e){t.selectedBoard=n.id}}},[e("span",{staticClass:"board-bullet",style:{backgroundColor:"#"+n.color}}),t._v(" "),e("span",[t._v(t._s(n.title))])])})),0),t._v(" "),t.loading?t._e():e("button",{staticClass:"primary",on:{click:t.select}},[t._v("\n\t\t\t"+t._s(t.t("deck","Select board"))+"\n\t\t")])])])}),[],!1,null,"5ef3b78a",null).exports},81488:t=>{t.exports="data:image/svg+xml,%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M15.4%2016.6L10.8%2012l4.6-4.6L14%206l-6%206%206%206%201.4-1.4z%27/%3e%3c/svg%3e"},34868:t=>{t.exports="data:image/svg+xml,%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M18.4%207.4L17%206l-6%206%206%206%201.4-1.4-4.6-4.6%204.6-4.6m-6%200L11%206l-6%206%206%206%201.4-1.4L7.8%2012l4.6-4.6z%27/%3e%3c/svg%3e"},37059:t=>{t.exports="data:image/svg+xml,%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M5.6%207.4L7%206l6%206-6%206-1.4-1.4%204.6-4.6-4.6-4.6m6%200L13%206l6%206-6%206-1.4-1.4%204.6-4.6-4.6-4.6z%27/%3e%3c/svg%3e"},75701:t=>{t.exports="data:image/svg+xml,%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M8.6%2016.6l4.6-4.6-4.6-4.6L10%206l6%206-6%206-1.4-1.4z%27/%3e%3c/svg%3e"},64882:(t,e,n)=>{n.d(e,{$U:()=>T.N,FK:()=>K.N,Iw:()=>i.N,Jc:()=>et.Z,Jh:()=>J.N,Js:()=>a.Z,O3:()=>A.N,P2:()=>P.Z,QG:()=>ct.N,SL:()=>W.Z,Xn:()=>M.N,a0:()=>z.N,fg:()=>E.N,h3:()=>At.N,ih:()=>s.Z,kC:()=>F.Z,lb:()=>tt.Z,rr:()=>h.Z,rw:()=>U.N});n(16238);var a=n(32979),o=n(43181),r=n(25381),l=n(92591),i=n(45429),s=n(36456),d=n(42591),c=n(54627),A=n(92256),h=n(58449),u=n(57063),p=n(79504),b=n(34395),g=n(27657),m=n(2047),v=n(13538),N=n(43451),f=n(79380),C=n(18561),w=n(17461),x=n(62730),Z=n(95837),k=n(6277),B=n(56778),y=n(81935),_=n(45082),S=n(88408),L=n(65982),M=n(56830),T=n(38497),E=n(84748),P=n(49306),U=n(88441),$=n(48684),G=n(58614),I=n(23770),R=n(27054),Y=n(22208),J=n(22607),j=n(15592),F=n(69052),z=n(84530),H=n(27535),O=n(95969),W=n(89364),X=n(93138),Q=n(64412),q=n(62448),K=n(5414),D=n(9879),V=n(24959),tt=n(65933),et=n(13155),nt=n(22166),at=n(58916),ot=n(93782),rt=n(88080),lt=n(36610),it=n(46265),st=n(6671),dt=n(56451),ct=(n(69121),n(80797),n(97040),n(43856)),At=n(38310),ht=(n(69183),n(96505)),ut=n(57117),pt=n(22481),bt=n(77741),gt=n(95173),mt=n(80144),vt=n(66233),Nt=n(57404),ft=n(19577),Ct=(n(52299),n(50279),n(55645),n(36214),n(90318)),wt=n(17593),xt=(n(18296),n(84722),n(76692),n(40946),n(67444));a.Z,o.N,r.Z,l.Z,i.N,s.Z,d.Z,c.Z,h.Z,u.Z,p.Z,A.N,b.N,g.Z,m.Z,v.N,N.N,f.Z,C.N,w.Z,x.Z,Z.N,k.N,B.Z,y.N,_.Z,S.N,L.Z,st.N,M.N,T.N,E.N,P.Z,U.N,$.N,G.N,I.Z,R.N,Y.N,J.N,j.Z,F.Z,z.N,H.N,O.N,W.Z,X.Z,Q.N,q.N,K.N,D.N,V.N,tt.Z,it.N,et.Z,nt.Z,at.N,ot.N,rt.N,lt.N,st.a,dt.N,ht.N,ct.N,ut.N,pt.N,bt.N,gt.N,ft.Z,At.N,mt.N,vt.N,Nt.N,Symbol.toStringTag,Ct.X,wt.X,xt.NS,Symbol.toStringTag}}]);
//# sourceMappingURL=deck-node_modules_css-loader_dist_runtime_getUrl_js-src_BoardSelector_vue-data_image_svg_xml_3csvg-edabde.js.map?v=f961e5e269fdef2416aa