/*! For license information please see deck-node_modules_css-loader_dist_runtime_getUrl_js-src_CardSelector_vue-data_image_svg_xml_3csvg_-2d9259.js.LICENSE.txt */
"use strict";(self.webpackChunkdeck=self.webpackChunkdeck||[]).push([["node_modules_css-loader_dist_runtime_getUrl_js-src_CardSelector_vue-data_image_svg_xml_3csvg_-2d9259"],{78568:(t,e,n)=>{n.d(e,{Z:()=>l});var o=n(87537),a=n.n(o),r=n(23645),s=n.n(r)()(a());s.push([t.id,"\n#modal-inner[data-v-2a78567d] {\n\twidth: 90vw;\n\tmax-width: 400px;\n\tpadding: 20px;\n\theight: 200px;\n}\n.multiselect[data-v-2a78567d] {\n\twidth: 100%;\n\tmargin-bottom: 10px;\n}\nul[data-v-2a78567d] {\n\tmin-height: 100px;\n}\nli[data-v-2a78567d] {\n\tpadding: 6px;\n\tborder: 1px solid transparent;\n}\nli[data-v-2a78567d]:hover, li[data-v-2a78567d]:focus {\n\tbackground-color: var(--color-background-dark);\n}\n.board-bullet[data-v-2a78567d] {\n\tdisplay: inline-block;\n\twidth: 12px;\n\theight: 12px;\n\tborder: none;\n\tborder-radius: 50%;\n\tcursor: pointer;\n}\nbutton[data-v-2a78567d] {\n\tfloat: right;\n}\n.card-selector[data-v-2a78567d] .modal-container {\n\toverflow: visible !important;\n}\n","",{version:3,sources:["webpack://./src/CardSelector.vue"],names:[],mappings:";AAgLA;CACA,WAAA;CACA,gBAAA;CACA,aAAA;CACA,aAAA;AACA;AAEA;CACA,WAAA;CACA,mBAAA;AACA;AAEA;CACA,iBAAA;AACA;AAEA;CACA,YAAA;CACA,6BAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;CACA,qBAAA;CACA,WAAA;CACA,YAAA;CACA,YAAA;CACA,kBAAA;CACA,eAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,4BAAA;AACA",sourcesContent:["\x3c!--\n  - @copyright Copyright (c) 2019 Julius Härtl <jus@bitgrid.net>\n  -\n  - @author Julius Härtl <jus@bitgrid.net>\n  -\n  - @license GNU AGPL version 3 or any later version\n  -\n  - This program is free software: you can redistribute it and/or modify\n  - it under the terms of the GNU Affero General Public License as\n  - published by the Free Software Foundation, either version 3 of the\n  - License, or (at your option) any later version.\n  -\n  - This program is distributed in the hope that it will be useful,\n  - but WITHOUT ANY WARRANTY; without even the implied warranty of\n  - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n  - GNU Affero General Public License for more details.\n  -\n  - You should have received a copy of the GNU Affero General Public License\n  - along with this program. If not, see <http://www.gnu.org/licenses/>.\n  -\n  --\x3e\n\n<template>\n\t<NcModal class=\"card-selector\" @close=\"close\">\n\t\t<div id=\"modal-inner\" :class=\"{ 'icon-loading': loading }\">\n\t\t\t<h3>{{ title }}</h3>\n\t\t\t<NcSelect v-model=\"selectedBoard\"\n\t\t\t\t:placeholder=\"t('deck', 'Select a board')\"\n\t\t\t\t:options=\"boards\"\n\t\t\t\t:disabled=\"loading\"\n\t\t\t\tlabel=\"title\"\n\t\t\t\t@option:selected=\"fetchCardsFromBoard\">\n\t\t\t\t<template slot=\"singleLabel\" slot-scope=\"props\">\n\t\t\t\t\t<span>\n\t\t\t\t\t\t<span :style=\"{ 'backgroundColor': '#' + props.option.color }\" class=\"board-bullet\" />\n\t\t\t\t\t\t<span>{{ props.option.title }}</span>\n\t\t\t\t\t</span>\n\t\t\t\t</template>\n\t\t\t\t<template slot=\"option\" slot-scope=\"props\">\n\t\t\t\t\t<span>\n\t\t\t\t\t\t<span :style=\"{ 'backgroundColor': '#' + props.option.color }\" class=\"board-bullet\" />\n\t\t\t\t\t\t<span>{{ props.option.title }}</span>\n\t\t\t\t\t</span>\n\t\t\t\t</template>\n\t\t\t</NcSelect>\n\n\t\t\t<NcSelect v-model=\"selectedCard\"\n\t\t\t\t:placeholder=\"t('deck', 'Select a card')\"\n\t\t\t\t:options=\"cardsFromBoard\"\n\t\t\t\t:disabled=\"loading || selectedBoard === ''\"\n\t\t\t\tlabel=\"title\" />\n\n\t\t\t<button :disabled=\"!isBoardAndStackChoosen\" class=\"primary\" @click=\"select\">\n\t\t\t\t{{ action }}\n\t\t\t</button>\n\t\t\t<button @click=\"close\">\n\t\t\t\t{{ t('deck', 'Cancel') }}\n\t\t\t</button>\n\t\t</div>\n\t</NcModal>\n</template>\n\n<script>\nimport { generateUrl } from '@nextcloud/router'\nimport { NcModal, NcSelect } from '@nextcloud/vue'\nimport axios from '@nextcloud/axios'\n\nexport default {\n\tname: 'CardSelector',\n\tcomponents: {\n\t\tNcModal,\n\t\tNcSelect,\n\t},\n\tprops: {\n\t\ttitle: {\n\t\t\ttype: String,\n\t\t\tdefault: t('deck', 'Select the card to link to a project'),\n\t\t},\n\t\taction: {\n\t\t\ttype: String,\n\t\t\tdefault: t('deck', 'Link to card'),\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tboards: [],\n\t\t\tselectedBoard: '',\n\t\t\tcardsFromBoard: [],\n\t\t\tselectedCard: '',\n\t\t\tloading: true,\n\t\t}\n\t},\n\tcomputed: {\n\t\tisBoardAndStackChoosen() {\n\t\t\treturn !(this.selectedBoard === '' || this.selectedCard === '')\n\t\t},\n\t},\n\tbeforeMount() {\n\t\tthis.fetchBoards()\n\t},\n\tmethods: {\n\t\tfetchBoards() {\n\t\t\taxios.get(generateUrl('/apps/deck/boards')).then((response) => {\n\t\t\t\tthis.boards = response.data\n\t\t\t\tthis.loading = false\n\t\t\t})\n\t\t},\n\t\tasync fetchCardsFromBoard(board) {\n\t\t\ttry {\n\t\t\t\tthis.cardsFromBoard = []\n\t\t\t\tconst url = generateUrl('/apps/deck/stacks/' + board.id)\n\t\t\t\tconst response = await axios.get(url)\n\t\t\t\tresponse.data.forEach(stack => {\n\t\t\t\t\tthis.cardsFromBoard.push(...stack.cards)\n\t\t\t\t})\n\t\t\t} catch (err) {\n\t\t\t\treturn err\n\t\t\t}\n\n\t\t},\n\t\tclose() {\n\t\t\tthis.$root.$emit('close')\n\t\t},\n\t\tselect() {\n\t\t\tthis.$root.$emit('select', this.selectedCard.id)\n\n\t\t},\n\t},\n\n}\n<\/script>\n\n<style scoped>\n\t#modal-inner {\n\t\twidth: 90vw;\n\t\tmax-width: 400px;\n\t\tpadding: 20px;\n\t\theight: 200px;\n\t}\n\n\t.multiselect {\n\t\twidth: 100%;\n\t\tmargin-bottom: 10px;\n\t}\n\n\tul {\n\t\tmin-height: 100px;\n\t}\n\n\tli {\n\t\tpadding: 6px;\n\t\tborder: 1px solid transparent;\n\t}\n\n\tli:hover, li:focus {\n\t\tbackground-color: var(--color-background-dark);\n\t}\n\n\t.board-bullet {\n\t\tdisplay: inline-block;\n\t\twidth: 12px;\n\t\theight: 12px;\n\t\tborder: none;\n\t\tborder-radius: 50%;\n\t\tcursor: pointer;\n\t}\n\n\tbutton {\n\t\tfloat: right;\n\t}\n\n\t.card-selector:deep(.modal-container) {\n\t\toverflow: visible !important;\n\t}\n</style>\n"],sourceRoot:""}]);const l=s},61667:t=>{t.exports=function(t,e){return e||(e={}),t?(t=String(t.__esModule?t.default:t),/^['"].*['"]$/.test(t)&&(t=t.slice(1,-1)),e.hash&&(t+=e.hash),/["'() \t\n]|(%20)/.test(t)||e.needQuotes?'"'.concat(t.replace(/"/g,'\\"').replace(/\n/g,"\\n"),'"'):t):t}},13522:(e,n,o)=>{o.r(n),o.d(n,{default:()=>k});var a=o(11480),r=o(64882),s=o(97040);const l={name:"CardSelector",components:{NcModal:r.Jc,NcSelect:r.QG},props:{title:{type:String,default:t("deck","Select the card to link to a project")},action:{type:String,default:t("deck","Link to card")}},data:()=>({boards:[],selectedBoard:"",cardsFromBoard:[],selectedCard:"",loading:!0}),computed:{isBoardAndStackChoosen(){return!(""===this.selectedBoard||""===this.selectedCard)}},beforeMount(){this.fetchBoards()},methods:{fetchBoards(){s.ZP.get((0,a.nu)("/apps/deck/boards")).then((t=>{this.boards=t.data,this.loading=!1}))},async fetchCardsFromBoard(t){try{this.cardsFromBoard=[];const e=(0,a.nu)("/apps/deck/stacks/"+t.id);(await s.ZP.get(e)).data.forEach((t=>{this.cardsFromBoard.push(...t.cards)}))}catch(t){return t}},close(){this.$root.$emit("close")},select(){this.$root.$emit("select",this.selectedCard.id)}}};var d=o(93379),c=o.n(d),i=o(7795),p=o.n(i),A=o(90569),h=o.n(A),u=o(3565),g=o.n(u),m=o(19216),b=o.n(m),C=o(44589),N=o.n(C),v=o(78568),f={};f.styleTagTransform=N(),f.setAttributes=g(),f.insert=h().bind(null,"head"),f.domAPI=p(),f.insertStyleElement=b();c()(v.Z,f);v.Z&&v.Z.locals&&v.Z.locals;const k=(0,o(51900).Z)(l,(function(){var t=this,e=t._self._c;return e("NcModal",{staticClass:"card-selector",on:{close:t.close}},[e("div",{class:{"icon-loading":t.loading},attrs:{id:"modal-inner"}},[e("h3",[t._v(t._s(t.title))]),t._v(" "),e("NcSelect",{attrs:{placeholder:t.t("deck","Select a board"),options:t.boards,disabled:t.loading,label:"title"},on:{"option:selected":t.fetchCardsFromBoard},scopedSlots:t._u([{key:"singleLabel",fn:function(n){return[e("span",[e("span",{staticClass:"board-bullet",style:{backgroundColor:"#"+n.option.color}}),t._v(" "),e("span",[t._v(t._s(n.option.title))])])]}},{key:"option",fn:function(n){return[e("span",[e("span",{staticClass:"board-bullet",style:{backgroundColor:"#"+n.option.color}}),t._v(" "),e("span",[t._v(t._s(n.option.title))])])]}}]),model:{value:t.selectedBoard,callback:function(e){t.selectedBoard=e},expression:"selectedBoard"}}),t._v(" "),e("NcSelect",{attrs:{placeholder:t.t("deck","Select a card"),options:t.cardsFromBoard,disabled:t.loading||""===t.selectedBoard,label:"title"},model:{value:t.selectedCard,callback:function(e){t.selectedCard=e},expression:"selectedCard"}}),t._v(" "),e("button",{staticClass:"primary",attrs:{disabled:!t.isBoardAndStackChoosen},on:{click:t.select}},[t._v("\n\t\t\t"+t._s(t.action)+"\n\t\t")]),t._v(" "),e("button",{on:{click:t.close}},[t._v("\n\t\t\t"+t._s(t.t("deck","Cancel"))+"\n\t\t")])],1)])}),[],!1,null,"2a78567d",null).exports},81488:t=>{t.exports="data:image/svg+xml,%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M15.4%2016.6L10.8%2012l4.6-4.6L14%206l-6%206%206%206%201.4-1.4z%27/%3e%3c/svg%3e"},34868:t=>{t.exports="data:image/svg+xml,%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M18.4%207.4L17%206l-6%206%206%206%201.4-1.4-4.6-4.6%204.6-4.6m-6%200L11%206l-6%206%206%206%201.4-1.4L7.8%2012l4.6-4.6z%27/%3e%3c/svg%3e"},37059:t=>{t.exports="data:image/svg+xml,%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M5.6%207.4L7%206l6%206-6%206-1.4-1.4%204.6-4.6-4.6-4.6m6%200L13%206l6%206-6%206-1.4-1.4%204.6-4.6-4.6-4.6z%27/%3e%3c/svg%3e"},75701:t=>{t.exports="data:image/svg+xml,%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M8.6%2016.6l4.6-4.6-4.6-4.6L10%206l6%206-6%206-1.4-1.4z%27/%3e%3c/svg%3e"},64882:(t,e,n)=>{n.d(e,{$U:()=>M.N,FK:()=>K.N,Iw:()=>l.N,Jc:()=>et.Z,Jh:()=>Y.N,Js:()=>o.Z,O3:()=>p.N,P2:()=>T.Z,QG:()=>it.N,SL:()=>O.Z,Xn:()=>F.N,a0:()=>W.N,fg:()=>E.N,h3:()=>pt.N,ih:()=>d.Z,kC:()=>j.Z,lb:()=>tt.Z,rr:()=>A.Z,rw:()=>U.N});n(16238);var o=n(32979),a=n(43181),r=n(25381),s=n(92591),l=n(45429),d=n(36456),c=n(42591),i=n(54627),p=n(92256),A=n(58449),h=n(57063),u=n(79504),g=n(34395),m=n(27657),b=n(2047),C=n(13538),N=n(43451),v=n(79380),f=n(18561),k=n(17461),w=n(62730),x=n(95837),Z=n(6277),S=n(56778),B=n(81935),y=n(45082),_=n(88408),L=n(65982),F=n(56830),M=n(38497),E=n(84748),T=n(49306),U=n(88441),P=n(48684),G=n(58614),$=n(23770),I=n(27054),R=n(22208),Y=n(22607),J=n(15592),j=n(69052),W=n(84530),z=n(27535),H=n(95969),O=n(89364),Q=n(93138),X=n(64412),q=n(62448),K=n(5414),D=n(9879),V=n(24959),tt=n(65933),et=n(13155),nt=n(22166),ot=n(58916),at=n(93782),rt=n(88080),st=n(36610),lt=n(46265),dt=n(6671),ct=n(56451),it=(n(69121),n(80797),n(97040),n(43856)),pt=n(38310),At=(n(69183),n(96505)),ht=n(57117),ut=n(22481),gt=n(77741),mt=n(95173),bt=n(80144),Ct=n(66233),Nt=n(57404),vt=n(19577),ft=(n(52299),n(50279),n(55645),n(36214),n(90318)),kt=n(17593),wt=(n(18296),n(84722),n(76692),n(40946),n(67444));o.Z,a.N,r.Z,s.Z,l.N,d.Z,c.Z,i.Z,A.Z,h.Z,u.Z,p.N,g.N,m.Z,b.Z,C.N,N.N,v.Z,f.N,k.Z,w.Z,x.N,Z.N,S.Z,B.N,y.Z,_.N,L.Z,dt.N,F.N,M.N,E.N,T.Z,U.N,P.N,G.N,$.Z,I.N,R.N,Y.N,J.Z,j.Z,W.N,z.N,H.N,O.Z,Q.Z,X.N,q.N,K.N,D.N,V.N,tt.Z,lt.N,et.Z,nt.Z,ot.N,at.N,rt.N,st.N,dt.a,ct.N,At.N,it.N,ht.N,ut.N,gt.N,mt.N,vt.Z,pt.N,bt.N,Ct.N,Nt.N,Symbol.toStringTag,ft.X,kt.X,wt.NS,Symbol.toStringTag}}]);
//# sourceMappingURL=deck-node_modules_css-loader_dist_runtime_getUrl_js-src_CardSelector_vue-data_image_svg_xml_3csvg_-2d9259.js.map?v=f6e925042f55f8296c5d