<?php
/**
 * @copyright Copyright (c) 2017 Julius Härtl <jus@bitgrid.net>
 *
 * @author Julius Härtl <jus@bitgrid.net>
 *
 * @license GNU AGPL version 3 or any later version
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as
 *  published by the Free Software Foundation, either version 3 of the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */

namespace OCA\Deck\Db;

use JsonSerializable;

class Assignment extends RelationalEntity implements JsonSerializable {
	public $id;
	protected $participant;
	protected $cardId;
	protected $type;

	public const TYPE_USER = Acl::PERMISSION_TYPE_USER;
	public const TYPE_GROUP = Acl::PERMISSION_TYPE_GROUP;
	public const TYPE_CIRCLE = Acl::PERMISSION_TYPE_CIRCLE;

	public function __construct() {
		$this->addType('id', 'integer');
		$this->addType('cardId', 'integer');
		$this->addType('type', 'integer');
		$this->addResolvable('participant');
	}

	public function getTypeString(): string {
		switch ($this->getType()) {
			case self::TYPE_USER:
				return 'user';
			case self::TYPE_GROUP:
				return 'group';
			case self::TYPE_CIRCLE:
				return 'circle';
		}

		return 'unknown';
	}
}
