/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.utils;

import io.swagger.v3.oas.models.Components;
import java.util.Map;
import org.openapitools.openapidiff.core.utils.RefType;

public class RefPointer<T> {
    public static final String BASE_REF = "#/components/";
    private final RefType refType;

    public RefPointer(RefType refType) {
        this.refType = refType;
    }

    public T resolveRef(Components components, T t, String ref) {
        if (ref != null) {
            String refName = this.getRefName(ref);
            T result = this.getMap(components).get(refName);
            if (result == null) {
                throw new IllegalArgumentException(String.format("ref '%s' doesn't exist.", ref));
            }
            return result;
        }
        return t;
    }

    private Map<String, T> getMap(Components components) {
        switch (this.refType) {
            case REQUEST_BODIES: {
                return components.getRequestBodies();
            }
            case RESPONSES: {
                return components.getResponses();
            }
            case PARAMETERS: {
                return components.getParameters();
            }
            case SCHEMAS: {
                return components.getSchemas();
            }
            case HEADERS: {
                return components.getHeaders();
            }
            case SECURITY_SCHEMES: {
                return components.getSecuritySchemes();
            }
        }
        throw new IllegalArgumentException("Not mapped for refType: " + (Object)((Object)this.refType));
    }

    private String getBaseRefForType(String type) {
        return String.format("%s%s/", BASE_REF, type);
    }

    public String getRefName(String ref) {
        if (ref == null) {
            return null;
        }
        if (this.refType == RefType.SECURITY_SCHEMES) {
            return ref;
        }
        String baseRef = this.getBaseRefForType(this.refType.getName());
        if (!ref.startsWith(baseRef)) {
            throw new IllegalArgumentException("Invalid ref: " + ref);
        }
        return ref.substring(baseRef.length());
    }
}

