/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.common.Nullable;
import org.opensearch.common.ValidationException;
import org.opensearch.common.regex.Regex;
import org.opensearch.core.common.Strings;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;

public final class RemoveByPatternProcessor
extends AbstractProcessor {
    public static final String TYPE = "remove_by_pattern";
    private final List<String> fieldPatterns;
    private final List<String> excludeFieldPatterns;

    RemoveByPatternProcessor(String tag, String description, @Nullable List<String> fieldPatterns, @Nullable List<String> excludeFieldPatterns) {
        super(tag, description);
        if (fieldPatterns != null && excludeFieldPatterns != null || fieldPatterns == null && excludeFieldPatterns == null) {
            throw new IllegalArgumentException("either fieldPatterns and excludeFieldPatterns must be set");
        }
        if (fieldPatterns == null) {
            this.fieldPatterns = null;
            this.excludeFieldPatterns = new ArrayList<String>(excludeFieldPatterns);
        } else {
            this.fieldPatterns = new ArrayList<String>(fieldPatterns);
            this.excludeFieldPatterns = null;
        }
    }

    public List<String> getFieldPatterns() {
        return this.fieldPatterns;
    }

    public List<String> getExcludeFieldPatterns() {
        return this.excludeFieldPatterns;
    }

    public IngestDocument execute(IngestDocument document) {
        HashSet existingFields = new HashSet(document.getSourceAndMetadata().keySet());
        Set metadataFields = document.getMetadata().keySet().stream().map(IngestDocument.Metadata::getFieldName).collect(Collectors.toSet());
        if (this.fieldPatterns != null && !this.fieldPatterns.isEmpty()) {
            existingFields.forEach(field -> {
                boolean matched;
                if (!metadataFields.contains(field) && (matched = this.fieldPatterns.stream().anyMatch(pattern -> Regex.simpleMatch((String)pattern, (String)field)))) {
                    document.removeField(field);
                }
            });
        }
        if (this.excludeFieldPatterns != null && !this.excludeFieldPatterns.isEmpty()) {
            existingFields.forEach(field -> {
                boolean matched;
                if (!metadataFields.contains(field) && !(matched = this.excludeFieldPatterns.stream().anyMatch(pattern -> Regex.simpleMatch((String)pattern, (String)field)))) {
                    document.removeField(field);
                }
            });
        }
        return document;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        public RemoveByPatternProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            ArrayList<String> fieldPatterns = new ArrayList<String>();
            ArrayList<String> excludeFieldPatterns = new ArrayList<String>();
            Object fieldPattern = ConfigurationUtils.readOptionalObject(config, (String)"field_pattern");
            Object excludeFieldPattern = ConfigurationUtils.readOptionalObject(config, (String)"exclude_field_pattern");
            if (fieldPattern == null && excludeFieldPattern == null || fieldPattern != null && excludeFieldPattern != null) {
                throw ConfigurationUtils.newConfigurationException((String)RemoveByPatternProcessor.TYPE, (String)processorTag, (String)"field_pattern", (String)"either field_pattern or exclude_field_pattern must be set");
            }
            if (fieldPattern != null) {
                if (fieldPattern instanceof List) {
                    List fieldPatternList = (List)fieldPattern;
                    fieldPatterns.addAll(fieldPatternList);
                } else {
                    fieldPatterns.add((String)fieldPattern);
                }
                this.validateFieldPatterns(processorTag, fieldPatterns, "field_pattern");
                return new RemoveByPatternProcessor(processorTag, description, fieldPatterns, null);
            }
            if (excludeFieldPattern instanceof List) {
                List excludeFieldPatternList = (List)excludeFieldPattern;
                excludeFieldPatterns.addAll(excludeFieldPatternList);
            } else {
                excludeFieldPatterns.add((String)excludeFieldPattern);
            }
            this.validateFieldPatterns(processorTag, excludeFieldPatterns, "exclude_field_pattern");
            return new RemoveByPatternProcessor(processorTag, description, null, excludeFieldPatterns);
        }

        private void validateFieldPatterns(String processorTag, List<String> patterns, String patternKey) {
            ArrayList<CallSite> validationErrors = new ArrayList<CallSite>();
            for (String fieldPattern : patterns) {
                if (fieldPattern.contains("#")) {
                    validationErrors.add((CallSite)((Object)(patternKey + " [" + fieldPattern + "] must not contain a '#'")));
                }
                if (fieldPattern.contains(":")) {
                    validationErrors.add((CallSite)((Object)(patternKey + " [" + fieldPattern + "] must not contain a ':'")));
                }
                if (fieldPattern.startsWith("_")) {
                    validationErrors.add((CallSite)((Object)(patternKey + " [" + fieldPattern + "] must not start with '_'")));
                }
                if (Strings.validFileNameExcludingAstrix((String)fieldPattern)) continue;
                validationErrors.add((CallSite)((Object)(patternKey + " [" + fieldPattern + "] must not contain the following characters " + Strings.INVALID_FILENAME_CHARS)));
            }
            if (validationErrors.size() > 0) {
                ValidationException validationException = new ValidationException();
                validationException.addValidationErrors(validationErrors);
                throw ConfigurationUtils.newConfigurationException((String)RemoveByPatternProcessor.TYPE, (String)processorTag, (String)patternKey, (String)validationException.getMessage());
            }
        }
    }
}

