/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import org.apache.lucene.search.BooleanClause;
import org.opensearch.action.search.SearchQueryCounters;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilderVisitor;

final class SearchQueryCategorizingVisitor
implements QueryBuilderVisitor {
    private final int level;
    private final SearchQueryCounters searchQueryCounters;

    public SearchQueryCategorizingVisitor(SearchQueryCounters searchQueryCounters) {
        this(searchQueryCounters, 0);
    }

    private SearchQueryCategorizingVisitor(SearchQueryCounters counters, int level) {
        this.searchQueryCounters = counters;
        this.level = level;
    }

    @Override
    public void accept(QueryBuilder qb) {
        this.searchQueryCounters.incrementCounter(qb, this.level);
    }

    @Override
    public QueryBuilderVisitor getChildVisitor(BooleanClause.Occur occur) {
        return new SearchQueryCategorizingVisitor(this.searchQueryCounters, this.level + 1);
    }
}

