/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.bootstrap;

import java.io.IOException;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.AccessMode;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.security.Permissions;
import java.security.Policy;
import java.security.URIParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.bootstrap.FilePermissionUtils;
import org.opensearch.bootstrap.JarHell;
import org.opensearch.bootstrap.OpenSearchPolicy;
import org.opensearch.bootstrap.OpenSearchUncaughtExceptionHandler;
import org.opensearch.cli.Command;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.io.PathUtils;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.http.HttpTransportSettings;
import org.opensearch.plugins.PluginsService;
import org.opensearch.secure_sm.SecureSM;
import org.opensearch.transport.TcpTransport;

final class Security {
    private static final Pattern CODEBASE_JAR_WITH_CLASSIFIER = Pattern.compile("^(.+)-\\d+\\.\\d+[^-]*.*?[-]?([^-]+)?\\.jar$");

    private Security() {
    }

    static void configure(Environment environment, boolean filterBadDefaults) throws IOException, NoSuchAlgorithmException {
        Map<String, URL> codebases = Security.getCodebaseJarMap(JarHell.parseClassPath());
        Policy.setPolicy(new OpenSearchPolicy(codebases, Security.createPermissions(environment), Security.getPluginPermissions(environment), filterBadDefaults, Security.createRecursiveDataPathPermission(environment)));
        String[] classesThatCanExit = new String[]{OpenSearchUncaughtExceptionHandler.PrivilegedHaltAction.class.getName().replace("$", "\\$"), Command.class.getName()};
        System.setSecurityManager((SecurityManager)new SecureSM(classesThatCanExit));
        Security.selfTest();
    }

    @SuppressForbidden(reason="find URL path")
    static Map<String, URL> getCodebaseJarMap(Set<URL> urls) {
        LinkedHashMap<String, URL> codebases = new LinkedHashMap<String, URL>();
        for (URL url : urls) {
            try {
                String fileName = PathUtils.get((URI)url.toURI()).getFileName().toString();
                if (!fileName.endsWith(".jar")) continue;
                codebases.put(fileName, url);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return codebases;
    }

    @SuppressForbidden(reason="proper use of URL")
    static Map<String, Policy> getPluginPermissions(Environment environment) throws IOException, NoSuchAlgorithmException {
        HashMap<String, Policy> map = new HashMap<String, Policy>();
        LinkedHashSet<Path> pluginsAndModules = new LinkedHashSet<Path>(PluginsService.findPluginDirs(environment.pluginsFile()));
        pluginsAndModules.addAll(PluginsService.findPluginDirs(environment.modulesFile()));
        for (Path plugin : pluginsAndModules) {
            Path policyFile = plugin.resolve("plugin-security.policy");
            if (!Files.exists(policyFile, new LinkOption[0])) continue;
            LinkedHashSet<URL> codebases = new LinkedHashSet<URL>();
            try (DirectoryStream<Path> jarStream = Files.newDirectoryStream(plugin, "*.jar");){
                for (Path jar : jarStream) {
                    URL url = jar.toRealPath(new LinkOption[0]).toUri().toURL();
                    if (codebases.add(url)) continue;
                    throw new IllegalStateException("duplicate module/plugin: " + url);
                }
            }
            Policy policy = Security.readPolicy(policyFile.toUri().toURL(), Security.getCodebaseJarMap(codebases));
            for (URL url : codebases) {
                if (map.put(url.getFile(), policy) == null) continue;
                throw new IllegalStateException("per-plugin permissions already granted for jar file: " + url);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static Policy readPolicy(URL policyFile, Map<String, URL> codebases) {
        Policy policy;
        ArrayList<String> propertiesSet = new ArrayList<String>();
        try {
            String aliasProperty;
            String property;
            HashMap<Map.Entry<String, URL>, String> jarsWithPossibleClassifiers = new HashMap<Map.Entry<String, URL>, String>();
            for (Map.Entry<String, URL> entry : codebases.entrySet()) {
                String name = entry.getKey();
                URL url = entry.getValue();
                Matcher matcher = CODEBASE_JAR_WITH_CLASSIFIER.matcher(name);
                if (matcher.matches() && matcher.group(2) != null) {
                    jarsWithPossibleClassifiers.put(entry, matcher.group(2));
                    continue;
                }
                property = "codebase." + name;
                aliasProperty = "codebase." + name.replaceFirst("-\\d+\\.\\d+.*\\.jar", "");
                Security.addCodebaseToSystemProperties(propertiesSet, url, property, aliasProperty);
            }
            for (Map.Entry<String, URL> entry : jarsWithPossibleClassifiers.entrySet()) {
                Map.Entry codebase = (Map.Entry)((Object)entry.getKey());
                String name = (String)codebase.getKey();
                URL url = (URL)codebase.getValue();
                property = "codebase." + name;
                aliasProperty = "codebase." + name.replaceFirst("-\\d+\\.\\d+.*\\.jar", "");
                if (System.getProperties().containsKey(aliasProperty)) {
                    aliasProperty = aliasProperty + "@" + (String)((Object)entry.getValue());
                }
                Security.addCodebaseToSystemProperties(propertiesSet, url, property, aliasProperty);
            }
            policy = Policy.getInstance("JavaPolicy", new URIParameter(policyFile.toURI()));
        }
        catch (Throwable throwable) {
            try {
                for (String property : propertiesSet) {
                    System.clearProperty(property);
                }
                throw throwable;
            }
            catch (URISyntaxException | NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("unable to parse policy file `" + policyFile + "`", e);
            }
        }
        for (String property : propertiesSet) {
            System.clearProperty(property);
        }
        return policy;
    }

    @SuppressForbidden(reason="accesses System properties to configure codebases")
    private static void addCodebaseToSystemProperties(List<String> propertiesSet, URL url, String property, String aliasProperty) {
        String previous;
        if (!aliasProperty.equals(property)) {
            propertiesSet.add(aliasProperty);
            previous = System.setProperty(aliasProperty, url.toString());
            if (previous != null) {
                throw new IllegalStateException("codebase property already set: " + aliasProperty + " -> " + previous + ", cannot set to " + url.toString());
            }
        }
        propertiesSet.add(property);
        previous = System.setProperty(property, url.toString());
        if (previous != null) {
            throw new IllegalStateException("codebase property already set: " + property + " -> " + previous + ", cannot set to " + url.toString());
        }
    }

    static Permissions createPermissions(Environment environment) throws IOException {
        Permissions policy = new Permissions();
        Security.addClasspathPermissions(policy);
        Security.addFilePermissions(policy, environment);
        Security.addBindPermissions(policy, environment.settings());
        return policy;
    }

    private static Permissions createRecursiveDataPathPermission(Environment environment) throws IOException {
        Permissions policy = new Permissions();
        for (Path path : environment.dataFiles()) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_DATA_SETTING.getKey(), path, "read,readlink,write,delete", true);
        }
        return policy;
    }

    @SuppressForbidden(reason="accesses fully qualified URLs to configure security")
    static void addClasspathPermissions(Permissions policy) throws IOException {
        for (URL url : JarHell.parseClassPath()) {
            Path path;
            try {
                path = PathUtils.get((URI)url.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                FilePermissionUtils.addDirectoryPath(policy, "class.path", path, "read,readlink", false);
                continue;
            }
            FilePermissionUtils.addSingleFilePath(policy, path, "read,readlink");
        }
    }

    static void addFilePermissions(Permissions policy, Environment environment) throws IOException {
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.binFile(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.libFile(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.modulesFile(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_HOME_SETTING.getKey(), environment.pluginsFile(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, "path.conf'", environment.configFile(), "read,readlink", false);
        FilePermissionUtils.addDirectoryPath(policy, "java.io.tmpdir", environment.tmpFile(), "read,readlink,write,delete", false);
        FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_LOGS_SETTING.getKey(), environment.logsFile(), "read,readlink,write,delete", false);
        if (environment.sharedDataFile() != null) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_SHARED_DATA_SETTING.getKey(), environment.sharedDataFile(), "read,readlink,write,delete", false);
        }
        HashSet<Path> dataFilesPaths = new HashSet<Path>();
        for (Path path : environment.dataFiles()) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_DATA_SETTING.getKey(), path, "read,readlink,write,delete", false);
            try {
                Path realPath = path.toRealPath(new LinkOption[0]);
                if (dataFilesPaths.add(realPath)) continue;
                throw new IllegalStateException("path [" + realPath + "] is duplicated by [" + path + "]");
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to access [" + path + "]", e);
            }
        }
        for (Path path : environment.repoFiles()) {
            FilePermissionUtils.addDirectoryPath(policy, Environment.PATH_REPO_SETTING.getKey(), path, "read,readlink,write,delete", false);
        }
        if (environment.pidFile() != null) {
            FilePermissionUtils.addSingleFilePath(policy, environment.pidFile(), "delete");
        }
    }

    private static void addBindPermissions(Permissions policy, Settings settings) {
        Security.addSocketPermissionForHttp(policy, settings);
        Security.addSocketPermissionForTransportProfiles(policy, settings);
    }

    private static void addSocketPermissionForHttp(Permissions policy, Settings settings) {
        String httpRange = HttpTransportSettings.SETTING_HTTP_PORT.get(settings).getPortRangeString();
        Security.addSocketPermissionForPortRange(policy, httpRange);
    }

    private static void addSocketPermissionForTransportProfiles(Permissions policy, Settings settings) {
        Set<TcpTransport.ProfileSettings> profiles = TcpTransport.getProfileSettings(settings);
        HashSet<String> uniquePortRanges = new HashSet<String>();
        for (TcpTransport.ProfileSettings profile : profiles) {
            if (!uniquePortRanges.add(profile.portOrRange)) continue;
            Security.addSocketPermissionForPortRange(policy, profile.portOrRange);
        }
    }

    private static void addSocketPermissionForPortRange(Permissions policy, String portRange) {
        policy.add(new SocketPermission("*:" + portRange, "listen,resolve"));
    }

    static void ensureDirectoryExists(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            path.getFileSystem().provider().checkAccess(path.toRealPath(new LinkOption[0]), AccessMode.READ);
        } else {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                NotDirectoryException e2 = new NotDirectoryException(path.toString());
                e2.addSuppressed(e);
                throw e2;
            }
        }
    }

    @SuppressForbidden(reason="accesses jvm default tempdir as a self-test")
    static void selfTest() throws IOException {
        try {
            Path p = Files.createTempFile(null, null, new FileAttribute[0]);
            try {
                Files.delete(p);
            }
            catch (IOException iOException) {}
        }
        catch (SecurityException problem) {
            throw new SecurityException("Security misconfiguration: cannot access java.io.tmpdir", problem);
        }
    }
}

