/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.extensions.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.OpenSearchParseException;
import org.opensearch.Version;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.http.HttpRequest;
import org.opensearch.rest.RestRequest;
import org.opensearch.transport.TransportRequest;

public class ExtensionRestRequest
extends TransportRequest {
    private RestRequest.Method method;
    private String uri;
    private String path;
    private Map<String, String> params;
    private Map<String, List<String>> headers;
    private MediaType mediaType = null;
    private BytesReference content;
    private String principalIdentifierToken;
    private HttpRequest.HttpVersion httpVersion;
    private final Set<String> consumedParams = new HashSet<String>();
    private boolean contentConsumed = false;

    public ExtensionRestRequest(RestRequest.Method method, String uri, String path, Map<String, String> params, Map<String, List<String>> headers, MediaType mediaType, BytesReference content, String principalIdentifier, HttpRequest.HttpVersion httpVersion) {
        this.method = method;
        this.uri = uri;
        this.path = path;
        this.params = params;
        this.headers = headers;
        this.mediaType = mediaType;
        this.content = content;
        this.principalIdentifierToken = Objects.requireNonNull(principalIdentifier);
        this.httpVersion = httpVersion;
    }

    public ExtensionRestRequest(StreamInput in) throws IOException {
        super(in);
        this.method = (RestRequest.Method)in.readEnum(RestRequest.Method.class);
        this.uri = in.readString();
        this.path = in.readString();
        this.params = in.readMap(StreamInput::readString, StreamInput::readString);
        this.headers = in.readMap(StreamInput::readString, StreamInput::readStringList);
        if (in.readBoolean()) {
            this.mediaType = in.getVersion().onOrAfter(Version.V_2_10_0) ? in.readMediaType() : (MediaType)in.readEnum(XContentType.class);
        }
        this.content = in.readBytesReference();
        this.principalIdentifierToken = in.readString();
        this.httpVersion = (HttpRequest.HttpVersion)in.readEnum(HttpRequest.HttpVersion.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum((Enum)this.method);
        out.writeString(this.uri);
        out.writeString(this.path);
        out.writeMap(this.params, StreamOutput::writeString, StreamOutput::writeString);
        out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeStringCollection);
        out.writeBoolean(this.mediaType != null);
        if (this.mediaType != null) {
            if (out.getVersion().onOrAfter(Version.V_2_10_0)) {
                this.mediaType.writeTo(out);
            } else {
                out.writeEnum((Enum)((XContentType)this.mediaType));
            }
        }
        out.writeBytesReference(this.content);
        out.writeString(this.principalIdentifierToken);
        out.writeEnum((Enum)this.httpVersion);
    }

    public RestRequest.Method method() {
        return this.method;
    }

    public String uri() {
        return this.uri;
    }

    public String path() {
        return this.path;
    }

    public Map<String, String> params() {
        return this.params;
    }

    public boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    public String param(String key) {
        this.consumedParams.add(key);
        return this.params.get(key);
    }

    public String param(String key, String defaultValue) {
        this.consumedParams.add(key);
        return this.params.getOrDefault(key, defaultValue);
    }

    public long paramAsLong(String key, long defaultValue) {
        String value = this.param(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unable to parse param '" + key + "' value '" + value + "' to a long.", e);
        }
    }

    public List<String> consumedParams() {
        return new ArrayList<String>(this.consumedParams);
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public MediaType getXContentType() {
        return this.mediaType;
    }

    public BytesReference content() {
        this.contentConsumed = true;
        return this.content;
    }

    public boolean hasContent() {
        return this.content.length() > 0;
    }

    public boolean isContentConsumed() {
        return this.contentConsumed;
    }

    public final XContentParser contentParser(NamedXContentRegistry xContentRegistry) throws IOException {
        if (!this.hasContent() || this.getXContentType() == null) {
            throw new OpenSearchParseException("There is no request body or the ContentType is invalid.", new Object[0]);
        }
        if (this.getRequestIssuerIdentity() == null) {
            throw new OpenSearchParseException("There is no request body or the requester identity is invalid.", new Object[0]);
        }
        return this.getXContentType().xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)this.content.streamInput());
    }

    public String getRequestIssuerIdentity() {
        return this.principalIdentifierToken;
    }

    public HttpRequest.HttpVersion protocolVersion() {
        return this.httpVersion;
    }

    public String toString() {
        return "ExtensionRestRequest{method=" + this.method + ", uri=" + this.uri + ", path=" + this.path + ", params=" + this.params + ", headers=" + this.headers.toString() + ", xContentType=" + this.mediaType + ", contentLength=" + this.content.length() + ", requester=" + this.principalIdentifierToken + ", httpVersion=" + this.httpVersion + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionRestRequest that = (ExtensionRestRequest)obj;
        return Objects.equals((Object)this.method, (Object)that.method) && Objects.equals(this.uri, that.uri) && Objects.equals(this.path, that.path) && Objects.equals(this.params, that.params) && Objects.equals(this.headers, that.headers) && Objects.equals(this.mediaType, that.mediaType) && Objects.equals(this.content, that.content) && Objects.equals(this.principalIdentifierToken, that.principalIdentifierToken) && Objects.equals((Object)this.httpVersion, (Object)that.httpVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.uri, this.path, this.params, this.headers, this.mediaType, this.content, this.principalIdentifierToken, this.httpVersion});
    }
}

