/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import java.io.IOException;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.indices.replication.SegmentReplicationState;

@PublicApi(since="2.7.0")
public class SegmentReplicationShardStats
implements Writeable,
ToXContentFragment {
    private final String allocationId;
    private final long checkpointsBehindCount;
    private final long bytesBehindCount;
    private final long currentReplicationLagMillis;
    private final long currentReplicationTimeMillis;
    private final long lastCompletedReplicationTimeMillis;
    @Nullable
    private SegmentReplicationState currentReplicationState;

    public SegmentReplicationShardStats(String allocationId, long checkpointsBehindCount, long bytesBehindCount, long currentReplicationTimeMillis, long currentReplicationLagMillis, long lastCompletedReplicationTime) {
        this.allocationId = allocationId;
        this.checkpointsBehindCount = checkpointsBehindCount;
        this.bytesBehindCount = bytesBehindCount;
        this.currentReplicationTimeMillis = currentReplicationTimeMillis;
        this.currentReplicationLagMillis = currentReplicationLagMillis;
        this.lastCompletedReplicationTimeMillis = lastCompletedReplicationTime;
    }

    public SegmentReplicationShardStats(StreamInput in) throws IOException {
        this.allocationId = in.readString();
        this.checkpointsBehindCount = in.readVLong();
        this.bytesBehindCount = in.readVLong();
        this.currentReplicationTimeMillis = in.readVLong();
        this.lastCompletedReplicationTimeMillis = in.readVLong();
        this.currentReplicationLagMillis = in.readVLong();
    }

    public String getAllocationId() {
        return this.allocationId;
    }

    public long getCheckpointsBehindCount() {
        return this.checkpointsBehindCount;
    }

    public long getBytesBehindCount() {
        return this.bytesBehindCount;
    }

    public long getCurrentReplicationTimeMillis() {
        return this.currentReplicationTimeMillis;
    }

    public long getCurrentReplicationLagMillis() {
        return this.currentReplicationLagMillis;
    }

    public long getLastCompletedReplicationTimeMillis() {
        return this.lastCompletedReplicationTimeMillis;
    }

    public void setCurrentReplicationState(SegmentReplicationState currentReplicationState) {
        this.currentReplicationState = currentReplicationState;
    }

    @Nullable
    public SegmentReplicationState getCurrentReplicationState() {
        return this.currentReplicationState;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("allocation_id", this.allocationId);
        builder.field("checkpoints_behind", this.checkpointsBehindCount);
        builder.field("bytes_behind", new ByteSizeValue(this.bytesBehindCount).toString());
        builder.field("current_replication_time", (Object)new TimeValue(this.currentReplicationTimeMillis));
        builder.field("current_replication_lag", (Object)new TimeValue(this.currentReplicationLagMillis));
        builder.field("last_completed_replication_time", (Object)new TimeValue(this.lastCompletedReplicationTimeMillis));
        if (this.currentReplicationState != null) {
            builder.startObject();
            this.currentReplicationState.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.allocationId);
        out.writeVLong(this.checkpointsBehindCount);
        out.writeVLong(this.bytesBehindCount);
        out.writeVLong(this.currentReplicationTimeMillis);
        out.writeVLong(this.lastCompletedReplicationTimeMillis);
        out.writeVLong(this.currentReplicationLagMillis);
    }

    public String toString() {
        return "SegmentReplicationShardStats{allocationId=" + this.allocationId + ", checkpointsBehindCount=" + this.checkpointsBehindCount + ", bytesBehindCount=" + this.bytesBehindCount + ", currentReplicationLagMillis=" + this.currentReplicationLagMillis + ", currentReplicationTimeMillis=" + this.currentReplicationTimeMillis + ", lastCompletedReplicationTimeMillis=" + this.lastCompletedReplicationTimeMillis + ", currentReplicationState=" + this.currentReplicationState + "}";
    }
}

