/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.regex.Regex;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.plain.ConstantIndexFieldData;
import org.opensearch.index.mapper.ConstantFieldType;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.lookup.SearchLookup;

@PublicApi(since="2.14.0")
public class ConstantKeywordFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "constant_keyword";
    private static final String valuePropertyName = "value";
    private final String value;

    private static ConstantKeywordFieldMapper toType(FieldMapper in) {
        return (ConstantKeywordFieldMapper)in;
    }

    protected ConstantKeywordFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.value = builder.value.getValue();
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.value).init(this);
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        String value = context.externalValueSet() ? context.externalValue().toString() : context.parser().textOrNull();
        if (value == null) {
            throw new IllegalArgumentException("constant keyword field [" + this.name() + "] must have a value");
        }
        if (!value.equals(this.fieldType().value)) {
            throw new IllegalArgumentException("constant keyword field [" + this.name() + "] must have a value of [" + this.value + "]");
        }
    }

    @Override
    public ConstantKeywordFieldType fieldType() {
        return (ConstantKeywordFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @PublicApi(since="2.14.0")
    protected static final class ConstantKeywordFieldType
    extends ConstantFieldType {
        protected final String value;

        public ConstantKeywordFieldType(String name, String value) {
            super(name, Collections.emptyMap());
            this.value = value;
        }

        @Override
        public String typeName() {
            return ConstantKeywordFieldMapper.CONTENT_TYPE;
        }

        @Override
        protected boolean matches(String pattern, boolean caseInsensitive, QueryShardContext context) {
            return Regex.simpleMatch(pattern, this.value, caseInsensitive);
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new MatchAllDocsQuery();
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            return new ConstantIndexFieldData.Builder(fullyQualifiedIndexName, this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context){

                @Override
                protected Object parseSourceValue(Object value) {
                    String keywordValue = value.toString();
                    return Collections.singletonList(keywordValue);
                }
            };
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<String> value;

        public Builder(String name, String value) {
            super(name);
            this.value = ParametrizedFieldMapper.Parameter.stringParam(ConstantKeywordFieldMapper.valuePropertyName, false, m -> ConstantKeywordFieldMapper.toType((FieldMapper)m).value, value);
        }

        @Override
        public List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.value);
        }

        @Override
        public ConstantKeywordFieldMapper build(Mapper.BuilderContext context) {
            return new ConstantKeywordFieldMapper(this.name, new ConstantKeywordFieldType(this.buildFullName(context), this.value.getValue()), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            if (!node.containsKey(ConstantKeywordFieldMapper.valuePropertyName)) {
                throw new OpenSearchParseException("Field [" + name + "] is missing required parameter [value]", new Object[0]);
            }
            Object value = node.remove(ConstantKeywordFieldMapper.valuePropertyName);
            if (!(value instanceof String)) {
                throw new OpenSearchParseException("Field [" + name + "] is expected to be a string value", new Object[0]);
            }
            return new Builder(name, (String)value);
        }
    }
}

