/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MetadataFieldMapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.search.lookup.SearchLookup;

@PublicApi(since="1.0.0")
public class SourceFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_source";
    public static final String RECOVERY_SOURCE_NAME = "_recovery_source";
    public static final String CONTENT_TYPE = "_source";
    private final Function<Map<String, ?>, Map<String, Object>> filter;
    private final Function<Map<String, ?>, Map<String, Object>> recoverySourceFilter;
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> new SourceFieldMapper(), c -> new Builder());
    private final boolean enabled;
    private final boolean recoverySourceEnabled;
    private final boolean complete;
    private final String[] includes;
    private final String[] excludes;
    private final String[] recoverySourceIncludes;
    private final String[] recoverySourceExcludes;

    private static SourceFieldMapper toType(FieldMapper in) {
        return (SourceFieldMapper)in;
    }

    private SourceFieldMapper() {
        this(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY, true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
    }

    private SourceFieldMapper(boolean enabled, String[] includes, String[] excludes, boolean recoverySourceEnabled, String[] recoverySourceIncludes, String[] recoverySourceExcludes) {
        super(new SourceFieldType(enabled));
        this.enabled = enabled;
        this.includes = includes;
        this.excludes = excludes;
        boolean filtered = !CollectionUtils.isEmpty((Object[])includes) || !CollectionUtils.isEmpty((Object[])excludes);
        this.filter = enabled && filtered ? XContentMapValues.filter(includes, excludes) : null;
        this.complete = enabled && CollectionUtils.isEmpty((Object[])includes) && CollectionUtils.isEmpty((Object[])excludes);
        this.recoverySourceEnabled = recoverySourceEnabled;
        this.recoverySourceIncludes = recoverySourceIncludes;
        this.recoverySourceExcludes = recoverySourceExcludes;
        boolean recoverySourcefiltered = !CollectionUtils.isEmpty((Object[])recoverySourceIncludes) || !CollectionUtils.isEmpty((Object[])recoverySourceExcludes);
        this.recoverySourceFilter = this.recoverySourceEnabled && recoverySourcefiltered ? XContentMapValues.filter(recoverySourceIncludes, recoverySourceExcludes) : null;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        MediaType contentType;
        BytesReference originalSource = context.sourceToParse().source();
        BytesReference adaptedSource = this.applyFilters(originalSource, contentType = context.sourceToParse().getMediaType());
        if (adaptedSource != null) {
            BytesRef ref = adaptedSource.toBytesRef();
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), ref.bytes, ref.offset, ref.length));
        }
        if (this.recoverySourceEnabled && originalSource != null && adaptedSource != originalSource) {
            BytesReference adaptedRecoverySource = this.applyFilters(originalSource, contentType, this.recoverySourceEnabled, this.recoverySourceFilter);
            BytesRef ref = adaptedRecoverySource.toBytesRef();
            context.doc().add((IndexableField)new StoredField(RECOVERY_SOURCE_NAME, ref.bytes, ref.offset, ref.length));
            context.doc().add((IndexableField)new NumericDocValuesField(RECOVERY_SOURCE_NAME, 1L));
        }
    }

    @Nullable
    public BytesReference applyFilters(@Nullable BytesReference originalSource, @Nullable MediaType contentType) throws IOException {
        return this.applyFilters(originalSource, contentType, this.enabled, this.filter);
    }

    @Nullable
    private BytesReference applyFilters(@Nullable BytesReference originalSource, @Nullable MediaType contentType, boolean isProvidedSourceEnabled, @Nullable Function<Map<String, ?>, Map<String, Object>> filters) throws IOException {
        if (isProvidedSourceEnabled && originalSource != null) {
            if (filters != null) {
                Tuple<? extends MediaType, Map<String, Object>> mapTuple = XContentHelper.convertToMap(originalSource, true, contentType);
                Map<String, Object> filteredSource = filters.apply((Map)mapTuple.v2());
                BytesStreamOutput bStream = new BytesStreamOutput();
                MediaType actualContentType = (MediaType)mapTuple.v1();
                XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)actualContentType, (OutputStream)((Object)bStream)).map(filteredSource);
                builder.close();
                return bStream.bytes();
            }
            return originalSource;
        }
        return null;
    }

    @Override
    protected String contentType() {
        return "_source";
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder().init(this);
    }

    static final class SourceFieldType
    extends MappedFieldType {
        private SourceFieldType(boolean enabled) {
            super("_source", false, enabled, false, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_source";
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup lookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new QueryShardException(context, "The _source field is not searchable", new Object[0]);
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "The _source field is not searchable", new Object[0]);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> enabled = ParametrizedFieldMapper.Parameter.boolParam("enabled", false, m -> SourceFieldMapper.toType((FieldMapper)m).enabled, true);
        private final ParametrizedFieldMapper.Parameter<List<String>> includes = ParametrizedFieldMapper.Parameter.stringArrayParam("includes", false, m -> Arrays.asList(SourceFieldMapper.toType((FieldMapper)m).includes), Collections.emptyList());
        private final ParametrizedFieldMapper.Parameter<List<String>> excludes = ParametrizedFieldMapper.Parameter.stringArrayParam("excludes", false, m -> Arrays.asList(SourceFieldMapper.toType((FieldMapper)m).excludes), Collections.emptyList());
        private final ParametrizedFieldMapper.Parameter<Boolean> recoverySourceEnabled = ParametrizedFieldMapper.Parameter.boolParam("recovery_source_enabled", false, m -> SourceFieldMapper.toType((FieldMapper)m).recoverySourceEnabled, true);
        private final ParametrizedFieldMapper.Parameter<List<String>> recoverySourceIncludes = ParametrizedFieldMapper.Parameter.stringArrayParam("recovery_source_includes", false, m -> Arrays.asList(SourceFieldMapper.toType((FieldMapper)m).recoverySourceIncludes), Collections.emptyList());
        private final ParametrizedFieldMapper.Parameter<List<String>> recoverySourceExcludes = ParametrizedFieldMapper.Parameter.stringArrayParam("recovery_source_excludes", false, m -> Arrays.asList(SourceFieldMapper.toType((FieldMapper)m).recoverySourceExcludes), Collections.emptyList());

        public Builder() {
            super("_source");
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.enabled, this.includes, this.excludes, this.recoverySourceEnabled, this.recoverySourceIncludes, this.recoverySourceExcludes);
        }

        @Override
        public SourceFieldMapper build(Mapper.BuilderContext context) {
            return new SourceFieldMapper(this.enabled.getValue(), this.includes.getValue().toArray(new String[0]), this.excludes.getValue().toArray(new String[0]), this.recoverySourceEnabled.getValue(), this.recoverySourceIncludes.getValue().toArray(new String[0]), this.recoverySourceExcludes.getValue().toArray(new String[0]));
        }
    }

    public static class Defaults {
        public static final String NAME = "_source";
        public static final boolean ENABLED = true;
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

