/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.Version;
import org.opensearch.action.search.SearchShardTask;
import org.opensearch.action.search.SearchType;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.SetOnce;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.lucene.search.Queries;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.BigArrays;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.index.IndexService;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.cache.bitset.BitsetFilterCache;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.ObjectMapper;
import org.opensearch.index.query.ParsedQuery;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.search.NestedHelper;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.similarity.SimilarityService;
import org.opensearch.search.SearchExtBuilder;
import org.opensearch.search.SearchService;
import org.opensearch.search.SearchShardTarget;
import org.opensearch.search.aggregations.BucketCollectorProcessor;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.SearchContextAggregations;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.collapse.CollapseContext;
import org.opensearch.search.dfs.DfsSearchResult;
import org.opensearch.search.fetch.FetchPhase;
import org.opensearch.search.fetch.FetchSearchResult;
import org.opensearch.search.fetch.StoredFieldsContext;
import org.opensearch.search.fetch.subphase.FetchDocValuesContext;
import org.opensearch.search.fetch.subphase.FetchFieldsContext;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.search.fetch.subphase.ScriptFieldsContext;
import org.opensearch.search.fetch.subphase.highlight.SearchHighlightContext;
import org.opensearch.search.internal.ContextIndexSearcher;
import org.opensearch.search.internal.PitReaderContext;
import org.opensearch.search.internal.ReaderContext;
import org.opensearch.search.internal.ScrollContext;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.internal.ShardSearchContextId;
import org.opensearch.search.internal.ShardSearchRequest;
import org.opensearch.search.profile.Profilers;
import org.opensearch.search.query.QueryPhaseExecutionException;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.search.query.ReduceableSearchResult;
import org.opensearch.search.rescore.RescoreContext;
import org.opensearch.search.slice.SliceBuilder;
import org.opensearch.search.sort.SortAndFormats;
import org.opensearch.search.suggest.SuggestionSearchContext;

final class DefaultSearchContext
extends SearchContext {
    private final ReaderContext readerContext;
    private final Engine.Searcher engineSearcher;
    private final ShardSearchRequest request;
    private final SearchShardTarget shardTarget;
    private final LongSupplier relativeTimeSupplier;
    private SearchType searchType;
    private final BigArrays bigArrays;
    private final IndexShard indexShard;
    private final ClusterService clusterService;
    private final IndexService indexService;
    private final ContextIndexSearcher searcher;
    private final DfsSearchResult dfsResult;
    private final QuerySearchResult queryResult;
    private final FetchSearchResult fetchResult;
    private final float queryBoost;
    private final boolean lowLevelCancellation;
    private TimeValue timeout;
    private int terminateAfter = 0;
    private List<String> groupStats;
    private boolean explain;
    private boolean version = false;
    private boolean seqAndPrimaryTerm = false;
    private StoredFieldsContext storedFields;
    private ScriptFieldsContext scriptFields;
    private FetchSourceContext fetchSourceContext;
    private FetchDocValuesContext docValuesContext;
    private FetchFieldsContext fetchFieldsContext;
    private int from = -1;
    private int size = -1;
    private SortAndFormats sort;
    private Float minimumScore;
    private boolean trackScores = false;
    private boolean includeNamedQueriesScore = false;
    private int trackTotalHitsUpTo = 10000;
    private FieldDoc searchAfter;
    private CollapseContext collapse;
    private SliceBuilder sliceBuilder;
    private SearchShardTask task;
    private final Version minNodeVersion;
    private ParsedQuery originalQuery;
    private Query query;
    private ParsedQuery postFilter;
    private Query aliasFilter;
    private int[] docIdsToLoad;
    private int docsIdsToLoadFrom;
    private int docsIdsToLoadSize;
    private SearchContextAggregations aggregations;
    private SearchHighlightContext highlight;
    private SuggestionSearchContext suggest;
    private List<RescoreContext> rescore;
    private Profilers profilers;
    private BucketCollectorProcessor bucketCollectorProcessor = NO_OP_BUCKET_COLLECTOR_PROCESSOR;
    private final Map<String, SearchExtBuilder> searchExtBuilders = new HashMap<String, SearchExtBuilder>();
    private final Map<Class<?>, CollectorManager<? extends Collector, ReduceableSearchResult>> queryCollectorManagers = new HashMap();
    private final QueryShardContext queryShardContext;
    private final FetchPhase fetchPhase;
    private final Function<SearchSourceBuilder, InternalAggregation.ReduceContextBuilder> requestToAggReduceContextBuilder;
    private final boolean concurrentSearchSettingsEnabled;
    private final SetOnce<Boolean> requestShouldUseConcurrentSearch = new SetOnce();
    private final int maxAggRewriteFilters;
    private final int cardinalityAggregationPruningThreshold;

    DefaultSearchContext(ReaderContext readerContext, ShardSearchRequest request, SearchShardTarget shardTarget, ClusterService clusterService, BigArrays bigArrays, LongSupplier relativeTimeSupplier, TimeValue timeout, FetchPhase fetchPhase, boolean lowLevelCancellation, Version minNodeVersion, boolean validate, Executor executor, Function<SearchSourceBuilder, InternalAggregation.ReduceContextBuilder> requestToAggReduceContextBuilder) throws IOException {
        this.readerContext = readerContext;
        this.request = request;
        this.fetchPhase = fetchPhase;
        this.searchType = request.searchType();
        this.shardTarget = shardTarget;
        this.bigArrays = bigArrays.withCircuitBreaking();
        this.dfsResult = new DfsSearchResult(readerContext.id(), shardTarget, request);
        this.queryResult = new QuerySearchResult(readerContext.id(), shardTarget, request);
        this.fetchResult = new FetchSearchResult(readerContext.id(), shardTarget);
        this.indexService = readerContext.indexService();
        this.indexShard = readerContext.indexShard();
        this.clusterService = clusterService;
        this.engineSearcher = readerContext.acquireSearcher("search");
        this.concurrentSearchSettingsEnabled = this.evaluateConcurrentSegmentSearchSettings(executor);
        this.searcher = new ContextIndexSearcher(this.engineSearcher.getIndexReader(), this.engineSearcher.getSimilarity(), this.engineSearcher.getQueryCache(), this.engineSearcher.getQueryCachingPolicy(), lowLevelCancellation, this.concurrentSearchSettingsEnabled ? executor : null, this);
        this.relativeTimeSupplier = relativeTimeSupplier;
        this.timeout = timeout;
        this.minNodeVersion = minNodeVersion;
        this.queryShardContext = this.indexService.newQueryShardContext(request.shardId().id(), this.searcher, request::nowInMillis, shardTarget.getClusterAlias(), validate);
        this.queryBoost = request.indexBoost();
        this.lowLevelCancellation = lowLevelCancellation;
        this.requestToAggReduceContextBuilder = requestToAggReduceContextBuilder;
        this.maxAggRewriteFilters = this.evaluateFilterRewriteSetting();
        this.cardinalityAggregationPruningThreshold = this.evaluateCardinalityAggregationPruningThreshold();
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.engineSearcher, this.searcher});
    }

    @Override
    public void preProcess(boolean rewrite) {
        int sliceLimit;
        int maxResultWindow;
        long size;
        if (this.hasOnlySuggest()) {
            return;
        }
        long from = this.from() == -1 ? 0L : (long)this.from();
        long resultWindow = from + (size = this.size() == -1 ? 10L : (long)this.size());
        if (resultWindow > (long)(maxResultWindow = this.indexService.getIndexSettings().getMaxResultWindow())) {
            if (this.scrollContext() == null) {
                throw new IllegalArgumentException("Result window is too large, from + size must be less than or equal to: [" + maxResultWindow + "] but was [" + resultWindow + "]. See the scroll api for a more efficient way to request large data sets. This limit can be set by changing the [" + IndexSettings.MAX_RESULT_WINDOW_SETTING.getKey() + "] index level setting.");
            }
            throw new IllegalArgumentException("Batch size is too large, size must be less than or equal to: [" + maxResultWindow + "] but was [" + resultWindow + "]. Scroll batch sizes cost as much memory as result windows so they are controlled by the [" + IndexSettings.MAX_RESULT_WINDOW_SETTING.getKey() + "] index level setting.");
        }
        if (this.rescore != null) {
            if (this.sort != null) {
                throw new IllegalArgumentException("Cannot use [sort] option in conjunction with [rescore].");
            }
            int maxWindow = this.indexService.getIndexSettings().getMaxRescoreWindow();
            for (RescoreContext rescoreContext : this.rescore()) {
                if (rescoreContext.getWindowSize() <= maxWindow) continue;
                throw new IllegalArgumentException("Rescore window [" + rescoreContext.getWindowSize() + "] is too large. It must be less than [" + maxWindow + "]. This prevents allocating massive heaps for storing the results to be rescored. This limit can be set by changing the [" + IndexSettings.MAX_RESCORE_WINDOW_SETTING.getKey() + "] index level setting.");
            }
        }
        if (this.sliceBuilder != null && this.scrollContext() != null) {
            sliceLimit = this.indexService.getIndexSettings().getMaxSlicesPerScroll();
            int numSlices = this.sliceBuilder.getMax();
            if (numSlices > sliceLimit) {
                throw new IllegalArgumentException("The number of slices [" + numSlices + "] is too large. It must be less than [" + sliceLimit + "]. This limit can be set by changing the [" + IndexSettings.MAX_SLICES_PER_SCROLL.getKey() + "] index level setting.");
            }
        }
        if (this.sliceBuilder != null && this.readerContext != null && this.readerContext instanceof PitReaderContext) {
            sliceLimit = this.indexService.getIndexSettings().getMaxSlicesPerPit();
            int numSlices = this.sliceBuilder.getMax();
            if (numSlices > sliceLimit) {
                throw new OpenSearchRejectedExecutionException("The number of slices [" + numSlices + "] is too large. It must be less than [" + sliceLimit + "]. This limit can be set by changing the [" + IndexSettings.MAX_SLICES_PER_PIT.getKey() + "] index level setting.");
            }
        }
        try {
            QueryBuilder queryBuilder = this.request.getAliasFilter().getQueryBuilder();
            this.aliasFilter = queryBuilder == null ? null : queryBuilder.toQuery(this.queryShardContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (this.query() == null) {
            this.parsedQuery(ParsedQuery.parsedMatchAllQuery());
        }
        if (this.queryBoost() != 1.0f) {
            this.parsedQuery(new ParsedQuery((Query)new BoostQuery(this.query(), this.queryBoost), this.parsedQuery()));
        }
        this.query = this.buildFilteredQuery(this.query);
        if (rewrite) {
            try {
                this.query = this.searcher.rewrite(this.query);
            }
            catch (IOException e) {
                throw new QueryPhaseExecutionException(this.shardTarget, "Failed to rewrite main query", e);
            }
        }
    }

    @Override
    public Query buildFilteredQuery(Query query) {
        ArrayList<Query> filters = new ArrayList<Query>();
        if (this.mapperService().hasNested() && new NestedHelper(this.mapperService()).mightMatchNestedDocs(query) && (this.aliasFilter == null || new NestedHelper(this.mapperService()).mightMatchNestedDocs(this.aliasFilter))) {
            filters.add(Queries.newNonNestedFilter());
        }
        if (this.aliasFilter != null) {
            filters.add(this.aliasFilter);
        }
        if (this.sliceBuilder != null) {
            Query slicedQuery = this.sliceBuilder.toFilter(this.clusterService, this.request, this.queryShardContext, this.minNodeVersion);
            if (slicedQuery instanceof MatchNoDocsQuery) {
                return slicedQuery;
            }
            filters.add(slicedQuery);
        }
        if (filters.isEmpty()) {
            return query;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(query, BooleanClause.Occur.MUST);
        for (Query filter : filters) {
            builder.add(filter, BooleanClause.Occur.FILTER);
        }
        return builder.build();
    }

    @Override
    public ShardSearchContextId id() {
        return this.readerContext.id();
    }

    @Override
    public String source() {
        return "search";
    }

    @Override
    public ShardSearchRequest request() {
        return this.request;
    }

    @Override
    public SearchType searchType() {
        return this.searchType;
    }

    @Override
    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    @Override
    public int numberOfShards() {
        return this.request.numberOfShards();
    }

    @Override
    public float queryBoost() {
        return this.queryBoost;
    }

    @Override
    public ScrollContext scrollContext() {
        return this.readerContext.scrollContext();
    }

    @Override
    public SearchContextAggregations aggregations() {
        return this.aggregations;
    }

    @Override
    public SearchContext aggregations(SearchContextAggregations aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    @Override
    public void addSearchExt(SearchExtBuilder searchExtBuilder) {
        this.searchExtBuilders.put(searchExtBuilder.getWriteableName(), searchExtBuilder);
    }

    @Override
    public SearchExtBuilder getSearchExt(String name) {
        return this.searchExtBuilders.get(name);
    }

    @Override
    public SearchHighlightContext highlight() {
        return this.highlight;
    }

    @Override
    public void highlight(SearchHighlightContext highlight) {
        this.highlight = highlight;
    }

    @Override
    public SuggestionSearchContext suggest() {
        return this.suggest;
    }

    @Override
    public void suggest(SuggestionSearchContext suggest) {
        this.suggest = suggest;
    }

    @Override
    public List<RescoreContext> rescore() {
        if (this.rescore == null) {
            return Collections.emptyList();
        }
        return this.rescore;
    }

    @Override
    public void addRescore(RescoreContext rescore) {
        if (this.rescore == null) {
            this.rescore = new ArrayList<RescoreContext>();
        }
        this.rescore.add(rescore);
    }

    @Override
    public boolean hasScriptFields() {
        return this.scriptFields != null;
    }

    @Override
    public ScriptFieldsContext scriptFields() {
        if (this.scriptFields == null) {
            this.scriptFields = new ScriptFieldsContext();
        }
        return this.scriptFields;
    }

    @Override
    public boolean sourceRequested() {
        return this.fetchSourceContext != null && this.fetchSourceContext.fetchSource();
    }

    @Override
    public boolean hasFetchSourceContext() {
        return this.fetchSourceContext != null;
    }

    @Override
    public FetchSourceContext fetchSourceContext() {
        return this.fetchSourceContext;
    }

    @Override
    public SearchContext fetchSourceContext(FetchSourceContext fetchSourceContext) {
        this.fetchSourceContext = fetchSourceContext;
        return this;
    }

    @Override
    public FetchDocValuesContext docValuesContext() {
        return this.docValuesContext;
    }

    @Override
    public SearchContext docValuesContext(FetchDocValuesContext docValuesContext) {
        this.docValuesContext = docValuesContext;
        return this;
    }

    @Override
    public FetchFieldsContext fetchFieldsContext() {
        return this.fetchFieldsContext;
    }

    @Override
    public SearchContext fetchFieldsContext(FetchFieldsContext fetchFieldsContext) {
        this.fetchFieldsContext = fetchFieldsContext;
        return this;
    }

    @Override
    public ContextIndexSearcher searcher() {
        return this.searcher;
    }

    @Override
    public IndexShard indexShard() {
        return this.indexShard;
    }

    @Override
    public MapperService mapperService() {
        return this.indexService.mapperService();
    }

    @Override
    public SimilarityService similarityService() {
        return this.indexService.similarityService();
    }

    @Override
    public BigArrays bigArrays() {
        return this.bigArrays;
    }

    @Override
    public BitsetFilterCache bitsetFilterCache() {
        return this.indexService.cache().bitsetFilterCache();
    }

    @Override
    public TimeValue timeout() {
        return this.timeout;
    }

    @Override
    public void timeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    @Override
    public int terminateAfter() {
        return this.terminateAfter;
    }

    @Override
    public void terminateAfter(int terminateAfter) {
        this.terminateAfter = terminateAfter;
    }

    @Override
    public SearchContext minimumScore(float minimumScore) {
        this.minimumScore = Float.valueOf(minimumScore);
        return this;
    }

    @Override
    public Float minimumScore() {
        return this.minimumScore;
    }

    @Override
    public SearchContext sort(SortAndFormats sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public SortAndFormats sort() {
        return this.sort;
    }

    @Override
    public SearchContext trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    @Override
    public boolean trackScores() {
        return this.trackScores;
    }

    @Override
    public SearchContext includeNamedQueriesScore(boolean includeNamedQueriesScore) {
        this.includeNamedQueriesScore = includeNamedQueriesScore;
        return this;
    }

    @Override
    public boolean includeNamedQueriesScore() {
        return this.includeNamedQueriesScore;
    }

    @Override
    public SearchContext trackTotalHitsUpTo(int trackTotalHitsUpTo) {
        this.trackTotalHitsUpTo = trackTotalHitsUpTo;
        return this;
    }

    @Override
    public int trackTotalHitsUpTo() {
        return this.trackTotalHitsUpTo;
    }

    @Override
    public SearchContext searchAfter(FieldDoc searchAfter) {
        this.searchAfter = searchAfter;
        return this;
    }

    @Override
    public boolean lowLevelCancellation() {
        return this.lowLevelCancellation;
    }

    @Override
    public FieldDoc searchAfter() {
        return this.searchAfter;
    }

    @Override
    public SearchContext collapse(CollapseContext collapse) {
        this.collapse = collapse;
        return this;
    }

    @Override
    public CollapseContext collapse() {
        return this.collapse;
    }

    public SearchContext sliceBuilder(SliceBuilder sliceBuilder) {
        this.sliceBuilder = sliceBuilder;
        return this;
    }

    @Override
    public SearchContext parsedPostFilter(ParsedQuery postFilter) {
        this.postFilter = postFilter;
        return this;
    }

    @Override
    public ParsedQuery parsedPostFilter() {
        return this.postFilter;
    }

    @Override
    public Query aliasFilter() {
        return this.aliasFilter;
    }

    @Override
    public SearchContext parsedQuery(ParsedQuery query) {
        this.originalQuery = query;
        this.query = query.query();
        return this;
    }

    @Override
    public ParsedQuery parsedQuery() {
        return this.originalQuery;
    }

    @Override
    public Query query() {
        return this.query;
    }

    @Override
    public int from() {
        return this.from;
    }

    @Override
    public SearchContext from(int from) {
        this.from = from;
        return this;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public SearchContext size(int size) {
        this.size = size;
        return this;
    }

    @Override
    public boolean hasStoredFields() {
        return this.storedFields != null && this.storedFields.fieldNames() != null;
    }

    @Override
    public boolean hasStoredFieldsContext() {
        return this.storedFields != null;
    }

    @Override
    public StoredFieldsContext storedFieldsContext() {
        return this.storedFields;
    }

    @Override
    public SearchContext storedFieldsContext(StoredFieldsContext storedFieldsContext) {
        this.storedFields = storedFieldsContext;
        return this;
    }

    @Override
    public boolean storedFieldsRequested() {
        return this.storedFields == null || this.storedFields.fetchFields();
    }

    @Override
    public boolean explain() {
        return this.explain;
    }

    @Override
    public void explain(boolean explain) {
        this.explain = explain;
    }

    @Override
    @Nullable
    public List<String> groupStats() {
        return this.groupStats;
    }

    @Override
    public void groupStats(List<String> groupStats) {
        this.groupStats = groupStats;
    }

    @Override
    public boolean version() {
        return this.version;
    }

    @Override
    public void version(boolean version) {
        this.version = version;
    }

    @Override
    public boolean seqNoAndPrimaryTerm() {
        return this.seqAndPrimaryTerm;
    }

    @Override
    public void seqNoAndPrimaryTerm(boolean seqNoAndPrimaryTerm) {
        this.seqAndPrimaryTerm = seqNoAndPrimaryTerm;
    }

    @Override
    public int[] docIdsToLoad() {
        return this.docIdsToLoad;
    }

    @Override
    public int docIdsToLoadFrom() {
        return this.docsIdsToLoadFrom;
    }

    @Override
    public int docIdsToLoadSize() {
        return this.docsIdsToLoadSize;
    }

    @Override
    public SearchContext docIdsToLoad(int[] docIdsToLoad, int docsIdsToLoadFrom, int docsIdsToLoadSize) {
        this.docIdsToLoad = docIdsToLoad;
        this.docsIdsToLoadFrom = docsIdsToLoadFrom;
        this.docsIdsToLoadSize = docsIdsToLoadSize;
        return this;
    }

    @Override
    public DfsSearchResult dfsResult() {
        return this.dfsResult;
    }

    @Override
    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    @Override
    public FetchPhase fetchPhase() {
        return this.fetchPhase;
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this.fetchResult;
    }

    @Override
    public MappedFieldType fieldType(String name) {
        return this.mapperService().fieldType(name);
    }

    @Override
    public ObjectMapper getObjectMapper(String name) {
        return this.mapperService().getObjectMapper(name);
    }

    @Override
    public long getRelativeTimeInMillis() {
        return this.relativeTimeSupplier.getAsLong();
    }

    @Override
    public Map<Class<?>, CollectorManager<? extends Collector, ReduceableSearchResult>> queryCollectorManagers() {
        return this.queryCollectorManagers;
    }

    @Override
    public QueryShardContext getQueryShardContext() {
        return this.queryShardContext;
    }

    @Override
    public Profilers getProfilers() {
        return this.profilers;
    }

    @Override
    public boolean shouldUseConcurrentSearch() {
        assert (this.requestShouldUseConcurrentSearch.get() != null) : "requestShouldUseConcurrentSearch must be set";
        return this.concurrentSearchSettingsEnabled && Boolean.TRUE.equals(this.requestShouldUseConcurrentSearch.get());
    }

    public void evaluateRequestShouldUseConcurrentSearch() {
        if (this.sort != null && this.sort.isSortOnTimeSeriesField()) {
            this.requestShouldUseConcurrentSearch.set((Object)false);
        } else if (this.aggregations() != null && this.aggregations().factories() != null && !this.aggregations().factories().allFactoriesSupportConcurrentSearch()) {
            this.requestShouldUseConcurrentSearch.set((Object)false);
        } else if (this.terminateAfter != 0) {
            this.requestShouldUseConcurrentSearch.set((Object)false);
        } else {
            this.requestShouldUseConcurrentSearch.set((Object)true);
        }
    }

    public void setProfilers(Profilers profilers) {
        this.profilers = profilers;
    }

    @Override
    public void setTask(SearchShardTask task) {
        this.task = task;
    }

    @Override
    public SearchShardTask getTask() {
        return this.task;
    }

    @Override
    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    @Override
    public ReaderContext readerContext() {
        return this.readerContext;
    }

    @Override
    public InternalAggregation.ReduceContext partialOnShard() {
        InternalAggregation.ReduceContext rc = this.requestToAggReduceContextBuilder.apply(this.request.source()).forPartialReduction();
        rc.setSliceLevel(this.shouldUseConcurrentSearch());
        return rc;
    }

    @Override
    public void setBucketCollectorProcessor(BucketCollectorProcessor bucketCollectorProcessor) {
        this.bucketCollectorProcessor = bucketCollectorProcessor;
    }

    @Override
    public BucketCollectorProcessor bucketCollectorProcessor() {
        return this.bucketCollectorProcessor;
    }

    private boolean evaluateConcurrentSegmentSearchSettings(Executor concurrentSearchExecutor) {
        if (this.indexShard.isSystem() || this.indexShard.indexSettings().isSearchThrottled()) {
            return false;
        }
        if (this.clusterService != null && concurrentSearchExecutor != null) {
            return this.indexService.getIndexSettings().getSettings().getAsBoolean(IndexSettings.INDEX_CONCURRENT_SEGMENT_SEARCH_SETTING.getKey(), this.clusterService.getClusterSettings().get(SearchService.CLUSTER_CONCURRENT_SEGMENT_SEARCH_SETTING));
        }
        return false;
    }

    @Override
    public boolean shouldUseTimeSeriesDescSortOptimization() {
        return this.indexShard.isTimeSeriesDescSortOptimizationEnabled() && this.sort != null && this.sort.isSortOnTimeSeriesField() && !this.sort.sort.getSort()[0].getReverse();
    }

    @Override
    public int getTargetMaxSliceCount() {
        if (!this.shouldUseConcurrentSearch()) {
            throw new IllegalStateException("Target slice count should not be used when concurrent search is disabled");
        }
        return this.clusterService.getClusterSettings().get(SearchService.CONCURRENT_SEGMENT_SEARCH_TARGET_MAX_SLICE_COUNT_SETTING);
    }

    @Override
    public int maxAggRewriteFilters() {
        return this.maxAggRewriteFilters;
    }

    private int evaluateFilterRewriteSetting() {
        if (this.clusterService != null) {
            return this.clusterService.getClusterSettings().get(SearchService.MAX_AGGREGATION_REWRITE_FILTERS);
        }
        return 0;
    }

    @Override
    public int cardinalityAggregationPruningThreshold() {
        return this.cardinalityAggregationPruningThreshold;
    }

    private int evaluateCardinalityAggregationPruningThreshold() {
        if (this.clusterService != null) {
            return this.clusterService.getClusterSettings().get(SearchService.CARDINALITY_AGGREGATION_PRUNING_THRESHOLD);
        }
        return 0;
    }
}

