/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.opensearch.OpenSearchException;
import org.opensearch.search.profile.AbstractProfileBreakdown;
import org.opensearch.search.profile.ContextualProfileBreakdown;
import org.opensearch.search.profile.query.QueryProfileBreakdown;
import org.opensearch.search.profile.query.QueryTimingType;

public final class ConcurrentQueryProfileBreakdown
extends ContextualProfileBreakdown<QueryTimingType> {
    static final String SLICE_END_TIME_SUFFIX = "_slice_end_time";
    static final String SLICE_START_TIME_SUFFIX = "_slice_start_time";
    static final String MAX_PREFIX = "max_";
    static final String MIN_PREFIX = "min_";
    static final String AVG_PREFIX = "avg_";
    private long queryNodeTime = Long.MIN_VALUE;
    private long maxSliceNodeTime = Long.MIN_VALUE;
    private long minSliceNodeTime = Long.MAX_VALUE;
    private long avgSliceNodeTime = 0L;
    private final Map<Object, AbstractProfileBreakdown<QueryTimingType>> contexts = new ConcurrentHashMap<Object, AbstractProfileBreakdown<QueryTimingType>>();
    private final Map<Collector, List<LeafReaderContext>> sliceCollectorsToLeaves = new ConcurrentHashMap<Collector, List<LeafReaderContext>>();

    public ConcurrentQueryProfileBreakdown() {
        super(QueryTimingType.class);
    }

    @Override
    public AbstractProfileBreakdown<QueryTimingType> context(Object context) {
        AbstractProfileBreakdown<QueryTimingType> profile = this.contexts.get(context);
        if (profile != null) {
            return profile;
        }
        return this.contexts.computeIfAbsent(context, ctx -> new QueryProfileBreakdown());
    }

    @Override
    public Map<String, Long> toBreakdownMap() {
        Map<String, Long> topLevelBreakdownMapWithWeightTime = super.toBreakdownMap();
        long createWeightStartTime = topLevelBreakdownMapWithWeightTime.get(QueryTimingType.CREATE_WEIGHT + "_start_time");
        long createWeightTime = topLevelBreakdownMapWithWeightTime.get(QueryTimingType.CREATE_WEIGHT.toString());
        if (this.contexts.isEmpty()) {
            this.queryNodeTime = createWeightTime;
            this.maxSliceNodeTime = 0L;
            this.minSliceNodeTime = 0L;
            this.avgSliceNodeTime = 0L;
            return this.buildDefaultQueryBreakdownMap(createWeightTime);
        }
        if (this.sliceCollectorsToLeaves.isEmpty()) {
            assert (this.contexts.size() == 1) : "Unexpected size: " + this.contexts.size() + " of leaves breakdown in ConcurrentQueryProfileBreakdown of rewritten query for a leaf.";
            AbstractProfileBreakdown<QueryTimingType> breakdown = this.contexts.values().iterator().next();
            this.queryNodeTime = breakdown.toNodeTime() + createWeightTime;
            this.maxSliceNodeTime = 0L;
            this.minSliceNodeTime = 0L;
            this.avgSliceNodeTime = 0L;
            HashMap<String, Long> queryBreakdownMap = new HashMap<String, Long>(breakdown.toBreakdownMap());
            queryBreakdownMap.put(QueryTimingType.CREATE_WEIGHT.toString(), createWeightTime);
            queryBreakdownMap.put(QueryTimingType.CREATE_WEIGHT + "_count", 1L);
            return queryBreakdownMap;
        }
        Map<Collector, Map<String, Long>> sliceLevelBreakdowns = this.buildSliceLevelBreakdown();
        return this.buildQueryBreakdownMap(sliceLevelBreakdowns, createWeightTime, createWeightStartTime);
    }

    private Map<String, Long> buildDefaultQueryBreakdownMap(long createWeightTime) {
        HashMap<String, Long> concurrentQueryBreakdownMap = new HashMap<String, Long>();
        for (QueryTimingType timingType : QueryTimingType.values()) {
            String timingTypeKey = timingType.toString();
            String timingTypeCountKey = timingTypeKey + "_count";
            if (timingType.equals((Object)QueryTimingType.CREATE_WEIGHT)) {
                concurrentQueryBreakdownMap.put(timingTypeKey, createWeightTime);
                concurrentQueryBreakdownMap.put(timingTypeCountKey, 1L);
                continue;
            }
            String maxBreakdownTypeTime = MAX_PREFIX + timingTypeKey;
            String minBreakdownTypeTime = MIN_PREFIX + timingTypeKey;
            String avgBreakdownTypeTime = AVG_PREFIX + timingTypeKey;
            String maxBreakdownTypeCount = MAX_PREFIX + timingTypeCountKey;
            String minBreakdownTypeCount = MIN_PREFIX + timingTypeCountKey;
            String avgBreakdownTypeCount = AVG_PREFIX + timingTypeCountKey;
            concurrentQueryBreakdownMap.put(timingTypeKey, 0L);
            concurrentQueryBreakdownMap.put(maxBreakdownTypeTime, 0L);
            concurrentQueryBreakdownMap.put(minBreakdownTypeTime, 0L);
            concurrentQueryBreakdownMap.put(avgBreakdownTypeTime, 0L);
            concurrentQueryBreakdownMap.put(timingTypeCountKey, 0L);
            concurrentQueryBreakdownMap.put(maxBreakdownTypeCount, 0L);
            concurrentQueryBreakdownMap.put(minBreakdownTypeCount, 0L);
            concurrentQueryBreakdownMap.put(avgBreakdownTypeCount, 0L);
        }
        return concurrentQueryBreakdownMap;
    }

    Map<Collector, Map<String, Long>> buildSliceLevelBreakdown() {
        HashMap<Collector, Map<String, Long>> sliceLevelBreakdowns = new HashMap<Collector, Map<String, Long>>();
        long totalSliceNodeTime = 0L;
        for (Map.Entry<Collector, List<LeafReaderContext>> slice : this.sliceCollectorsToLeaves.entrySet()) {
            long currentSliceNodeTime;
            Collector sliceCollector = slice.getKey();
            Map currentSliceBreakdown = sliceLevelBreakdowns.computeIfAbsent(sliceCollector, k -> new HashMap());
            long sliceMaxEndTime = Long.MIN_VALUE;
            long sliceMinStartTime = Long.MAX_VALUE;
            for (QueryTimingType timingType : QueryTimingType.values()) {
                if (timingType.equals((Object)QueryTimingType.CREATE_WEIGHT)) continue;
                String timingTypeCountKey = timingType + "_count";
                String timingTypeStartKey = timingType + "_start_time";
                String timingTypeSliceStartTimeKey = timingType + SLICE_START_TIME_SUFFIX;
                String timingTypeSliceEndTimeKey = timingType + SLICE_END_TIME_SUFFIX;
                for (LeafReaderContext sliceLeaf : slice.getValue()) {
                    if (!this.contexts.containsKey(sliceLeaf)) continue;
                    Map<String, Long> currentSliceLeafBreakdownMap = this.contexts.get(sliceLeaf).toBreakdownMap();
                    long sliceLeafTimingTypeCount = currentSliceLeafBreakdownMap.get(timingTypeCountKey);
                    currentSliceBreakdown.compute(timingTypeCountKey, (key, value) -> value == null ? sliceLeafTimingTypeCount : value + sliceLeafTimingTypeCount);
                    if (sliceLeafTimingTypeCount == 0L) continue;
                    long sliceLeafTimingTypeStartTime = currentSliceLeafBreakdownMap.get(timingTypeStartKey);
                    currentSliceBreakdown.compute(timingTypeSliceStartTimeKey, (key, value) -> value == null ? sliceLeafTimingTypeStartTime : Math.min(value, sliceLeafTimingTypeStartTime));
                    long sliceLeafTimingTypeEndTime = sliceLeafTimingTypeStartTime + currentSliceLeafBreakdownMap.get(timingType.toString());
                    currentSliceBreakdown.compute(timingTypeSliceEndTimeKey, (key, value) -> value == null ? sliceLeafTimingTypeEndTime : Math.max(value, sliceLeafTimingTypeEndTime));
                }
                if (currentSliceBreakdown.get(timingTypeCountKey) != null && (Long)currentSliceBreakdown.get(timingTypeCountKey) == 0L) {
                    currentSliceBreakdown.put(timingTypeSliceStartTimeKey, 0L);
                    currentSliceBreakdown.put(timingTypeSliceEndTimeKey, 0L);
                }
                sliceMaxEndTime = Math.max(sliceMaxEndTime, currentSliceBreakdown.getOrDefault(timingTypeSliceEndTimeKey, Long.MIN_VALUE));
                long currentSliceStartTime = currentSliceBreakdown.getOrDefault(timingTypeSliceStartTimeKey, Long.MAX_VALUE);
                if (currentSliceStartTime == 0L) continue;
                sliceMinStartTime = Math.min(sliceMinStartTime, currentSliceStartTime);
                currentSliceBreakdown.put(timingType.toString(), currentSliceBreakdown.getOrDefault(timingTypeSliceEndTimeKey, 0L) - currentSliceBreakdown.getOrDefault(timingTypeSliceStartTimeKey, 0L));
            }
            if (sliceMinStartTime == Long.MAX_VALUE && sliceMaxEndTime == Long.MIN_VALUE) {
                currentSliceNodeTime = 0L;
            } else {
                if (sliceMinStartTime == Long.MAX_VALUE || sliceMaxEndTime == Long.MIN_VALUE) {
                    throw new OpenSearchException("Unexpected value of sliceMinStartTime [" + sliceMinStartTime + "] or sliceMaxEndTime [" + sliceMaxEndTime + "] while computing the slice level timing profile breakdowns", new Object[0]);
                }
                currentSliceNodeTime = sliceMaxEndTime - sliceMinStartTime;
            }
            this.maxSliceNodeTime = Math.max(this.maxSliceNodeTime, currentSliceNodeTime);
            this.minSliceNodeTime = Math.min(this.minSliceNodeTime, currentSliceNodeTime);
            totalSliceNodeTime += currentSliceNodeTime;
        }
        this.avgSliceNodeTime = totalSliceNodeTime / (long)this.sliceCollectorsToLeaves.size();
        return sliceLevelBreakdowns;
    }

    public Map<String, Long> buildQueryBreakdownMap(Map<Collector, Map<String, Long>> sliceLevelBreakdowns, long createWeightTime, long createWeightStartTime) {
        HashMap<String, Long> queryBreakdownMap = new HashMap<String, Long>();
        long queryEndTime = Long.MIN_VALUE;
        for (QueryTimingType queryTimingType : QueryTimingType.values()) {
            String timingTypeKey = queryTimingType.toString();
            String timingTypeCountKey = timingTypeKey + "_count";
            String sliceEndTimeForTimingType = timingTypeKey + SLICE_END_TIME_SUFFIX;
            String sliceStartTimeForTimingType = timingTypeKey + SLICE_START_TIME_SUFFIX;
            String maxBreakdownTypeTime = MAX_PREFIX + timingTypeKey;
            String minBreakdownTypeTime = MIN_PREFIX + timingTypeKey;
            String avgBreakdownTypeTime = AVG_PREFIX + timingTypeKey;
            String maxBreakdownTypeCount = MAX_PREFIX + timingTypeCountKey;
            String minBreakdownTypeCount = MIN_PREFIX + timingTypeCountKey;
            String avgBreakdownTypeCount = AVG_PREFIX + timingTypeCountKey;
            long queryTimingTypeEndTime = Long.MIN_VALUE;
            long queryTimingTypeStartTime = Long.MAX_VALUE;
            long queryTimingTypeCount = 0L;
            if (queryTimingType == QueryTimingType.CREATE_WEIGHT) {
                queryBreakdownMap.put(timingTypeCountKey, 1L);
                queryBreakdownMap.put(timingTypeKey, createWeightTime);
                continue;
            }
            for (Map.Entry<Collector, Map<String, Long>> sliceBreakdown : sliceLevelBreakdowns.entrySet()) {
                long sliceBreakdownTypeTime = sliceBreakdown.getValue().getOrDefault(timingTypeKey, 0L);
                long sliceBreakdownTypeCount = sliceBreakdown.getValue().getOrDefault(timingTypeCountKey, 0L);
                queryBreakdownMap.compute(maxBreakdownTypeTime, (key, value) -> value == null ? sliceBreakdownTypeTime : Math.max(sliceBreakdownTypeTime, value));
                queryBreakdownMap.compute(minBreakdownTypeTime, (key, value) -> value == null ? sliceBreakdownTypeTime : Math.min(sliceBreakdownTypeTime, value));
                queryBreakdownMap.compute(avgBreakdownTypeTime, (key, value) -> value == null ? sliceBreakdownTypeTime : sliceBreakdownTypeTime + value);
                queryBreakdownMap.compute(maxBreakdownTypeCount, (key, value) -> value == null ? sliceBreakdownTypeCount : Math.max(sliceBreakdownTypeCount, value));
                queryBreakdownMap.compute(minBreakdownTypeCount, (key, value) -> value == null ? sliceBreakdownTypeCount : Math.min(sliceBreakdownTypeCount, value));
                queryBreakdownMap.compute(avgBreakdownTypeCount, (key, value) -> value == null ? sliceBreakdownTypeCount : sliceBreakdownTypeCount + value);
                queryTimingTypeEndTime = Math.max(queryTimingTypeEndTime, sliceBreakdown.getValue().getOrDefault(sliceEndTimeForTimingType, Long.MIN_VALUE));
                queryTimingTypeStartTime = Math.min(queryTimingTypeStartTime, sliceBreakdown.getValue().getOrDefault(sliceStartTimeForTimingType, Long.MAX_VALUE));
                queryTimingTypeCount += sliceBreakdownTypeCount;
            }
            if (queryTimingTypeStartTime == Long.MAX_VALUE || queryTimingTypeEndTime == Long.MIN_VALUE) {
                throw new OpenSearchException("Unexpected timing type [" + timingTypeKey + "] start [" + queryTimingTypeStartTime + "] or end time [" + queryTimingTypeEndTime + "] computed across slices for profile results", new Object[0]);
            }
            queryBreakdownMap.put(timingTypeKey, queryTimingTypeEndTime - queryTimingTypeStartTime);
            queryBreakdownMap.put(timingTypeCountKey, queryTimingTypeCount);
            queryBreakdownMap.compute(avgBreakdownTypeTime, (key, value) -> value == null ? 0L : value / (long)sliceLevelBreakdowns.size());
            queryBreakdownMap.compute(avgBreakdownTypeCount, (key, value) -> value == null ? 0L : value / (long)sliceLevelBreakdowns.size());
            queryEndTime = Math.max(queryEndTime, queryTimingTypeEndTime);
        }
        if (queryEndTime == Long.MIN_VALUE) {
            throw new OpenSearchException("Unexpected error while computing the query end time across slices in profile result", new Object[0]);
        }
        this.queryNodeTime = queryEndTime - createWeightStartTime;
        return queryBreakdownMap;
    }

    @Override
    public long toNodeTime() {
        return this.queryNodeTime;
    }

    @Override
    public void associateCollectorToLeaves(Collector collector, LeafReaderContext leaf) {
        this.sliceCollectorsToLeaves.computeIfAbsent(collector, k -> new ArrayList()).add(leaf);
    }

    @Override
    public void associateCollectorsToLeaves(Map<Collector, List<LeafReaderContext>> collectorsToLeaves) {
        this.sliceCollectorsToLeaves.putAll(collectorsToLeaves);
    }

    Map<Collector, List<LeafReaderContext>> getSliceCollectorsToLeaves() {
        return Collections.unmodifiableMap(this.sliceCollectorsToLeaves);
    }

    Map<Object, AbstractProfileBreakdown<QueryTimingType>> getContexts() {
        return this.contexts;
    }

    long getMaxSliceNodeTime() {
        return this.maxSliceNodeTime;
    }

    long getMinSliceNodeTime() {
        return this.minSliceNodeTime;
    }

    long getAvgSliceNodeTime() {
        return this.avgSliceNodeTime;
    }
}

