/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.transport;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.transport.SecureTransportAction;
import org.opensearch.alerting.transport.TransportSearchMonitorActionKt;
import org.opensearch.alerting.util.AlertingException;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.alerting.action.SearchMonitorRequest;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B7\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J&\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00022\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0014J&\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'2\b\u0010+\u001a\u0004\u0018\u00010,J\u001c\u0010-\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006."}, d2={"Lorg/opensearch/alerting/transport/TransportSearchMonitorAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/action/search/SearchResponse;", "Lorg/opensearch/alerting/transport/SecureTransportAction;", "transportService", "Lorg/opensearch/transport/TransportService;", "settings", "Lorg/opensearch/common/settings/Settings;", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "namedWriteableRegistry", "Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;)V", "getClient", "()Lorg/opensearch/client/Client;", "filterByEnabled", "", "getFilterByEnabled", "()Z", "setFilterByEnabled", "(Z)V", "getNamedWriteableRegistry", "()Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "addOwnerFieldIfNotExists", "", "searchRequest", "Lorg/opensearch/action/search/SearchRequest;", "doExecute", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "resolve", "searchMonitorRequest", "Lorg/opensearch/commons/alerting/action/SearchMonitorRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "search", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nTransportSearchMonitorAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportSearchMonitorAction.kt\norg/opensearch/alerting/transport/TransportSearchMonitorAction\n+ 2 TransportHelpers.kt\norg/opensearch/commons/utils/TransportHelpersKt\n*L\n1#1,129:1\n48#2,5:130\n*S KotlinDebug\n*F\n+ 1 TransportSearchMonitorAction.kt\norg/opensearch/alerting/transport/TransportSearchMonitorAction\n*L\n58#1:130,5\n*E\n"})
public final class TransportSearchMonitorAction
extends HandledTransportAction<ActionRequest, SearchResponse>
implements SecureTransportAction {
    @NotNull
    private final Settings settings;
    @NotNull
    private final Client client;
    @NotNull
    private final NamedWriteableRegistry namedWriteableRegistry;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportSearchMonitorAction(@NotNull TransportService transportService, @NotNull Settings settings, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull ActionFilters actionFilters, @NotNull NamedWriteableRegistry namedWriteableRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)namedWriteableRegistry, (String)"namedWriteableRegistry");
        super("cluster:admin/opendistro/alerting/monitor/search", transportService, actionFilters, SearchMonitorRequest::new);
        this.settings = settings;
        this.client = client;
        this.namedWriteableRegistry = namedWriteableRegistry;
        Object object = AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"AlertingSettings.FILTER_\u2026CKEND_ROLES.get(settings)");
        this.filterByEnabled = (Boolean)object;
        this.listenFilterBySettingChange(clusterService);
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.namedWriteableRegistry;
    }

    @Override
    public boolean getFilterByEnabled() {
        return this.filterByEnabled;
    }

    @Override
    public void setFilterByEnabled(boolean bl) {
        this.filterByEnabled = bl;
    }

    /*
     * Exception decompiling
     */
    protected void doExecute(@NotNull Task task, @NotNull ActionRequest request, @NotNull ActionListener<SearchResponse> actionListener) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void resolve(@NotNull SearchMonitorRequest searchMonitorRequest, @NotNull ActionListener<SearchResponse> actionListener, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)searchMonitorRequest, (String)"searchMonitorRequest");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        if (user == null) {
            this.search(searchMonitorRequest.getSearchRequest(), actionListener);
        } else if (!this.doFilterForUser(user)) {
            this.search(searchMonitorRequest.getSearchRequest(), actionListener);
        } else {
            TransportSearchMonitorActionKt.access$getLog$p().info("Filtering result by: " + user.getBackendRoles());
            SearchSourceBuilder searchSourceBuilder = searchMonitorRequest.getSearchRequest().source();
            Intrinsics.checkNotNullExpressionValue((Object)searchSourceBuilder, (String)"searchMonitorRequest.searchRequest.source()");
            OpenSearchExtensionsKt.addFilter((User)user, (SearchSourceBuilder)searchSourceBuilder, (String)"monitor.user.backend_roles.keyword");
            this.search(searchMonitorRequest.getSearchRequest(), actionListener);
        }
    }

    public final void search(@NotNull SearchRequest searchRequest, @NotNull ActionListener<SearchResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)searchRequest, (String)"searchRequest");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(actionListener){
            final /* synthetic */ ActionListener<SearchResponse> $actionListener;
            {
                this.$actionListener = $actionListener;
            }

            public void onResponse(@NotNull SearchResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                this.$actionListener.onResponse((Object)response2);
            }

            public void onFailure(@NotNull Exception t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$actionListener.onFailure((Exception)AlertingException.Companion.wrap(t));
            }
        });
    }

    private final void addOwnerFieldIfNotExists(SearchRequest searchRequest) {
        if (searchRequest.source().query() == null || !StringsKt.contains$default((CharSequence)searchRequest.source().query().toString(), (CharSequence)"monitor.owner", (boolean)false, (int)2, null)) {
            BoolQueryBuilder boolQueryBuilder;
            if (searchRequest.source().query() == null) {
                boolQueryBuilder = new BoolQueryBuilder();
            } else {
                BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery().must(searchRequest.source().query());
                boolQueryBuilder = boolQueryBuilder2;
                Intrinsics.checkNotNullExpressionValue((Object)boolQueryBuilder2, (String)"boolQuery().must(searchRequest.source().query())");
            }
            BoolQueryBuilder boolQueryBuilder3 = boolQueryBuilder;
            BoolQueryBuilder bqb = new BoolQueryBuilder();
            bqb.should().add(new BoolQueryBuilder().mustNot((QueryBuilder)new ExistsQueryBuilder("monitor.owner")));
            bqb.should().add(new BoolQueryBuilder().must((QueryBuilder)new MatchQueryBuilder("monitor.owner", (Object)"alerting")));
            boolQueryBuilder3.filter((QueryBuilder)bqb);
            searchRequest.source().query((QueryBuilder)boolQueryBuilder3);
        }
    }

    @Override
    public void listenFilterBySettingChange(@NotNull ClusterService clusterService) {
        SecureTransportAction.DefaultImpls.listenFilterBySettingChange(this, clusterService);
    }

    @Override
    @Nullable
    public User readUserFromThreadContext(@NotNull Client client) {
        return SecureTransportAction.DefaultImpls.readUserFromThreadContext(this, client);
    }

    @Override
    public boolean doFilterForUser(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.doFilterForUser(this, user);
    }

    @Override
    public boolean isAdmin(@Nullable User user) {
        return SecureTransportAction.DefaultImpls.isAdmin(this, user);
    }

    @Override
    public <T> boolean validateUserBackendRoles(@Nullable User user, @NotNull ActionListener<T> actionListener) {
        return SecureTransportAction.DefaultImpls.validateUserBackendRoles(this, user, actionListener);
    }

    @Override
    public <T> boolean checkUserPermissionsWithResource(@Nullable User requesterUser, @Nullable User resourceUser, @NotNull ActionListener<T> actionListener, @NotNull String resourceType, @NotNull String resourceId) {
        return SecureTransportAction.DefaultImpls.checkUserPermissionsWithResource(this, requesterUser, resourceUser, actionListener, resourceType, resourceId);
    }
}

