"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderShape = void 0;
var canvas_1 = require("../../../../../renderers/canvas");
var common_1 = require("../../../../../utils/common");
var shapes_paths_1 = require("../../shapes_paths");
var utils_1 = require("./utils");
function renderShape(ctx, shape, coordinates, fill, stroke) {
    if (!stroke || !fill) {
        return;
    }
    canvas_1.withContext(ctx, function (ctx) {
        var _a = __read(shapes_paths_1.ShapeRendererFn[shape], 2), pathFn = _a[0], rotation = _a[1];
        var x = coordinates.x, y = coordinates.y, radius = coordinates.radius;
        ctx.translate(x, y);
        ctx.rotate(common_1.getRadians(rotation));
        ctx.beginPath();
        var path = new Path2D(pathFn(radius));
        utils_1.fillAndStroke(ctx, fill, stroke, path);
    });
}
exports.renderShape = renderShape;
//# sourceMappingURL=shapes.js.map