"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _constants = require("../../utils/constants");
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function _default(services, router) {
  const {
    snapshotManagementService
  } = services;
  router.get({
    path: _constants.NODE_API._SNAPSHOTS,
    validate: {}
  }, snapshotManagementService.getAllSnapshotsWithPolicy);
  router.get({
    path: `${_constants.NODE_API._SNAPSHOTS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        repository: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.getSnapshot);
  router.delete({
    path: `${_constants.NODE_API._SNAPSHOTS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        repository: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.deleteSnapshot);
  router.put({
    path: `${_constants.NODE_API._SNAPSHOTS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        repository: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, snapshotManagementService.createSnapshot);
  router.post({
    path: `${_constants.NODE_API._SNAPSHOTS}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        repository: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, snapshotManagementService.restoreSnapshot);
  router.post({
    path: `${_constants.NODE_API.SMPolicies}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, snapshotManagementService.createPolicy);
  router.put({
    path: `${_constants.NODE_API.SMPolicies}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        seqNo: _configSchema.schema.maybe(_configSchema.schema.number()),
        primaryTerm: _configSchema.schema.maybe(_configSchema.schema.number())
      }),
      body: _configSchema.schema.any()
    }
  }, snapshotManagementService.updatePolicy);
  router.get({
    path: _constants.NODE_API.SMPolicies,
    validate: {
      // for public service to pass object to server service
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        sortField: _configSchema.schema.string(),
        sortOrder: _configSchema.schema.string(),
        queryString: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.getPolicies);
  router.get({
    path: `${_constants.NODE_API.SMPolicies}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.getPolicy);
  router.delete({
    path: `${_constants.NODE_API.SMPolicies}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.deletePolicy);
  router.post({
    path: `${_constants.NODE_API.SMPolicies}/{id}/_start`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.startPolicy);
  router.post({
    path: `${_constants.NODE_API.SMPolicies}/{id}/_stop`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.stopPolicy);
  router.get({
    path: _constants.NODE_API._REPOSITORIES,
    validate: {}
  }, snapshotManagementService.catRepositoriesWithSnapshotCount);
  router.get({
    path: `${_constants.NODE_API._INDICES}/{indices}`,
    validate: {
      params: _configSchema.schema.object({
        indices: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.catSnapshotIndices);
  router.get({
    path: _constants.NODE_API._RECOVERY,
    validate: {}
  }, snapshotManagementService.getIndexRecovery);
  router.delete({
    path: `${_constants.NODE_API._REPOSITORIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.deleteRepository);
  router.get({
    path: `${_constants.NODE_API._REPOSITORIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, snapshotManagementService.getRepository);
  router.put({
    path: `${_constants.NODE_API._REPOSITORIES}/{id}`,
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, snapshotManagementService.createRepository);
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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