"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDslRoute = registerDslRoute;
var _configSchema = require("@osd/config-schema");
var _shared = require("../../common/constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerDslRoute({
  router
}) {
  router.post({
    path: `${_shared.DSL_BASE}${_shared.DSL_SEARCH}`,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const {
      index,
      size,
      ...rest
    } = request.body;
    const params = {
      index,
      size,
      body: rest
    };
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('search', params);
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.get({
    path: `${_shared.DSL_BASE}${_shared.DSL_CAT}`,
    validate: {
      query: _configSchema.schema.object({
        format: _configSchema.schema.string(),
        index: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('cat.indices', request.query);
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.get({
    path: `${_shared.DSL_BASE}${_shared.DSL_MAPPING}`,
    validate: {
      query: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('indices.getMapping', {
        index: request.query.index
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.get({
    path: `${_shared.DSL_BASE}${_shared.DSL_SETTINGS}`,
    validate: {
      query: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('indices.getSettings', {
        index: request.query.index
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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