"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRoutes = setupRoutes;
var _dsl_facet = require("../services/facets/dsl_facet");
var _ppl_facet = require("../services/facets/ppl_facet");
var _saved_objects = _interopRequireDefault(require("../services/facets/saved_objects"));
var _queryService = require("../services/queryService");
var _app_analytics_router = require("./application_analytics/app_analytics_router");
var _panels_router = require("./custom_panels/panels_router");
var _visualizations_router = require("./custom_panels/visualizations_router");
var _data_connections_router = require("./data_connections/data_connections_router");
var _datasources_router = require("./datasources/datasources_router");
var _dsl = require("./dsl");
var _event_analytics_router = require("./event_analytics/event_analytics_router");
var _integrations_router = require("./integrations/integrations_router");
var _metrics_rounter = require("./metrics/metrics_rounter");
var _noteRouter = require("./notebooks/noteRouter");
var _paraRouter = require("./notebooks/paraRouter");
var _sqlRouter = require("./notebooks/sqlRouter");
var _vizRouter = require("./notebooks/vizRouter");
var _ppl = require("./ppl");
var _routes = require("./query_assist/routes");
var _trace_analytics_dsl_router = require("./trace_analytics_dsl_router");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupRoutes({
  router,
  client,
  dataSourceEnabled
}) {
  (0, _panels_router.PanelsRouter)(router);
  (0, _visualizations_router.VisualizationsRouter)(router);
  (0, _ppl.registerPplRoute)({
    router,
    facet: new _ppl_facet.PPLFacet(client)
  });
  (0, _dsl.registerDslRoute)({
    router,
    facet: new _dsl_facet.DSLFacet(client)
  });
  (0, _event_analytics_router.registerEventAnalyticsRouter)({
    router,
    savedObjectFacet: new _saved_objects.default(client)
  });
  (0, _app_analytics_router.registerAppAnalyticsRouter)(router);

  // TODO remove trace analytics route when DSL route for autocomplete is added
  (0, _trace_analytics_dsl_router.registerTraceAnalyticsDslRouter)(router, dataSourceEnabled);

  // notebooks routes
  (0, _paraRouter.registerParaRoute)(router);
  (0, _noteRouter.registerNoteRoute)(router);
  (0, _vizRouter.registerVizRoute)(router);
  const queryService = new _queryService.QueryService(client);
  (0, _sqlRouter.registerSqlRoute)(router, queryService);
  (0, _metrics_rounter.registerMetricsRoute)(router, dataSourceEnabled);
  (0, _integrations_router.registerIntegrationsRoute)(router);
  (0, _data_connections_router.registerDataConnectionsRoute)(router, dataSourceEnabled);
  (0, _datasources_router.registerDatasourcesRoute)(router, dataSourceEnabled);
  (0, _routes.registerQueryAssistRoutes)(router);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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