"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = sqlPlugin;
var _constants = require("../../services/utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function sqlPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.sql = components.clientAction.namespaceFactory();
  const sql = Client.prototype.sql.prototype;
  sql.translateSQL = ca({
    url: {
      fmt: `${_constants.SQL_TRANSLATE_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.translatePPL = ca({
    url: {
      fmt: `${_constants.PPL_TRANSLATE_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sqlQuery = ca({
    url: {
      fmt: `${_constants.SQL_QUERY_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  }); //default: jdbc

  sql.pplQuery = ca({
    url: {
      fmt: `${_constants.PPL_QUERY_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  }); //default: jdbc

  sql.sqlJson = ca({
    url: {
      fmt: `${_constants.SQL_QUERY_ROUTE}?${_constants.FORMAT_JSON}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.pplJson = ca({
    url: {
      fmt: `${_constants.PPL_QUERY_ROUTE}?${_constants.FORMAT_JSON}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sqlCsv = ca({
    url: {
      fmt: `${_constants.SQL_QUERY_ROUTE}?${_constants.FORMAT_CSV}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.pplCsv = ca({
    url: {
      fmt: `${_constants.PPL_QUERY_ROUTE}?${_constants.FORMAT_CSV}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sqlText = ca({
    url: {
      fmt: `${_constants.SQL_QUERY_ROUTE}?${_constants.FORMAT_TEXT}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.pplText = ca({
    url: {
      fmt: `${_constants.PPL_QUERY_ROUTE}?${_constants.FORMAT_TEXT}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sparkSqlQuery = ca({
    url: {
      fmt: `${_constants.SPARK_SQL_QUERY_ROUTE}`
    },
    needBody: true,
    method: 'POST'
  });
  sql.sparkSqlGetQuery = ca({
    url: {
      fmt: `${_constants.SPARK_SQL_QUERY_ROUTE}/<%=jobId%>`,
      req: {
        jobId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'GET'
  });
  sql.datasourcesGetQuery = ca({
    url: {
      fmt: `${_constants.DATASOURCES_GET_QUERY}`
    },
    needBody: false,
    method: 'GET'
  });
  sql.asyncDeleteQuery = ca({
    url: {
      fmt: `${_constants.SPARK_SQL_QUERY_ROUTE}/<%=jobId%>`,
      req: {
        jobId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'DELETE'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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