/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.env.Environment;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.neuralsearch.processor.InferenceProcessor;

public final class TextEmbeddingProcessor
extends InferenceProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(TextEmbeddingProcessor.class);
    public static final String TYPE = "text_embedding";
    public static final String LIST_TYPE_NESTED_MAP_KEY = "knn";

    public TextEmbeddingProcessor(String tag, String description, String modelId, Map<String, Object> fieldMap, MLCommonsClientAccessor clientAccessor, Environment environment, ClusterService clusterService) {
        super(tag, description, TYPE, LIST_TYPE_NESTED_MAP_KEY, modelId, fieldMap, clientAccessor, environment, clusterService);
    }

    @Override
    public void doExecute(IngestDocument ingestDocument, Map<String, Object> ProcessMap, List<String> inferenceList, BiConsumer<IngestDocument, Exception> handler) {
        this.mlCommonsClientAccessor.inferenceSentences(this.modelId, inferenceList, (ActionListener<List<List<Float>>>)ActionListener.wrap(vectors -> {
            this.setVectorFieldsToDocument(ingestDocument, ProcessMap, (List<?>)vectors);
            handler.accept(ingestDocument, null);
        }, e -> handler.accept((IngestDocument)null, (Exception)e)));
    }

    @Override
    public void doBatchExecute(List<String> inferenceList, Consumer<List<?>> handler, Consumer<Exception> onException) {
        this.mlCommonsClientAccessor.inferenceSentences(this.modelId, inferenceList, (ActionListener<List<List<Float>>>)ActionListener.wrap(handler::accept, onException));
    }
}

