/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auditlog.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opensearch.ExceptionsHelper;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auditlog.config.AuditConfig;
import org.opensearch.security.auditlog.impl.AuditCategory;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.filter.OpenSearchRequest;
import org.opensearch.security.filter.SecurityRequest;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.support.WildcardMatcher;

public final class AuditMessage {
    private static final Logger log = LogManager.getLogger(AuditMessage.class);
    private static final WildcardMatcher AUTHORIZATION_HEADER = WildcardMatcher.from("Authorization", false);
    private static final String SENSITIVE_KEY = "password";
    private static final String SENSITIVE_REPLACEMENT_VALUE = "__SENSITIVE__";
    private static final Pattern SENSITIVE_PATHS = Pattern.compile("/(_opendistro/_security|_plugins/_security)/api/(account.*|internalusers.*|user.*)");
    @VisibleForTesting
    public static final Pattern BCRYPT_HASH = Pattern.compile("\\$2[ayb]\\$.{56}");
    private static final String BCRYPT_HASH_REPLACEMENT_VALUE = "__HASH__";
    private static final String INTERNALUSERS_DOC_ID = CType.INTERNALUSERS.toLCString();
    public static final String FORMAT_VERSION = "audit_format_version";
    public static final String CATEGORY = "audit_category";
    public static final String REQUEST_EFFECTIVE_USER = "audit_request_effective_user";
    public static final String REQUEST_INITIATING_USER = "audit_request_initiating_user";
    public static final String UTC_TIMESTAMP = "@timestamp";
    public static final String CLUSTER_NAME = "audit_cluster_name";
    public static final String NODE_ID = "audit_node_id";
    public static final String NODE_HOST_ADDRESS = "audit_node_host_address";
    public static final String NODE_HOST_NAME = "audit_node_host_name";
    public static final String NODE_NAME = "audit_node_name";
    public static final String ORIGIN = "audit_request_origin";
    public static final String REMOTE_ADDRESS = "audit_request_remote_address";
    public static final String REST_REQUEST_PATH = "audit_rest_request_path";
    public static final String REST_REQUEST_PARAMS = "audit_rest_request_params";
    public static final String REST_REQUEST_HEADERS = "audit_rest_request_headers";
    public static final String REST_REQUEST_METHOD = "audit_rest_request_method";
    public static final String TRANSPORT_REQUEST_TYPE = "audit_transport_request_type";
    public static final String TRANSPORT_ACTION = "audit_transport_action";
    public static final String TRANSPORT_REQUEST_HEADERS = "audit_transport_headers";
    public static final String ID = "audit_trace_doc_id";
    public static final String INDICES = "audit_trace_indices";
    public static final String SHARD_ID = "audit_trace_shard_id";
    public static final String RESOLVED_INDICES = "audit_trace_resolved_indices";
    public static final String EXCEPTION = "audit_request_exception_stacktrace";
    public static final String IS_ADMIN_DN = "audit_request_effective_user_is_admin";
    public static final String PRIVILEGE = "audit_request_privilege";
    public static final String TASK_ID = "audit_trace_task_id";
    public static final String TASK_PARENT_ID = "audit_trace_task_parent_id";
    public static final String REQUEST_BODY = "audit_request_body";
    public static final String COMPLIANCE_DIFF_IS_NOOP = "audit_compliance_diff_is_noop";
    public static final String COMPLIANCE_DIFF_CONTENT = "audit_compliance_diff_content";
    public static final String COMPLIANCE_FILE_INFOS = "audit_compliance_file_infos";
    public static final String REQUEST_LAYER = "audit_request_layer";
    public static final String COMPLIANCE_OPERATION = "audit_compliance_operation";
    public static final String COMPLIANCE_DOC_VERSION = "audit_compliance_doc_version";
    private static final DateTimeFormatter DEFAULT_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private final Map<String, Object> auditInfo = new HashMap<String, Object>(50);
    private final AuditCategory msgCategory;

    public AuditMessage(AuditCategory msgCategory, ClusterService clusterService, AuditLog.Origin origin, AuditLog.Origin layer) {
        this.msgCategory = Objects.requireNonNull(msgCategory);
        String currentTime = this.currentTime();
        this.auditInfo.put(FORMAT_VERSION, 4);
        this.auditInfo.put(CATEGORY, (Object)Objects.requireNonNull(msgCategory));
        this.auditInfo.put(UTC_TIMESTAMP, currentTime);
        this.auditInfo.put(NODE_HOST_ADDRESS, Objects.requireNonNull(clusterService).localNode().getHostAddress());
        this.auditInfo.put(NODE_ID, Objects.requireNonNull(clusterService).localNode().getId());
        this.auditInfo.put(NODE_HOST_NAME, Objects.requireNonNull(clusterService).localNode().getHostName());
        this.auditInfo.put(NODE_NAME, Objects.requireNonNull(clusterService).localNode().getName());
        this.auditInfo.put(CLUSTER_NAME, Objects.requireNonNull(clusterService).getClusterName().value());
        if (origin != null) {
            this.auditInfo.put(ORIGIN, (Object)origin);
        }
        if (layer != null) {
            this.auditInfo.put(REQUEST_LAYER, (Object)layer);
        }
    }

    public void addRemoteAddress(TransportAddress remoteAddress) {
        if (remoteAddress != null && remoteAddress.getAddress() != null) {
            this.auditInfo.put(REMOTE_ADDRESS, remoteAddress.getAddress());
        }
    }

    public void addIsAdminDn(boolean isAdminDn) {
        this.auditInfo.put(IS_ADMIN_DN, isAdminDn);
    }

    public void addException(Throwable t) {
        if (t != null) {
            this.auditInfo.put(EXCEPTION, ExceptionsHelper.stackTrace((Throwable)t));
        }
    }

    public void addPrivilege(String priv) {
        if (priv != null) {
            this.auditInfo.put(PRIVILEGE, priv);
        }
    }

    public void addInitiatingUser(String user) {
        if (user != null) {
            this.auditInfo.put(REQUEST_INITIATING_USER, user);
        }
    }

    public void addEffectiveUser(String user) {
        if (user != null) {
            this.auditInfo.put(REQUEST_EFFECTIVE_USER, user);
        }
    }

    public void addPath(String path) {
        if (path != null) {
            this.auditInfo.put(REST_REQUEST_PATH, path);
        }
    }

    public void addComplianceWriteDiffSource(String diff) {
        if (diff != null && !diff.isEmpty()) {
            this.auditInfo.put(COMPLIANCE_DIFF_CONTENT, diff);
            this.auditInfo.put(COMPLIANCE_DIFF_IS_NOOP, false);
        } else if (diff != null && diff.isEmpty()) {
            this.auditInfo.put(COMPLIANCE_DIFF_IS_NOOP, true);
        }
    }

    void addSecurityConfigWriteDiffSource(String diff, String id) {
        this.addComplianceWriteDiffSource(this.redactSecurityConfigContent(diff, id));
    }

    public void addTupleToRequestBody(Tuple<MediaType, BytesReference> xContentTuple) {
        if (xContentTuple != null) {
            try {
                this.auditInfo.put(REQUEST_BODY, XContentHelper.convertToJson((BytesReference)((BytesReference)xContentTuple.v2()), (boolean)false, (MediaType)((MediaType)xContentTuple.v1())));
            }
            catch (Exception e) {
                this.auditInfo.put(REQUEST_BODY, "ERROR: Unable to convert to json because of " + e.toString());
            }
        }
    }

    public void addMapToRequestBody(Map<String, ?> map) {
        if (map != null) {
            this.auditInfo.put(REQUEST_BODY, Utils.convertStructuredMapToJson(map));
        }
    }

    public void addUnescapedJsonToRequestBody(String source) {
        if (source != null) {
            this.auditInfo.put(REQUEST_BODY, source);
        }
    }

    private String redactSecurityConfigContent(String content, String id) {
        if (content != null && INTERNALUSERS_DOC_ID.equals(id)) {
            content = BCRYPT_HASH.matcher(content).replaceAll(BCRYPT_HASH_REPLACEMENT_VALUE);
        }
        return content;
    }

    void addSecurityConfigContentToRequestBody(String source, String id) {
        if (source != null) {
            String redactedContent = this.redactSecurityConfigContent(source, id);
            this.auditInfo.put(REQUEST_BODY, redactedContent);
        }
    }

    void addSecurityConfigTupleToRequestBody(Tuple<XContentType, BytesReference> xContentTuple, String id) {
        if (xContentTuple != null) {
            try {
                this.addSecurityConfigContentToRequestBody(XContentHelper.convertToJson((BytesReference)((BytesReference)xContentTuple.v2()), (boolean)false, (MediaType)((MediaType)xContentTuple.v1())), id);
            }
            catch (Exception e) {
                this.auditInfo.put(REQUEST_BODY, "ERROR: Unable to convert to json");
            }
        }
    }

    void addSecurityConfigMapToRequestBody(Map<String, ?> map, String id) {
        if (map != null) {
            this.addSecurityConfigContentToRequestBody(Utils.convertStructuredMapToJson(map), id);
        }
    }

    public void addRequestType(String requestType) {
        if (requestType != null) {
            this.auditInfo.put(TRANSPORT_REQUEST_TYPE, requestType);
        }
    }

    public void addAction(String action) {
        if (action != null) {
            this.auditInfo.put(TRANSPORT_ACTION, action);
        }
    }

    public void addId(String id) {
        if (id != null) {
            this.auditInfo.put(ID, id);
        }
    }

    public void addFileInfos(Map<String, Path> paths) {
        if (paths != null && !paths.isEmpty()) {
            ArrayList infos = new ArrayList();
            for (Map.Entry<String, Path> path : paths.entrySet()) {
                try {
                    if (!Files.isReadable(path.getValue())) continue;
                    String chcksm = DigestUtils.sha256Hex((byte[])Files.readAllBytes(path.getValue()));
                    FileTime lm = Files.getLastModifiedTime(path.getValue(), LinkOption.NOFOLLOW_LINKS);
                    HashMap<String, String> innerInfos = new HashMap<String, String>();
                    innerInfos.put("sha256", chcksm);
                    innerInfos.put("last_modified", this.formatTime(lm.toMillis()));
                    innerInfos.put("key", path.getKey());
                    innerInfos.put("path", path.getValue().toAbsolutePath().toString());
                    infos.add(innerInfos);
                }
                catch (Throwable throwable) {}
            }
            this.auditInfo.put(COMPLIANCE_FILE_INFOS, infos);
        }
    }

    public void addIndices(String[] indices) {
        if (indices != null && indices.length > 0) {
            this.auditInfo.put(INDICES, indices);
        }
    }

    public void addResolvedIndices(String[] resolvedIndices) {
        if (resolvedIndices != null && resolvedIndices.length > 0) {
            this.auditInfo.put(RESOLVED_INDICES, resolvedIndices);
        }
    }

    public void addTaskId(long id) {
        this.auditInfo.put(TASK_ID, this.auditInfo.get(NODE_ID) + ":" + id);
    }

    public void addShardId(ShardId id) {
        if (id != null) {
            this.auditInfo.put(SHARD_ID, id.getId());
        }
    }

    public void addTaskParentId(String id) {
        if (id != null) {
            this.auditInfo.put(TASK_PARENT_ID, id);
        }
    }

    public void addRestParams(Map<String, String> params, AuditConfig.Filter filter) {
        if (params != null && !params.isEmpty()) {
            HashMap<String, String> redactedParams = new HashMap<String, String>();
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (filter != null && filter.shouldExcludeUrlParam(param.getKey())) {
                    redactedParams.put(param.getKey(), "REDACTED");
                    continue;
                }
                redactedParams.put(param.getKey(), param.getValue());
            }
            this.auditInfo.put(REST_REQUEST_PARAMS, redactedParams);
        }
    }

    public void addRestHeaders(Map<String, List<String>> headers, boolean excludeSensitiveHeaders, AuditConfig.Filter filter) {
        if (headers != null && !headers.isEmpty()) {
            HashMap<String, List<String>> headersClone = new HashMap<String, List<String>>(headers);
            if (excludeSensitiveHeaders) {
                headersClone.keySet().removeIf(AUTHORIZATION_HEADER);
            }
            if (filter != null) {
                headersClone.entrySet().removeIf(entry -> filter.shouldExcludeHeader((String)entry.getKey()));
            }
            this.auditInfo.put(REST_REQUEST_HEADERS, headersClone);
        }
    }

    void addRestMethod(RestRequest.Method method) {
        if (method != null) {
            this.auditInfo.put(REST_REQUEST_METHOD, method);
        }
    }

    void addRestRequestInfo(SecurityRequest request, AuditConfig.Filter filter) {
        if (request != null) {
            String path = request.path().toString();
            this.addPath(path);
            this.addRestHeaders(request.getHeaders(), filter.shouldExcludeSensitiveHeaders(), filter);
            this.addRestParams(request.params(), filter);
            this.addRestMethod(request.method());
            if (filter.shouldLogRequestBody()) {
                if (!(request instanceof OpenSearchRequest)) {
                    return;
                }
                OpenSearchRequest securityRestRequest = (OpenSearchRequest)request;
                RestRequest restRequest = securityRestRequest.breakEncapsulationForRequest();
                if (!restRequest.hasContentOrSourceParam()) {
                    return;
                }
                try {
                    Tuple xContentTuple = restRequest.contentOrSourceParam();
                    String requestBody = XContentHelper.convertToJson((BytesReference)((BytesReference)xContentTuple.v2()), (boolean)false, (MediaType)((MediaType)xContentTuple.v1()));
                    if (path != null && requestBody != null && SENSITIVE_PATHS.matcher(path).matches() && requestBody.contains(SENSITIVE_KEY)) {
                        this.auditInfo.put(REQUEST_BODY, SENSITIVE_REPLACEMENT_VALUE);
                    } else {
                        this.auditInfo.put(REQUEST_BODY, requestBody);
                    }
                }
                catch (Exception e) {
                    this.auditInfo.put(REQUEST_BODY, "ERROR: Unable to generate request body");
                    log.error("Error while generating request body for audit log", (Throwable)e);
                }
            }
        }
    }

    public void addTransportHeaders(Map<String, String> headers, boolean excludeSensitiveHeaders) {
        if (headers != null && !headers.isEmpty()) {
            HashMap<String, String> headersClone = new HashMap<String, String>(headers);
            if (excludeSensitiveHeaders) {
                headersClone.keySet().removeIf(AUTHORIZATION_HEADER);
            }
            this.auditInfo.put(TRANSPORT_REQUEST_HEADERS, headersClone);
        }
    }

    public void addComplianceOperation(AuditLog.Operation op) {
        if (op != null) {
            this.auditInfo.put(COMPLIANCE_OPERATION, (Object)op);
        }
    }

    public void addComplianceDocVersion(long version) {
        this.auditInfo.put(COMPLIANCE_DOC_VERSION, version);
    }

    public Map<String, Object> getAsMap() {
        return new HashMap<String, Object>(this.auditInfo);
    }

    public String getInitiatingUser() {
        return (String)this.auditInfo.get(REQUEST_INITIATING_USER);
    }

    public String getEffectiveUser() {
        return (String)this.auditInfo.get(REQUEST_EFFECTIVE_USER);
    }

    public String getRequestType() {
        return (String)this.auditInfo.get(TRANSPORT_REQUEST_TYPE);
    }

    public RestRequest.Method getRequestMethod() {
        return (RestRequest.Method)this.auditInfo.get(REST_REQUEST_METHOD);
    }

    public AuditCategory getCategory() {
        return this.msgCategory;
    }

    public AuditLog.Origin getOrigin() {
        return (AuditLog.Origin)((Object)this.auditInfo.get(ORIGIN));
    }

    public String getPrivilege() {
        return (String)this.auditInfo.get(PRIVILEGE);
    }

    public String getExceptionStackTrace() {
        return (String)this.auditInfo.get(EXCEPTION);
    }

    public String getRequestBody() {
        return (String)this.auditInfo.get(REQUEST_BODY);
    }

    public String getNodeId() {
        return (String)this.auditInfo.get(NODE_ID);
    }

    public String getDocId() {
        return (String)this.auditInfo.get(ID);
    }

    public String toString() {
        try {
            return JsonXContent.contentBuilder().map(this.getAsMap()).toString();
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    public String toPrettyString() {
        try {
            return JsonXContent.contentBuilder().prettyPrint().map(this.getAsMap()).toString();
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    public String toText() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.getAsMap().entrySet()) {
            AuditMessage.addIfNonEmpty(builder, entry.getKey(), this.stringOrNull(entry.getValue()));
        }
        return builder.toString();
    }

    public final String toJson() {
        return this.toString();
    }

    public String toUrlParameters() {
        URIBuilder builder = new URIBuilder();
        for (Map.Entry<String, Object> entry : this.getAsMap().entrySet()) {
            builder.addParameter(entry.getKey(), this.stringOrNull(entry.getValue()));
        }
        return builder.toString();
    }

    protected static void addIfNonEmpty(StringBuilder builder, String key, String value) {
        if (!Strings.isEmpty((CharSequence)value)) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(key).append(": ").append(value);
        }
    }

    private String currentTime() {
        DateTime dt = new DateTime(DateTimeZone.UTC);
        return DEFAULT_FORMAT.print((ReadableInstant)dt);
    }

    private String formatTime(long epoch) {
        DateTime dt = new DateTime(epoch, DateTimeZone.UTC);
        return DEFAULT_FORMAT.print((ReadableInstant)dt);
    }

    protected String stringOrNull(Object object) {
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }
}

