/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.plugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Injector;
import org.opensearch.common.inject.Module;
import org.opensearch.common.inject.ModulesBuilder;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.ScriptPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;
import org.opensearch.script.ScriptService;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasources.auth.DataSourceUserAuthorizationHelper;
import org.opensearch.sql.datasources.auth.DataSourceUserAuthorizationHelperImpl;
import org.opensearch.sql.datasources.encryptor.Encryptor;
import org.opensearch.sql.datasources.encryptor.EncryptorImpl;
import org.opensearch.sql.datasources.glue.GlueDataSourceFactory;
import org.opensearch.sql.datasources.model.transport.CreateDataSourceActionResponse;
import org.opensearch.sql.datasources.model.transport.DeleteDataSourceActionResponse;
import org.opensearch.sql.datasources.model.transport.GetDataSourceActionResponse;
import org.opensearch.sql.datasources.model.transport.PatchDataSourceActionResponse;
import org.opensearch.sql.datasources.model.transport.UpdateDataSourceActionResponse;
import org.opensearch.sql.datasources.rest.RestDataSourceQueryAction;
import org.opensearch.sql.datasources.service.DataSourceMetadataStorage;
import org.opensearch.sql.datasources.service.DataSourceServiceImpl;
import org.opensearch.sql.datasources.storage.OpenSearchDataSourceMetadataStorage;
import org.opensearch.sql.datasources.transport.TransportCreateDataSourceAction;
import org.opensearch.sql.datasources.transport.TransportDeleteDataSourceAction;
import org.opensearch.sql.datasources.transport.TransportGetDataSourceAction;
import org.opensearch.sql.datasources.transport.TransportPatchDataSourceAction;
import org.opensearch.sql.datasources.transport.TransportUpdateDataSourceAction;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.legacy.plugin.RestSqlAction;
import org.opensearch.sql.legacy.plugin.RestSqlStatsAction;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.client.OpenSearchNodeClient;
import org.opensearch.sql.opensearch.setting.LegacyOpenDistroSettings;
import org.opensearch.sql.opensearch.setting.OpenSearchSettings;
import org.opensearch.sql.opensearch.storage.OpenSearchDataSourceFactory;
import org.opensearch.sql.opensearch.storage.script.ExpressionScriptEngine;
import org.opensearch.sql.opensearch.storage.serialization.DefaultExpressionSerializer;
import org.opensearch.sql.opensearch.storage.serialization.ExpressionSerializer;
import org.opensearch.sql.plugin.config.OpenSearchPluginModule;
import org.opensearch.sql.plugin.rest.RestPPLQueryAction;
import org.opensearch.sql.plugin.rest.RestPPLStatsAction;
import org.opensearch.sql.plugin.rest.RestQuerySettingsAction;
import org.opensearch.sql.plugin.transport.TransportPPLQueryAction;
import org.opensearch.sql.plugin.transport.TransportPPLQueryResponse;
import org.opensearch.sql.prometheus.storage.PrometheusStorageFactory;
import org.opensearch.sql.spark.asyncquery.AsyncQueryExecutorService;
import org.opensearch.sql.spark.cluster.ClusterManagerEventListener;
import org.opensearch.sql.spark.flint.FlintIndexMetadataService;
import org.opensearch.sql.spark.flint.FlintIndexMetadataServiceImpl;
import org.opensearch.sql.spark.flint.operation.FlintIndexOpFactory;
import org.opensearch.sql.spark.rest.RestAsyncQueryManagementAction;
import org.opensearch.sql.spark.storage.SparkStorageFactory;
import org.opensearch.sql.spark.transport.TransportCancelAsyncQueryRequestAction;
import org.opensearch.sql.spark.transport.TransportCreateAsyncQueryRequestAction;
import org.opensearch.sql.spark.transport.TransportGetAsyncQueryResultAction;
import org.opensearch.sql.spark.transport.config.AsyncExecutorServiceModule;
import org.opensearch.sql.spark.transport.model.CancelAsyncQueryActionResponse;
import org.opensearch.sql.spark.transport.model.CreateAsyncQueryActionResponse;
import org.opensearch.sql.spark.transport.model.GetAsyncQueryResultActionResponse;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.FixedExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

public class SQLPlugin
extends Plugin
implements ActionPlugin,
ScriptPlugin {
    private static final Logger LOGGER = LogManager.getLogger(SQLPlugin.class);
    private ClusterService clusterService;
    private org.opensearch.sql.common.setting.Settings pluginSettings;
    private NodeClient client;
    private DataSourceServiceImpl dataSourceService;
    private Injector injector;

    public String name() {
        return "sql";
    }

    public String description() {
        return "Use sql to query OpenSearch.";
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        Objects.requireNonNull(this.clusterService, "Cluster service is required");
        Objects.requireNonNull(this.pluginSettings, "Cluster settings is required");
        Metrics.getInstance().registerDefaultMetrics();
        return Arrays.asList(new RestHandler[]{new RestPPLQueryAction(), new RestSqlAction(settings, this.injector), new RestSqlStatsAction(settings, restController), new RestPPLStatsAction(settings, restController), new RestQuerySettingsAction(settings, restController), new RestDataSourceQueryAction(), new RestAsyncQueryManagementAction()});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler(new ActionType("cluster:admin/opensearch/ppl", TransportPPLQueryResponse::new), TransportPPLQueryAction.class, new Class[0]), new ActionPlugin.ActionHandler(new ActionType("cluster:admin/opensearch/ql/datasources/create", CreateDataSourceActionResponse::new), TransportCreateDataSourceAction.class, new Class[0]), new ActionPlugin.ActionHandler(new ActionType("cluster:admin/opensearch/ql/datasources/read", GetDataSourceActionResponse::new), TransportGetDataSourceAction.class, new Class[0]), new ActionPlugin.ActionHandler(new ActionType("cluster:admin/opensearch/ql/datasources/update", UpdateDataSourceActionResponse::new), TransportUpdateDataSourceAction.class, new Class[0]), new ActionPlugin.ActionHandler(new ActionType("cluster:admin/opensearch/ql/datasources/patch", PatchDataSourceActionResponse::new), TransportPatchDataSourceAction.class, new Class[0]), new ActionPlugin.ActionHandler(new ActionType("cluster:admin/opensearch/ql/datasources/delete", DeleteDataSourceActionResponse::new), TransportDeleteDataSourceAction.class, new Class[0]), new ActionPlugin.ActionHandler(new ActionType("cluster:admin/opensearch/ql/async_query/create", CreateAsyncQueryActionResponse::new), TransportCreateAsyncQueryRequestAction.class, new Class[0]), new ActionPlugin.ActionHandler(new ActionType("cluster:admin/opensearch/ql/async_query/result", GetAsyncQueryResultActionResponse::new), TransportGetAsyncQueryResultAction.class, new Class[0]), new ActionPlugin.ActionHandler(new ActionType("cluster:admin/opensearch/ql/async_query/delete", CancelAsyncQueryActionResponse::new), TransportCancelAsyncQueryRequestAction.class, new Class[0]));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry contentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.clusterService = clusterService;
        this.pluginSettings = new OpenSearchSettings(clusterService.getClusterSettings());
        this.client = (NodeClient)client;
        this.dataSourceService = this.createDataSourceService();
        this.dataSourceService.createDataSource(DataSourceMetadata.defaultOpenSearchDataSourceMetadata());
        LocalClusterState.state().setClusterService(clusterService);
        LocalClusterState.state().setPluginSettings((OpenSearchSettings)this.pluginSettings);
        LocalClusterState.state().setClient(client);
        ModulesBuilder modules = new ModulesBuilder();
        modules.add(new Module[]{new OpenSearchPluginModule()});
        modules.add(new Module[]{b -> {
            b.bind(NodeClient.class).toInstance((Object)((NodeClient)client));
            b.bind(org.opensearch.sql.common.setting.Settings.class).toInstance((Object)this.pluginSettings);
            b.bind(DataSourceService.class).toInstance((Object)this.dataSourceService);
            b.bind(ClusterService.class).toInstance((Object)clusterService);
        }});
        modules.add(new Module[]{new AsyncExecutorServiceModule()});
        this.injector = modules.createInjector();
        ClusterManagerEventListener clusterManagerEventListener = new ClusterManagerEventListener(clusterService, threadPool, client, Clock.systemUTC(), OpenSearchSettings.SESSION_INDEX_TTL_SETTING, OpenSearchSettings.RESULT_INDEX_TTL_SETTING, OpenSearchSettings.STREAMING_JOB_HOUSEKEEPER_INTERVAL_SETTING, OpenSearchSettings.AUTO_INDEX_MANAGEMENT_ENABLED_SETTING, environment.settings(), (DataSourceService)this.dataSourceService, (FlintIndexMetadataService)this.injector.getInstance(FlintIndexMetadataServiceImpl.class), (FlintIndexOpFactory)this.injector.getInstance(FlintIndexOpFactory.class));
        return ImmutableList.of((Object)this.dataSourceService, (Object)this.injector.getInstance(AsyncQueryExecutorService.class), (Object)clusterManagerEventListener, (Object)this.pluginSettings);
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return Collections.singletonList(new FixedExecutorBuilder(settings, "sql-worker", OpenSearchExecutors.allocatedProcessors((Settings)settings), 1000, null));
    }

    public List<Setting<?>> getSettings() {
        return new ImmutableList.Builder().addAll((Iterable)LegacyOpenDistroSettings.legacySettings()).addAll((Iterable)OpenSearchSettings.pluginSettings()).addAll((Iterable)OpenSearchSettings.pluginNonDynamicSettings()).build();
    }

    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
        return new ExpressionScriptEngine((ExpressionSerializer)new DefaultExpressionSerializer());
    }

    private DataSourceServiceImpl createDataSourceService() {
        String masterKey = (String)OpenSearchSettings.DATASOURCE_MASTER_SECRET_KEY.get(this.clusterService.getSettings());
        if (StringUtils.isEmpty((CharSequence)masterKey)) {
            LOGGER.warn("Master key is a required config for using create and update datasource APIs. Please set plugins.query.datasources.encryption.masterkey config in opensearch.yml in all the cluster nodes. More details can be found here: https://github.com/opensearch-project/sql/blob/main/docs/user/ppl/admin/datasources.rst#master-key-config-for-encrypting-credential-information");
        }
        OpenSearchDataSourceMetadataStorage dataSourceMetadataStorage = new OpenSearchDataSourceMetadataStorage((Client)this.client, this.clusterService, (Encryptor)new EncryptorImpl(masterKey));
        DataSourceUserAuthorizationHelperImpl dataSourceUserAuthorizationHelper = new DataSourceUserAuthorizationHelperImpl((Client)this.client);
        return new DataSourceServiceImpl((Set)new ImmutableSet.Builder().add((Object)new OpenSearchDataSourceFactory((OpenSearchClient)new OpenSearchNodeClient(this.client), this.pluginSettings)).add((Object)new PrometheusStorageFactory(this.pluginSettings)).add((Object)new SparkStorageFactory((Client)this.client, this.pluginSettings)).add((Object)new GlueDataSourceFactory(this.pluginSettings)).build(), (DataSourceMetadataStorage)dataSourceMetadataStorage, (DataSourceUserAuthorizationHelper)dataSourceUserAuthorizationHelper);
    }
}

