/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.config;

import java.security.AccessController;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.cluster.ClusterName;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.config.OpenSearchSparkSubmitParameterModifier;
import org.opensearch.sql.spark.config.SparkExecutionEngineConfig;
import org.opensearch.sql.spark.config.SparkExecutionEngineConfigClusterSetting;
import org.opensearch.sql.spark.config.SparkExecutionEngineConfigSupplier;

public class SparkExecutionEngineConfigSupplierImpl
implements SparkExecutionEngineConfigSupplier {
    private Settings settings;

    @Override
    public SparkExecutionEngineConfig getSparkExecutionEngineConfig(AsyncQueryRequestContext asyncQueryRequestContext) {
        ClusterName clusterName = (ClusterName)this.settings.getSettingValue(Settings.Key.CLUSTER_NAME);
        return this.getBuilderFromSettingsIfAvailable().clusterName(clusterName.value()).build();
    }

    private SparkExecutionEngineConfig.SparkExecutionEngineConfigBuilder getBuilderFromSettingsIfAvailable() {
        String sparkExecutionEngineConfigSettingString = (String)this.settings.getSettingValue(Settings.Key.SPARK_EXECUTION_ENGINE_CONFIG);
        if (!StringUtils.isBlank((CharSequence)sparkExecutionEngineConfigSettingString)) {
            SparkExecutionEngineConfigClusterSetting setting = AccessController.doPrivileged(() -> SparkExecutionEngineConfigClusterSetting.toSparkExecutionEngineConfig(sparkExecutionEngineConfigSettingString));
            return SparkExecutionEngineConfig.builder().applicationId(setting.getApplicationId()).executionRoleARN(setting.getExecutionRoleARN()).sparkSubmitParameterModifier(new OpenSearchSparkSubmitParameterModifier(setting.getSparkSubmitParameters())).region(setting.getRegion());
        }
        return SparkExecutionEngineConfig.builder();
    }

    @Generated
    public SparkExecutionEngineConfigSupplierImpl(Settings settings) {
        this.settings = settings;
    }
}

