/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.dispatcher;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryJobMetadata;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.dispatcher.AsyncQueryHandler;
import org.opensearch.sql.spark.dispatcher.IndexDMLHandler;
import org.opensearch.sql.spark.dispatcher.QueryHandlerFactory;
import org.opensearch.sql.spark.dispatcher.QueryIdProvider;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryContext;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryRequest;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryResponse;
import org.opensearch.sql.spark.dispatcher.model.IndexQueryActionType;
import org.opensearch.sql.spark.dispatcher.model.IndexQueryDetails;
import org.opensearch.sql.spark.dispatcher.model.JobType;
import org.opensearch.sql.spark.execution.session.SessionManager;
import org.opensearch.sql.spark.rest.model.LangType;
import org.opensearch.sql.spark.utils.SQLQueryUtils;

public class SparkQueryDispatcher {
    public static final String INDEX_TAG_KEY = "index";
    public static final String DATASOURCE_TAG_KEY = "datasource";
    public static final String CLUSTER_NAME_TAG_KEY = "domain_ident";
    public static final String JOB_TYPE_TAG_KEY = "type";
    private final DataSourceService dataSourceService;
    private final SessionManager sessionManager;
    private final QueryHandlerFactory queryHandlerFactory;
    private final QueryIdProvider queryIdProvider;

    public DispatchQueryResponse dispatch(DispatchQueryRequest dispatchQueryRequest, AsyncQueryRequestContext asyncQueryRequestContext) {
        DataSourceMetadata dataSourceMetadata = this.dataSourceService.verifyDataSourceAccessAndGetRawMetadata(dispatchQueryRequest.getDatasource());
        if (LangType.SQL.equals((Object)dispatchQueryRequest.getLangType()) && SQLQueryUtils.isFlintExtensionQuery(dispatchQueryRequest.getQuery())) {
            IndexQueryDetails indexQueryDetails = SparkQueryDispatcher.getIndexQueryDetails(dispatchQueryRequest);
            DispatchQueryContext context = this.getDefaultDispatchContextBuilder(dispatchQueryRequest, dataSourceMetadata).indexQueryDetails(indexQueryDetails).asyncQueryRequestContext(asyncQueryRequestContext).build();
            return this.getQueryHandlerForFlintExtensionQuery(indexQueryDetails).submit(dispatchQueryRequest, context);
        }
        DispatchQueryContext context = this.getDefaultDispatchContextBuilder(dispatchQueryRequest, dataSourceMetadata).asyncQueryRequestContext(asyncQueryRequestContext).build();
        return this.getDefaultAsyncQueryHandler().submit(dispatchQueryRequest, context);
    }

    private DispatchQueryContext.DispatchQueryContextBuilder getDefaultDispatchContextBuilder(DispatchQueryRequest dispatchQueryRequest, DataSourceMetadata dataSourceMetadata) {
        return DispatchQueryContext.builder().dataSourceMetadata(dataSourceMetadata).tags(SparkQueryDispatcher.getDefaultTagsForJobSubmission(dispatchQueryRequest)).queryId(this.queryIdProvider.getQueryId(dispatchQueryRequest));
    }

    private AsyncQueryHandler getQueryHandlerForFlintExtensionQuery(IndexQueryDetails indexQueryDetails) {
        if (this.isEligibleForIndexDMLHandling(indexQueryDetails)) {
            return this.queryHandlerFactory.getIndexDMLHandler();
        }
        if (this.isEligibleForStreamingQuery(indexQueryDetails)) {
            return this.queryHandlerFactory.getStreamingQueryHandler();
        }
        if (IndexQueryActionType.CREATE.equals((Object)indexQueryDetails.getIndexQueryActionType())) {
            return this.queryHandlerFactory.getBatchQueryHandler();
        }
        if (IndexQueryActionType.REFRESH.equals((Object)indexQueryDetails.getIndexQueryActionType())) {
            return this.queryHandlerFactory.getRefreshQueryHandler();
        }
        return this.getDefaultAsyncQueryHandler();
    }

    @NotNull
    private AsyncQueryHandler getDefaultAsyncQueryHandler() {
        return this.sessionManager.isEnabled() ? this.queryHandlerFactory.getInteractiveQueryHandler() : this.queryHandlerFactory.getBatchQueryHandler();
    }

    @NotNull
    private static IndexQueryDetails getIndexQueryDetails(DispatchQueryRequest dispatchQueryRequest) {
        IndexQueryDetails indexQueryDetails = SQLQueryUtils.extractIndexDetails(dispatchQueryRequest.getQuery());
        SparkQueryDispatcher.fillDatasourceName(dispatchQueryRequest, indexQueryDetails);
        return indexQueryDetails;
    }

    private boolean isEligibleForStreamingQuery(IndexQueryDetails indexQueryDetails) {
        Boolean isCreateAutoRefreshIndex = IndexQueryActionType.CREATE.equals((Object)indexQueryDetails.getIndexQueryActionType()) && indexQueryDetails.getFlintIndexOptions().autoRefresh();
        Boolean isAlterQuery = IndexQueryActionType.ALTER.equals((Object)indexQueryDetails.getIndexQueryActionType());
        return isCreateAutoRefreshIndex != false || isAlterQuery != false;
    }

    private boolean isEligibleForIndexDMLHandling(IndexQueryDetails indexQueryDetails) {
        return IndexQueryActionType.DROP.equals((Object)indexQueryDetails.getIndexQueryActionType()) || IndexQueryActionType.VACUUM.equals((Object)indexQueryDetails.getIndexQueryActionType()) || IndexQueryActionType.ALTER.equals((Object)indexQueryDetails.getIndexQueryActionType()) && indexQueryDetails.getFlintIndexOptions().getProvidedOptions().containsKey("auto_refresh") && !indexQueryDetails.getFlintIndexOptions().autoRefresh();
    }

    public JSONObject getQueryResponse(AsyncQueryJobMetadata asyncQueryJobMetadata) {
        return this.getAsyncQueryHandlerForExistingQuery(asyncQueryJobMetadata).getQueryResponse(asyncQueryJobMetadata);
    }

    public String cancelJob(AsyncQueryJobMetadata asyncQueryJobMetadata) {
        return this.getAsyncQueryHandlerForExistingQuery(asyncQueryJobMetadata).cancelJob(asyncQueryJobMetadata);
    }

    private AsyncQueryHandler getAsyncQueryHandlerForExistingQuery(AsyncQueryJobMetadata asyncQueryJobMetadata) {
        if (asyncQueryJobMetadata.getSessionId() != null) {
            return this.queryHandlerFactory.getInteractiveQueryHandler();
        }
        if (IndexDMLHandler.isIndexDMLQuery(asyncQueryJobMetadata.getJobId())) {
            return this.queryHandlerFactory.getIndexDMLHandler();
        }
        if (asyncQueryJobMetadata.getJobType() == JobType.BATCH) {
            return this.queryHandlerFactory.getRefreshQueryHandler();
        }
        if (asyncQueryJobMetadata.getJobType() == JobType.STREAMING) {
            return this.queryHandlerFactory.getStreamingQueryHandler();
        }
        return this.queryHandlerFactory.getBatchQueryHandler();
    }

    private static void fillDatasourceName(DispatchQueryRequest dispatchQueryRequest, IndexQueryDetails indexQueryDetails) {
        if (indexQueryDetails.getFullyQualifiedTableName() != null && indexQueryDetails.getFullyQualifiedTableName().getDatasourceName() == null) {
            indexQueryDetails.getFullyQualifiedTableName().setDatasourceName(dispatchQueryRequest.getDatasource());
        }
    }

    private static Map<String, String> getDefaultTagsForJobSubmission(DispatchQueryRequest dispatchQueryRequest) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(CLUSTER_NAME_TAG_KEY, dispatchQueryRequest.getClusterName());
        tags.put(DATASOURCE_TAG_KEY, dispatchQueryRequest.getDatasource());
        return tags;
    }

    @Generated
    public SparkQueryDispatcher(DataSourceService dataSourceService, SessionManager sessionManager, QueryHandlerFactory queryHandlerFactory, QueryIdProvider queryIdProvider) {
        this.dataSourceService = dataSourceService;
        this.sessionManager = sessionManager;
        this.queryHandlerFactory = queryHandlerFactory;
        this.queryIdProvider = queryIdProvider;
    }
}

