/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.session;

import java.util.Optional;
import lombok.Generated;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.client.EMRServerlessClientFactory;
import org.opensearch.sql.spark.execution.session.CreateSessionRequest;
import org.opensearch.sql.spark.execution.session.InteractiveSession;
import org.opensearch.sql.spark.execution.session.Session;
import org.opensearch.sql.spark.execution.session.SessionConfigSupplier;
import org.opensearch.sql.spark.execution.session.SessionIdProvider;
import org.opensearch.sql.spark.execution.session.SessionModel;
import org.opensearch.sql.spark.execution.statestore.SessionStorageService;
import org.opensearch.sql.spark.execution.statestore.StatementStorageService;
import org.opensearch.sql.spark.utils.RealTimeProvider;

public class SessionManager {
    private final SessionStorageService sessionStorageService;
    private final StatementStorageService statementStorageService;
    private final EMRServerlessClientFactory emrServerlessClientFactory;
    private final SessionConfigSupplier sessionConfigSupplier;
    private final SessionIdProvider sessionIdProvider;

    public Session createSession(CreateSessionRequest request, AsyncQueryRequestContext asyncQueryRequestContext) {
        InteractiveSession session = InteractiveSession.builder().sessionId(this.sessionIdProvider.getSessionId(request)).sessionStorageService(this.sessionStorageService).statementStorageService(this.statementStorageService).serverlessClient(this.emrServerlessClientFactory.getClient()).build();
        session.open(request, asyncQueryRequestContext);
        return session;
    }

    public Optional<Session> getSession(String sessionId, String dataSourceName) {
        Optional<SessionModel> model = this.sessionStorageService.getSession(sessionId, dataSourceName);
        if (model.isPresent()) {
            InteractiveSession session = InteractiveSession.builder().sessionId(sessionId).sessionStorageService(this.sessionStorageService).statementStorageService(this.statementStorageService).serverlessClient(this.emrServerlessClientFactory.getClient()).sessionModel(model.get()).sessionInactivityTimeoutMilli(this.sessionConfigSupplier.getSessionInactivityTimeoutMillis()).timeProvider(new RealTimeProvider()).build();
            return Optional.ofNullable(session);
        }
        return Optional.empty();
    }

    public boolean isEnabled() {
        return true;
    }

    @Generated
    public SessionManager(SessionStorageService sessionStorageService, StatementStorageService statementStorageService, EMRServerlessClientFactory emrServerlessClientFactory, SessionConfigSupplier sessionConfigSupplier, SessionIdProvider sessionIdProvider) {
        this.sessionStorageService = sessionStorageService;
        this.statementStorageService = statementStorageService;
        this.emrServerlessClientFactory = emrServerlessClientFactory;
        this.sessionConfigSupplier = sessionConfigSupplier;
        this.sessionIdProvider = sessionIdProvider;
    }
}

