/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.statestore;

import java.util.Optional;
import lombok.Generated;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.execution.session.SessionModel;
import org.opensearch.sql.spark.execution.session.SessionState;
import org.opensearch.sql.spark.execution.statestore.OpenSearchStateStoreUtil;
import org.opensearch.sql.spark.execution.statestore.SessionStorageService;
import org.opensearch.sql.spark.execution.statestore.StateStore;
import org.opensearch.sql.spark.execution.xcontent.SessionModelXContentSerializer;

public class OpenSearchSessionStorageService
implements SessionStorageService {
    private final StateStore stateStore;
    private final SessionModelXContentSerializer serializer;

    @Override
    public SessionModel createSession(SessionModel sessionModel, AsyncQueryRequestContext asyncQueryRequestContext) {
        return this.stateStore.create(sessionModel.getId(), sessionModel, SessionModel::of, OpenSearchStateStoreUtil.getIndexName(sessionModel.getDatasourceName()));
    }

    @Override
    public Optional<SessionModel> getSession(String id, String datasourceName) {
        return this.stateStore.get(id, this.serializer::fromXContent, OpenSearchStateStoreUtil.getIndexName(datasourceName));
    }

    @Override
    public SessionModel updateSessionState(SessionModel sessionModel, SessionState sessionState) {
        return this.stateStore.updateState(sessionModel, sessionState, SessionModel::copyWithState, OpenSearchStateStoreUtil.getIndexName(sessionModel.getDatasourceName()));
    }

    @Generated
    public OpenSearchSessionStorageService(StateStore stateStore, SessionModelXContentSerializer serializer) {
        this.stateStore = stateStore;
        this.serializer = serializer;
    }
}

