/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.statestore;

import java.util.Optional;
import lombok.Generated;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.execution.statement.StatementModel;
import org.opensearch.sql.spark.execution.statement.StatementState;
import org.opensearch.sql.spark.execution.statestore.OpenSearchStateStoreUtil;
import org.opensearch.sql.spark.execution.statestore.StateStore;
import org.opensearch.sql.spark.execution.statestore.StatementStorageService;
import org.opensearch.sql.spark.execution.xcontent.StatementModelXContentSerializer;

public class OpenSearchStatementStorageService
implements StatementStorageService {
    private final StateStore stateStore;
    private final StatementModelXContentSerializer serializer;

    @Override
    public StatementModel createStatement(StatementModel statementModel, AsyncQueryRequestContext asyncQueryRequestContext) {
        return this.stateStore.create(statementModel.getId(), statementModel, StatementModel::copy, OpenSearchStateStoreUtil.getIndexName(statementModel.getDatasourceName()));
    }

    @Override
    public Optional<StatementModel> getStatement(String id, String datasourceName) {
        return this.stateStore.get(id, this.serializer::fromXContent, OpenSearchStateStoreUtil.getIndexName(datasourceName));
    }

    @Override
    public StatementModel updateStatementState(StatementModel oldStatementModel, StatementState statementState) {
        return this.stateStore.updateState(oldStatementModel, statementState, StatementModel::copyWithState, OpenSearchStateStoreUtil.getIndexName(oldStatementModel.getDatasourceName()));
    }

    @Generated
    public OpenSearchStatementStorageService(StateStore stateStore, StatementModelXContentSerializer serializer) {
        this.stateStore = stateStore;
        this.serializer = serializer;
    }
}

