/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.flint.operation;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.sql.spark.client.EMRServerlessClientFactory;
import org.opensearch.sql.spark.flint.FlintIndexMetadata;
import org.opensearch.sql.spark.flint.FlintIndexState;
import org.opensearch.sql.spark.flint.FlintIndexStateModel;
import org.opensearch.sql.spark.flint.FlintIndexStateModelService;
import org.opensearch.sql.spark.flint.operation.FlintIndexOp;

public class FlintIndexOpVacuum
extends FlintIndexOp {
    private static final Logger LOG = LogManager.getLogger();
    private final Client client;

    public FlintIndexOpVacuum(FlintIndexStateModelService flintIndexStateModelService, String datasourceName, Client client, EMRServerlessClientFactory emrServerlessClientFactory) {
        super(flintIndexStateModelService, datasourceName, emrServerlessClientFactory);
        this.client = client;
    }

    @Override
    boolean validate(FlintIndexState state) {
        return state == FlintIndexState.DELETED;
    }

    @Override
    FlintIndexState transitioningState() {
        return FlintIndexState.VACUUMING;
    }

    @Override
    public void runOp(FlintIndexMetadata flintIndexMetadata, FlintIndexStateModel flintIndex) {
        LOG.info("Vacuuming Flint index {}", (Object)flintIndexMetadata.getOpensearchIndexName());
        DeleteIndexRequest request = new DeleteIndexRequest().indices(new String[]{flintIndexMetadata.getOpensearchIndexName()});
        AcknowledgedResponse response = (AcknowledgedResponse)this.client.admin().indices().delete(request).actionGet();
        LOG.info("OpenSearch index delete result: {}", (Object)response.isAcknowledged());
    }

    @Override
    FlintIndexState stableState() {
        return FlintIndexState.NONE;
    }
}

