/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.transport;

import java.util.Locale;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.opensearch.setting.OpenSearchSettings;
import org.opensearch.sql.protocol.response.format.JsonResponseFormatter;
import org.opensearch.sql.spark.asyncquery.AsyncQueryExecutorService;
import org.opensearch.sql.spark.asyncquery.AsyncQueryExecutorServiceImpl;
import org.opensearch.sql.spark.asyncquery.model.NullAsyncQueryRequestContext;
import org.opensearch.sql.spark.rest.model.CreateAsyncQueryRequest;
import org.opensearch.sql.spark.rest.model.CreateAsyncQueryResponse;
import org.opensearch.sql.spark.transport.model.CreateAsyncQueryActionRequest;
import org.opensearch.sql.spark.transport.model.CreateAsyncQueryActionResponse;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportCreateAsyncQueryRequestAction
extends HandledTransportAction<CreateAsyncQueryActionRequest, CreateAsyncQueryActionResponse> {
    private final AsyncQueryExecutorService asyncQueryExecutorService;
    private final OpenSearchSettings pluginSettings;
    public static final String NAME = "cluster:admin/opensearch/ql/async_query/create";
    public static final ActionType<CreateAsyncQueryActionResponse> ACTION_TYPE = new ActionType("cluster:admin/opensearch/ql/async_query/create", CreateAsyncQueryActionResponse::new);

    @Inject
    public TransportCreateAsyncQueryRequestAction(TransportService transportService, ActionFilters actionFilters, AsyncQueryExecutorServiceImpl jobManagementService, OpenSearchSettings pluginSettings) {
        super(NAME, transportService, actionFilters, CreateAsyncQueryActionRequest::new);
        this.asyncQueryExecutorService = jobManagementService;
        this.pluginSettings = pluginSettings;
    }

    protected void doExecute(Task task, CreateAsyncQueryActionRequest request, ActionListener<CreateAsyncQueryActionResponse> listener) {
        try {
            if (!((Boolean)this.pluginSettings.getSettingValue(Settings.Key.ASYNC_QUERY_ENABLED)).booleanValue()) {
                listener.onFailure((Exception)new IllegalAccessException(String.format(Locale.ROOT, "%s setting is false", Settings.Key.ASYNC_QUERY_ENABLED.getKeyValue())));
                return;
            }
            CreateAsyncQueryRequest createAsyncQueryRequest = request.getCreateAsyncQueryRequest();
            CreateAsyncQueryResponse createAsyncQueryResponse = this.asyncQueryExecutorService.createAsyncQuery(createAsyncQueryRequest, new NullAsyncQueryRequestContext());
            String responseContent = new JsonResponseFormatter<CreateAsyncQueryResponse>(JsonResponseFormatter.Style.PRETTY){

                protected Object buildJsonObject(CreateAsyncQueryResponse response) {
                    return response;
                }
            }.format((Object)createAsyncQueryResponse);
            listener.onResponse((Object)new CreateAsyncQueryActionResponse(responseContent));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

