/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.nio;

import java.nio.ByteBuffer;
import java.util.function.IntFunction;
import org.opensearch.common.recycler.Recycler;
import org.opensearch.common.util.PageCacheRecycler;
import org.opensearch.nio.Page;

public class PageAllocator
implements IntFunction<Page> {
    private static final int RECYCLE_LOWER_THRESHOLD = 8192;
    private final PageCacheRecycler recycler;

    public PageAllocator(PageCacheRecycler recycler) {
        this.recycler = recycler;
    }

    @Override
    public Page apply(int length) {
        if (length >= 8192 && length <= 16384) {
            Recycler.V bytePage = this.recycler.bytePage(false);
            return new Page(ByteBuffer.wrap((byte[])bytePage.v(), 0, length), () -> ((Recycler.V)bytePage).close());
        }
        return new Page(ByteBuffer.allocate(length), () -> {});
    }
}

