#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-G5JuUatn0qkKROBrm6ppQa
key:                  postgrest-10.0.0-G5JuUatn0qkKROBrm6ppQa
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  b0b8db0c6db7a299f0b7332482557664
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.2.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-G5JuUatn0qkKROBrm6ppQa
depends:
    HTTP-4000.4.1-14dSIo5nNQu5mRef8W6oPL
    Ranged-sets-0.4.0-J9gSs4ys8xxIKwffuBKyYk
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI
    auto-update-0.1.6-gY5Mzm24Ra7TgeDXQUCAe base-4.16.4.0
    base64-bytestring-1.2.1.0-6ICZKEZtNauKUlSfxjYXGw
    bytestring-0.11.4.0 case-insensitive-1.2.1.0-GWeOjNQL6o11YPoz7mZGER
    cassava-0.5.3.1-2Iv7RuWGQGp84dKhXwCFDJ
    configurator-pg-0.2.9-KAPGmLRRkZu8ZZEJ0uSiee containers-0.6.5.1
    contravariant-extras-0.3.5.4-KQODmY3btn6QQJWMypRoY
    cookie-0.4.6-ATAyIjNvKdDFVIoN0dB8l5 directory-1.3.6.2
    either-5.0.2-Kad6WPd2dto1urkQ7yKKVk
    gitrev-1.3.1-9lQGgHpaqCODNpyMdeEqev
    hasql-1.5.0.4-EwwIt3octTe20N3tVArhOz
    hasql-dynamic-statements-0.3.1.1-4n9qdbalwvP8kvqA8BKp7h
    hasql-notifications-0.2.0.4-4TEMLHGYxBC8CARBT0UVAO
    hasql-pool-0.5.2.2-2nChITIkXBVK6A0G4MurHl
    hasql-transaction-1.0.1.1-8QgX0oDLgKQ2z4yrEXROQm
    heredoc-0.2.0.0-D3AW9S2AOKs91e3wqBbhAD
    http-types-0.12.4-BQQx2t2WRPFKonJRzK2pM8
    insert-ordered-containers-0.2.5.3-5AWHSXkSaRtlqI83F0ze9
    interpolatedstring-perl6-1.0.2-LfXpVM9TpooD8DOSJFmLkT
    jose-0.10-JDERold0YQy68PeuqweX29 lens-5.2.3-9w28xeY3DMb2UpdPTesfcO
    lens-aeson-1.2.3-DQQ97BPOrPWFoHhQW4h9lj mtl-2.2.2
    network-3.1.4.0-HWJHph1qrvp6tEtZHv7We0
    network-uri-2.6.4.2-BteEq2hoHgh9OCrkgJDHXL
    optparse-applicative-0.17.1.0-Jx8WaQbsFK9BJBRr9ePa2T
    parsec-3.1.15.0 protolude-0.3.4-IjNrj3R5jNp8TzoQiTOoEM
    regex-tdfa-1.3.2.2-Js34ukrBSX51v3nGkmx3s
    retry-0.9.3.1-Hmg98VuIxYTJDRzNEPAg8s
    scientific-0.3.7.0-72r9rPpXaeUjwM4XNBSJR
    swagger2-2.8.8-HpsJUfoGjg66GnxFm1OZbh text-1.2.5.0 time-1.11.1.1
    unix-2.7.2.2 unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    vault-0.3.1.5-A4AAN4O0TH9F8wPwf0MzPd
    vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe
    wai-3.2.4-F4LWzzhSgqd90OuFMQ1Kx1
    wai-cors-0.2.7-Hi1uxxHmRYpB24c0A2kby0
    wai-extra-3.1.15-3qbvQaSr7k23W6UoKe8gsz
    wai-logger-2.4.0-FJHzVKHXUWa3TNjjgcjABv
    warp-3.3.30-JHUoXLMS4FILpIjCS0pSyJ

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

