#        Configuration file for 3rd party vigranumpy modules
#        
#        Usage:
#            find_package(Vigranumpy REQUIRED PATHS ${Vigranumpy_DIR}) # set Vigranumpy_DIR default paths fail
#            add_vigranumpy_module(myModule SOURCES myModule.cxx ... [LIBRARIES extralib.lib ...])
#
get_filename_component(SELF_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

# turn relative paths to includes and libraries back into absolute paths
set(VIGRANUMPY_INCLUDE_DIRS "")
foreach(PATH ../../include;../python3.12/site-packages/numpy/_core/include;../../include/python3.12;../../include)
    get_filename_component(ABSPATH ${SELF_DIR}/${PATH} ABSOLUTE)
    set(VIGRANUMPY_INCLUDE_DIRS ${VIGRANUMPY_INCLUDE_DIRS} ${ABSPATH})
endforeach(PATH)

set(VIGRANUMPY_LIBRARIES "")
foreach(PATH ../libpython3.12.so;../libboost_python3.so)
    get_filename_component(ABSPATH ${SELF_DIR}/${PATH} ABSOLUTE)
    set(VIGRANUMPY_LIBRARIES ${VIGRANUMPY_LIBRARIES} ${ABSPATH})
endforeach(PATH)

FUNCTION(add_vigranumpy_module target)
    
    # parse the args
    set(v SOURCES)
    foreach(i ${ARGN})
        if(${i} MATCHES "^SOURCES$")
            set(v SOURCES)
        elseif(${i} MATCHES "^LIBRARIES$")
            set(v LIBRARIES)
        else()
            set(${v} ${${v}} ${i})
        endif()
    endforeach(i)
    
    set(TARGET_NAME ${target})
    set(LIBRARY_NAME ${target})

    include_directories(${VIGRANUMPY_INCLUDE_DIRS})
    
    ADD_LIBRARY(${TARGET_NAME} SHARED ${SOURCES})    
    
    if(DEFINED LIBRARIES)
        TARGET_LINK_LIBRARIES(${TARGET_NAME} ${LIBRARIES})
    endif()
    
    TARGET_LINK_LIBRARIES(${TARGET_NAME} ${VIGRANUMPY_LIBRARIES})
    
    # configure boost's autolink magic to use the right library name
    # (default on Windows is a mangled name like 'boost_python-vc110-mt-1_51.lib')
    if("${VIGRANUMPY_LIBRARIES}" MATCHES "boost_python\\.lib")
        ADD_DEFINITIONS(-DBOOST_AUTO_LINK_NOMANGLE)
    endif()
    
    IF(WIN32 AND NOT MINGW)
        SET_TARGET_PROPERTIES(${TARGET_NAME} PROPERTIES OUTPUT_NAME "${LIBRARY_NAME}" 
                                                           PREFIX "" SUFFIX  ".pyd")
    ELSEIF(APPLE)
        SET_TARGET_PROPERTIES(${TARGET_NAME} PROPERTIES OUTPUT_NAME "${LIBRARY_NAME}" PREFIX "" SUFFIX ".so")
    ELSE()
        SET_TARGET_PROPERTIES(${TARGET_NAME} PROPERTIES OUTPUT_NAME "${LIBRARY_NAME}" 
                                                           PREFIX "")
    ENDIF()
ENDFUNCTION(add_vigranumpy_module)
